import redhat from '.';

describe('modules/versioning/redhat/index', () => {
  it.each`
    input                     | expected
    ${'1'}                    | ${true}
    ${'17.04'}                | ${true}
    ${'9.0.0'}                | ${true}
    ${'1-632'}                | ${true}
    ${'1.2-62'}               | ${true}
    ${'1.2.3-62'}             | ${true}
    ${'8.5-239.1651231664'}   | ${true}
    ${'8.5.0-239.1651231664'} | ${true}
    ${'9.0.0-62'}             | ${true}
    ${'v0.4.0-383'}           | ${true}
    ${'1.2.3.4-62'}           | ${false}
    ${'1.2.3 -62'}            | ${false}
    ${'8.5-'}                 | ${false}
    ${'3.0.0-beta'}           | ${false}
    ${'2.0.2-pre2019100318'}  | ${false}
    ${'1.0.0+c30d7625'}       | ${false}
    ${'2.3.4-beta+1990ef74'}  | ${false}
    ${'5.1.2-+'}              | ${false}
    ${'5.1.2+1'}              | ${false}
  `('isValid("$input") === $expected', ({ input, expected }) => {
    expect(redhat.isValid(input)).toBe(expected);
  });

  it.each`
    a                          | b                       | expected
    ${'3-57'}                  | ${'3-2'}                | ${true}
    ${'8.6'}                   | ${'8.4'}                | ${true}
    ${'3.2.32-12'}             | ${'2.3.7-15'}           | ${true}
    ${'7.9-49'}                | ${'7.9-46'}             | ${true}
    ${'1-121'}                 | ${'1-81.1618436879'}    | ${true}
    ${'7.7-18.1575996389'}     | ${'7.7-18'}             | ${true}
    ${'7.9-698.1655292976'}    | ${'7.9-628'}            | ${true}
    ${'7.9-698.1655292976'}    | ${'7.9-628.1645808164'} | ${true}
    ${'7.9-698.1655292976'}    | ${'7.9-698.1645808164'} | ${true}
    ${'8.6-754.1655117782'}    | ${'8.5-239.1651231664'} | ${true}
    ${'8.6-754.1655117782'}    | ${'8.5-754.1651231664'} | ${true}
    ${'8.6-754.1652117782'}    | ${'8.5-754.1651231664'} | ${true}
    ${'8.45-754.1652117782'}   | ${'8.5-754.1651231664'} | ${true}
    ${'8.6-754.1655117782'}    | ${'8.6-754'}            | ${true}
    ${'9.0.0-1471'}            | ${'9.0.0'}              | ${true}
    ${'9.0.0-1471.1655190711'} | ${'9.0.0-1471'}         | ${true}
    ${undefined}               | ${'1.2.0'}              | ${true}
    ${'1.2.0'}                 | ${'1.2.0-2'}            | ${false}
    ${'1.9'}                   | ${'2'}                  | ${false}
    ${'1.9'}                   | ${'1.9.1'}              | ${false}
    ${'2.4.0-50'}              | ${'2.4.0-51'}           | ${false}
    ${'2.4.0-51'}              | ${'2.4.0-51'}           | ${false}
    ${'1-19'}                  | ${'1-19.1655193074'}    | ${false}
    ${'8.5-754.1651117782'}    | ${'8.5-754.1652231664'} | ${false}
  `('isGreaterThan($a, $b) === $expected', ({ a, b, expected }) => {
    expect(redhat.isGreaterThan(a, b)).toBe(expected);
  });
});
