import { getHighestVulnerabilitySeverity } from './utils';

describe('util/vulnerability/utils', () => {
  it('parent CRITICAL vulnerability severity rating is maintained', () => {
    const parentConfig = {
      vulnerabilitySeverity: 'CRITICAL',
    };

    const childConfig = {
      vulnerabilitySeverity: 'MODERATE',
    };

    const severity = getHighestVulnerabilitySeverity(parentConfig, childConfig);

    expect(severity).toBe('CRITICAL');
  });

  it('child CRITICAL vulnerability severity rating is maintained', () => {
    const parentConfig = {
      vulnerabilitySeverity: 'MODERATE',
    };

    const childConfig = {
      vulnerabilitySeverity: 'CRITICAL',
    };

    const severity = getHighestVulnerabilitySeverity(parentConfig, childConfig);

    expect(severity).toBe('CRITICAL');
  });

  it('parent HIGH vulnerability severity rating is maintained', () => {
    const parentConfig = {
      vulnerabilitySeverity: 'HIGH',
    };

    const childConfig = {
      vulnerabilitySeverity: 'MODERATE',
    };

    const severity = getHighestVulnerabilitySeverity(parentConfig, childConfig);

    expect(severity).toBe('HIGH');
  });

  it('child HIGH vulnerability severity rating is maintained', () => {
    const parentConfig = {
      vulnerabilitySeverity: 'MODERATE',
    };

    const childConfig = {
      vulnerabilitySeverity: 'HIGH',
    };

    const severity = getHighestVulnerabilitySeverity(parentConfig, childConfig);

    expect(severity).toBe('HIGH');
  });

  it('parent MODERATE vulnerability severity rating is maintained', () => {
    const parentConfig = {
      vulnerabilitySeverity: 'MODERATE',
    };

    const childConfig = {
      vulnerabilitySeverity: 'LOW',
    };

    const severity = getHighestVulnerabilitySeverity(parentConfig, childConfig);

    expect(severity).toBe('MODERATE');
  });

  it('child MODERATE vulnerability severity rating is maintained', () => {
    const parentConfig = {
      vulnerabilitySeverity: 'LOW',
    };

    const childConfig = {
      vulnerabilitySeverity: 'MODERATE',
    };

    const severity = getHighestVulnerabilitySeverity(parentConfig, childConfig);

    expect(severity).toBe('MODERATE');
  });

  it('child MEDIUM vulnerability severity rating is maintained', () => {
    const parentConfig = {
      vulnerabilitySeverity: 'LOW',
    };

    const childConfig = {
      vulnerabilitySeverity: 'MEDIUM',
    };

    const severity = getHighestVulnerabilitySeverity(parentConfig, childConfig);

    expect(severity).toBe('MEDIUM');
  });

  it('parent LOW vulnerability severity rating is maintained', () => {
    const parentConfig = {
      vulnerabilitySeverity: 'LOW',
    };

    const childConfig = {
      vulnerabilitySeverity: undefined,
    };

    const severity = getHighestVulnerabilitySeverity(parentConfig, childConfig);

    expect(severity).toBe('LOW');
  });

  it('child LOW vulnerability severity rating is maintained', () => {
    const parentConfig = {
      vulnerabilitySeverity: undefined,
    };

    const childConfig = {
      vulnerabilitySeverity: 'LOW',
    };

    const severity = getHighestVulnerabilitySeverity(parentConfig, childConfig);

    expect(severity).toBe('LOW');
  });

  it('child UNKNOWN vulnerability severity rating is maintained', () => {
    const parentConfig = {
      vulnerabilitySeverity: 'CRITICAL',
    };

    const childConfig = {
      vulnerabilitySeverity: 'UNKNOWN',
    };

    const severity = getHighestVulnerabilitySeverity(parentConfig, childConfig);

    expect(severity).toBe('UNKNOWN');
  });

  it('handled undefined parent and child vulnerability severity', () => {
    const parentConfig = {
      vulnerabilitySeverity: undefined,
    };

    const childConfig = {
      vulnerabilitySeverity: undefined,
    };

    const severity = getHighestVulnerabilitySeverity(parentConfig, childConfig);

    expect(severity).toBeUndefined();
  });
});
