# Help Us Help You

This repository gets a lot of requests from the community every day, and we do our best to answer all of them.
Please follow these points whenever interacting in this repo.

## Be positive and polite

This project is open source, and has the work of a lot of contributors who are proud of it.
Please avoid unnecessary criticism, especially if you are new to the project or have not contributed anything.
You are welcome to make it better, and do not need to criticize the works of others first.

## Be considerate of the time of people helping you

We ask that you respect the time of the contributors and maintainers who are helping you.
This means accepting that sometimes a question might sit around for a bit before getting answered.
This also means that features or bug fixes that you really want can take a long time to appear.

## Be respectful to competitors

Even if you're intending to express a compliment to Renovate from a good heart, try not to phrase it in a way which would be insulting to the developers of alternative tools like Dependabot.
There are a lot of good bots out there, and while we're happy if you like Renovate, we are friends with the creators and developers of other bots and want to keep things friendly.

Objective, respectful comparisons or questions are always welcome too - including if you find Renovate missing something you'd like to see.

## Provide adequate descriptions

Renovate maintainers and contributors spend many hours helping users, most of the time with problems which are the user's own misconfiguration or misunderstanding.
When you ask for help or are receiving it, please put effort into adequately describing your problem, what you've tried, and what you're trying to do.

If you describe a problem with too few details, and we ask you follow-up questions, and you continue to give short and incomplete descriptions, you're likely to not get any further questions or help.
You may get referred to this document though, to explain why!

In other words, if someone's taking the time to help you, "don't be lazy".

## Avoid complaining about docs after getting help

If someone's helped you get some functionality working, or successfully troubleshoot a problem, please try to do this:

- Let us know which advice fixed your problem, if it's unclear
- If you're feeling polite, thank the person who helped you
- If you're feeling helpful, submit a Pull Request to improve the relevant documentation

Please don't ruin a successful result with a criticism or complaint about the quality of the documentation.
If you feel frustrated because better documentation would have prevented you from making the mistake in the first place then improve it with a PR for those who come after you!

## Avoid spamming issues

Sometimes people appear to feel frustrated that their issue or discussion has not got enough attention, and they start commenting on other issues with text such as "I'm also having problems with Gradle! See issue #xyz".
Such comments appear intended to "pressure" Renovate maintainers into taking notice, and rarely do they help the people subscribed to the other, mostly-unrelated issues.
Please do not do it.
Instead, use the "Subscribe" button to follow issues.

## Reproduce repositories on github.com

If you've been asked to provide a reproduction repository, please create it on github.com unless the reproduction itself is specific to another platform like GitLab.

The Renovate maintainers can test and debug the quickest when using GitHub, and we also have a dedicated organization called [renovate-reproductions](https://github.com/renovate-reproductions/) where we fork reproductions into so that we have a copy in case the original creator removes theirs.

## Create reproductions with minimal config and dependencies

We have documented what a "minimal" reproduction repository means, and request that you stick to it.
The more config and the more dependencies in a reproduction, the slower it is to debug and solve the problem.

Unless you're planning to work on the feature or fix yourself, please be respectful of the person's time who would need to do the work instead.

## Filter logs before sharing them

If you've been asked to give us the logs in an issue or discussion, please don't copy/paste the entire output and expect someone else to sort through thousands of lines to help you.
A full log dump takes a lot of time to scroll through, and it is next to impossible to do so from mobile.

Instead, please select the logs relevant to your problem and paste only the relevant logs.
If it turns out there's a need for the full dump, someone can ask you for it later.

## Avoid unjustified bug reports

Don't raise a bug report unless it's definitely a bug.
"I don't like this" or "I didn't expect this to happen" is not the same thing as a bug.

Many unjustified bug reports are filed because people they think it will get them more attention.
Instead, you may be wasting maintainer time because we have to reclassify your invalid bug report or convert it to a discussion, and you are much less likely to get the attention you're hoping for.
If in doubt, start a discussion instead.
