# About us

Renovate was created by [Mend](https://www.mend.io/) staff and they continue to work on Renovate.

More than 1000 outside contributors helped improve Renovate.

## Special thanks

We want to highlight the work of these awesome people.
Thank you for your time and effort!

### Maintainers

Renovate is maintained by:

- [@rarkins](https://github.com/rarkins)
- [@viceice](https://github.com/viceice)
- [@JamieMagee](https://github.com/JamieMagee)
- [@secustor](https://github.com/secustor)

### Maintainers for features

Next up, we have these people who help maintain parts of Renovate:

- [@zharinov](https://github.com/zharinov) focused on parsing, Gradle and Maven
- [@secustor](https://github.com/secustor) worked on Terraform and Helm
- [@fgreinacher](https://github.com/fgreinacher) worked on NuGet
- [@Turbo87](https://github.com/Turbo87) has helped in multiple areas, especially Cargo
- [@Churro](https://github.com/Churro) worked on the `gradle` manager and added support for OSV vulnerabilities

### Valuable contributions

We want to highlight these valuable contributions, even if they are one-offs.
Some features made a lot of people happy, and efficient!

- [@HonkingGoose](https://github.com/HonkingGoose) worked on the documentation and helped manage the community
- [@ikesyo](https://github.com/ikesyo) regularly helpful
- [@astellingwerf](https://github.com/astellingwerf) reviews PRs
- [@danports](https://github.com/danports) worked on the Flux manager, and other managers. Feel free to ping `@danports` for any Flux-related issue or PR
- [@shegox](https://github.com/shegox) worked on the Go manager, and improved our docs
- [@setchy](https://github.com/setchy) focused on Bitbucket Cloud and replacement features
- [@cgrindel](https://github.com/cgrindel) created the `bazel-module` manager
- [@RahulGautamSingh](https://github.com/RahulGautamSingh) refactored a lot of code and worked on performance improvements like reduced cloning during updates and onboarding
- [@Gabriel-Ladzaretti](https://github.com/Gabriel-Ladzaretti) S3 repo cache, child process refactoring, others
- [@not7cd](https://github.com/not7cd) improved the `pip-compile` manager
- [@squidfunk](https://github.com/squidfunk) for creating and maintaining the [Material for MkDocs](https://squidfunk.github.io/mkdocs-material/) framework, that we use to build our docs, and for helping us with problems with the framework, or our docs
- [The MkDocs project](https://www.mkdocs.org/) for making the static site generator, that we use to build our docs

## Renovate development

The source code for Renovate is available on [GitHub at `renovatebot/renovate`](https://github.com/renovatebot/renovate).
This is where we do most of the development.

### Getting more paid help

If you need more assistance than what this project offers, you have two options:

1. Become a Mend.io customer, such as by buying Renovate Enterprise, or
1. Hire an experienced Renovate contributor privately for consulting. Mend.io staff do _not_ offer this service, but one of our volunteer maintainers, [`@secustor`](https://github.com/secustor), does

## About these docs

The Renovate docs are built from Markdown files in our [`renovatebot/renovate` repository](https://github.com/renovatebot/renovate).
Most of the source files can be found in the [`docs/usage/` directory](https://github.com/renovatebot/renovate/tree/main/docs/usage).

We use [MkDocs](https://www.mkdocs.org/) and [Material for MkDocs](https://squidfunk.github.io/mkdocs-material/) to build our docs.
