This manager parses [Flux](https://fluxcd.io/) YAML manifests and supports:

1. [`HelmRelease`](https://fluxcd.io/docs/components/helm/helmreleases/) resources
1. [`GitRepository`](https://fluxcd.io/flux/components/source/gitrepositories/) resources
1. [`OCIRepository`](https://fluxcd.io/flux/components/source/ocirepositories/) resources
1. Flux [system](https://fluxcd.io/docs/installation) manifests

### HelmRelease support

Extracts `helm` dependencies from `HelmRelease` resources.

The `flux` manager extracts `helm` dependencies for `HelmRelease` resources linked to `HelmRepository` or `GitRepository` sources.
`HelmRepository` resources can be referenced via `spec.chart` or indirectly via a `HelmChart` when
using [`spec.chartRef`](https://fluxcd.io/flux/components/helm/helmreleases/#chart-reference).
Renovate supports OCI `HelmRepository` sources, those with `type: oci`.
Renovate will then extract the `docker` dependencies for the referenced `HelmRelease` resources.

In addition, for the `flux` manager to properly link `HelmRelease` and `HelmRepository` resources, _both_ of the following conditions must be met:

1. The `HelmRelease` resource must either have its `metadata.namespace` property set or its `spec.chart.spec.sourceRef.namespace` property (when not using `chartRef`) set
2. The referenced `HelmRepository` and `HelmChart` (when using `chartRef`) resources must have their `metadata.namespace` property set

Namespaces will not be inferred from the context (e.g. from the parent `Kustomization`).

Renovate updates `HelmRelease` resources coming from `GitRepository` by updating the `GitRepository` resource.

Renovate updates Docker dependencies inside `HelmRelease` `values` like the [`helm-values`](../helm-values/index.md) manager.

### GitRepository support

Renovate can update `git` references from `GitRepository` resources.

The `flux` manager only updates `GitRepository` fields that have a `tag` or `commit` key.

### Kustomization support

Renovate can update `image`[^1] references from `Kustomization` resources.

### OCIRepository support

Renovate can update `oci` references from `OCIRepository` resources.

The `flux` manager only updates `OCIRepository` fields that have a `digest` or `tag` key.
If `tag` _and_ `digest` exist then `digest` takes precedence.

### Flux system manifests support

Renovate supports updating Flux system manifests generated during [Flux installation](https://fluxcd.io/docs/installation/#customize-flux-manifests).
System manifests are identified via being named `gotk-components.y(a)ml` and containing comment headers as generated by `flux bootstrap`.

<!-- prettier-ignore -->
!!! warning
    Renovate cannot identify the use of custom bootstrap flags, such as `--cluster-domain`.
    In such a scenario Renovate's PR will overwrite these values with the Flux defaults.
    See [issue #13952 on GitHub](https://github.com/renovatebot/renovate/issues/13952) for more information.

Updating system manifests requires that either:

1. The `flux` tool is pre-installed, or
1. You run a Docker image based on [containerbase](https://github.com/containerbase), such as the official Renovate images, and have `binarySource=install` configured

### Default managerFilePatterns

By default, the `flux` manager only matches `**/gotk-components.y(a)ml`.
So it only checks system manifest files generated by the `flux bootstrap` command.

This is because there is no commonly accepted file/directory naming convention for Flux manifests and we don't want to check every single `*.yaml` file in repositories just in case some of them have Flux definitions.

If most `.yaml` files in your repository are Flux manifests, then you could add this to your config:

```json
{
  "flux": {
    "managerFilePatterns": ["/\\.yaml$/"]
  }
}
```

If instead you have all your Flux manifests inside a `flux/` directory, you would add this:

```json
{
  "flux": {
    "managerFilePatterns": ["/flux/.+\\.yaml$/"]
  }
}
```

### Versioning

If you need to change the versioning format, read the [versioning](../../versioning/index.md) documentation to learn more.

[^1]: <https://fluxcd.io/flux/components/kustomize/kustomizations/#images>
