The following `depTypes` are currently supported by the npm manager :

- `dependencies`
- `devDependencies`
- `optionalDependencies`
- `peerDependencies`
- `engines` : Renovate will update any `node`, `npm` and `yarn` version specified under `engines`.
- `volta` : Renovate will update any `node`, `npm`, `pnpm` and `yarn` version specified under `volta`.
- `packageManager`
- `overrides`
- `resolutions`
- `pnpm.overrides`
- `pnpm.catalog.<name>`, such as `pnpm.catalog.default` and `pnpm.catalog.myCatalog`. [Matches any default and named pnpm catalogs](https://pnpm.io/catalogs#defining-catalogs).

### npm problems and workarounds

#### Invalid lock file (npm ci fails)

Unfortunately, `npm` itself sometimes generates invalid lock files which fail `npm ci`.
Try adding `"postUpdateOptions": ["npmInstallTwice"]` to tell Renovate run any `npm install` command (which is used to update lock files) twice.
This is less efficient than running npm once, but has been known to fix most problems of this type.

If this npm bug remains unfixed, and it becomes too frequent for Renovate users, then we may need to modify Renovate to do this by default.
Please post feedback to the Renovate repository "Discussions" if you're needing to use this feature frequently or widely.

### Yarn

#### Version Selection / Installation

If Renovate detects a `packageManager` setting for Yarn in `package.json` then it will use Corepack to install Yarn.

#### HTTP Proxy Support

Yarn itself does not natively recognize/support the `HTTP_PROXY` and `HTTPS_PROXY` environment variables.

You can configure `RENOVATE_X_YARN_PROXY=true` as an environment variable to enable configuring of Yarn proxy (e.g. if you cannot configure these proxy settings yourself in `~/.yarnrc.yml`).

If set, and Renovate detects Yarn 2+, and one or both of those variables are present, then Renovate will run commands like `yarn config set --home httpProxy http://proxy` prior to executing `yarn install`.
This will result in the `~/.yarnrc.yml` file being created or modified with these settings, and the settings are not removed afterwards.

Configuration/conversion of `NO_PROXY` to Yarn config is not supported.
