# Contributing to Renovate

Thank you for thinking of contributing to Renovate!
The [`docs/development/` directory of the `renovatebot/renovate` repository](https://github.com/renovatebot/renovate/tree/main/docs/development) has all the developer-facing documentation.

## I want to write code

### Read this first

1. [Contributing guide](https://github.com/renovatebot/renovate/blob/main/.github/contributing.md)
1. [Best practices](https://github.com/renovatebot/renovate/blob/main/docs/development/best-practices.md)
1. [Local Development](https://github.com/renovatebot/renovate/blob/main/docs/development/local-development.md) or [Remote Development](https://github.com/renovatebot/renovate/blob/main/docs/development/remote-development.md)

### Creating/editing Renovate preset

1. [Creating/editing Renovate presets](https://github.com/renovatebot/renovate/blob/main/docs/development/creating-editing-renovate-presets.md)

### Adding a new package manager

1. [Adding a Package Manager](https://github.com/renovatebot/renovate/blob/main/docs/development/adding-a-package-manager.md)

### Background information

1. [Design Decisions](https://github.com/renovatebot/renovate/blob/main/docs/development/design-decisions.md)
1. [Zod schema guideline](https://github.com/renovatebot/renovate/blob/main/docs/development/zod.md)
1. [Branches and commits behavior](https://github.com/renovatebot/renovate/blob/main/docs/development/branches-commits.md)
1. [Configuration](https://github.com/renovatebot/renovate/blob/main/docs/development/configuration.md)
1. [Static Data](https://github.com/renovatebot/renovate/blob/main/docs/development/static-data.md)
1. [How to bump Renovate to next NodeJS LTS release](https://github.com/renovatebot/renovate/blob/main/docs/development/bump-node-major.md)

## I want to write documentation

Read the [Contributing guide](https://github.com/renovatebot/renovate/blob/main/.github/contributing.md), and the [Renovate style guide](https://github.com/renovatebot/renovate/blob/main/docs/development/style-guide.md).

## I want to triage incoming discussions

Start by reading:

1. [Contributing guide](https://github.com/renovatebot/renovate/blob/main/.github/contributing.md)
1. [Triage guide](https://github.com/renovatebot/renovate/blob/main/docs/development/triage-guide.md)
1. [Issue labeling](https://github.com/renovatebot/renovate/blob/main/docs/development/issue-labeling.md)

You may need to direct a Renovate user to one of these pages:

1. [About minimal reproductions](https://github.com/renovatebot/renovate/blob/main/docs/development/minimal-reproductions.md)
1. [New package manager questionnaire](https://github.com/renovatebot/renovate/blob/main/docs/development/new-package-manager-template.md)
1. [Help Us Help You](https://github.com/renovatebot/renovate/blob/main/docs/development/help-us-help-you.md)
