# Code of Conduct

To help us deliver great features and support the Renovate Open Source project we ask that you:

- are polite
- pay attention to details
- keep in mind that most maintainers are volunteers
- are respectful of the time and effort of the maintainers

## Our priorities

We want to keep this project sustainable.
This means we support our maintainers and contributors, who spend their free time to help others.

Maintainers getting stressed is a big threat to Open Source projects, like ours.
Stressed maintainers quit, or reduce their time spent on the project.
Often a few users behave badly, where most users are nice.

We want to avoid maintainers getting stressed out by bad behavior from contributors.
That's why we have these rules.

## Politeness

Sadly, it's common in Open Source projects for a few users to behave in an aggressive and rude way.
A user might say something like: "You should have fixed this bug already!", or "Why am I still waiting for this feature?".
We do not allow this kind of behavior.

### No mean comments

We expect basic politeness, do not act rude.
For example: it is okay if you ask a question and do not thank us afterwards.
But avoid writing mean comments like:

- "Pity the documentation didn’t say that."
- "Thanks for nothing."

### No thumbs-down emojis (except on polls)

Do not give a thumbs-down emoji to posts.
Even if you are sad, or angry about a response: do not use the thumbs-down emoji.

The only time a thumbs-down is appropriate is when we, or a user, asks for a vote about something.

### Do not start Twitter mobs

Do not (try to) start Twitter mobs against the project or maintainers.
Especially if you got rate-limited from interacting with this project, because you did not follow the rules.

## We are not a village square

This repository is a place where a minority show up to do the work.
The vast majority benefit, for example by getting their support questions answered.

This repository is not a "village square" where all opinions are equal.
Nor is everyone's time equal here.

## Respect the time of those who help you

When you ask for help, please remember that the maintainer's time is the limited resource here.
We get many questions each week and do our best to answer each one.

To get the help you need, please be prepared to give detailed logs or descriptions of your issues.
If you do not want to spend the effort giving us enough information, it's likely you will not get the help you need.

### Why we sometimes give short answers

We have limited time, which means we may:

- only give you a short answer
- forget to soften the blow of a negative answer with "I'm really sorry but.."

We know that getting a short answer feels bad.
Please remember that we are doing the best we can to improve Renovate.
We often respond from mobile devices.

### No "any update on this?" type comments

Do not post comments in Discussions or Issues to demand a response, like: "Any update on this?".
These comments force a maintainer to either repond, or hide your comment.

Our development is mostly done in the open on GitHub.
It's rare that updates are hidden from you.
Please do not comment on GitHub "just in case there are updates".

When you comment on a stalled topic, please add new information, or valuable insight.

Remember, most of the support provided by our team, including the Mend.io staff, is _unpaid_.

## Blocking and unblocking

We quickly deal with rudeness in the community with:

- automated comments
- temporary blocks
- permanent bans

If you keep breaking the rules or challenge our guidelines openly, you will be blocked.
For example: if you keep spamming the maintainers with `@mentions` or challenge our rules openly, you will be blocked.

We generally do not argue about these decisions, but we are willing to reverse a block if you show that you understand and respect the rules, or if there was a misunderstanding.
To reverse a block, or to clear up a misunderstanding, write a _short_ email to Renovate's lead maintainer Rhys Arkins.

Simply put: we block and unblock swiftly, what matters is how you follow the rules going forward.

## How we prioritize work

Renovate's core contributors and maintainers focus on work that:

- Helps a lot of users, or
- Fixes regressions (errors introduced by recent changes), or
- Is required by a customer of Mend.io, or
- Is sponsored by third parties after independent validation, or
- We personally need or want to implement

You may be disappointed when we focus on other work ahead of your feature or bug, but you should understand and accept this.

## Maintaining Issue and Code quality

We use GitHub Discussions to start and sort issues.
Only maintainers are allowed to create new issues.
If we confirm a bug or agree with a feature idea, and if it's well-documented, we will turn it into an official issue.
This way most issues are ready to work on, either by us or the community.

We may reject ideas that are too specialized, or that would make the project too hard to maintain.

### Pull Request reviews

We have strict coding standards and reviews to keep our code in good shape.
A feature or fix must of course work, but it must also be well designed to stay maintainable.
We may ask you to improve your code several times in a row, which can be difficult for you.
We only do this to keep the project sustainable.

## If you have urgent work

People working for big companies might push too hard in Open Source projects.
It’s often hard for them to understand that our maintainers cannot spend much time to solve their issues quickly.
Frequent requests for updates like "@rarkins how can we move this forward?" are _not_ helpful.

Please remember, unless you are a Mend.io customer, this project does not owe you the level of response or support you might expect.
Mend.io customers should use their designated support channels for urgent needs.

## Getting more help

If you need more assistance than what this project offers, you have two options:

1. Become a Mend.io customer, such as by buying Renovate Enterprise, or
1. Hire an experienced Renovate contributor privately for consulting. Mend.io staff do _not_ offer this service, but one of our volunteer maintainers, [`@secustor`](https://github.com/secustor), does

## Feedback

We welcome respectful discussions about these rules and accept suggestions that improve this text.
We avoid debates on social media or going off-topic in GitHub Discussions.

Because we enforce all these rules, we can deliver new features and give excellent support to the community.
