import { codeBlock } from 'common-tags';
import { extractLocks } from './util';

describe('modules/manager/terraform/lockfile/util', () => {
  describe('extractLocks()', () => {
    it('returns null for empty', () => {
      const result = extractLocks('nothing here');
      expect(result).toBeNull();
    });

    it('extracts', () => {
      const res = extractLocks(codeBlock`
        provider "registry.terraform.io/hashicorp/aws" {
          version     = "3.0.0"
          constraints = "3.0.0"
          hashes = [
            "h1:ULKfwySvQ4pDhy027ryRhLxDhg640wsojYc+7NHMFBU=",
            "zh:25294510ae9c250502f2e37ac32b01017439735f098f82a1728772427626a2fd",
            "zh:3b723e7772d47bd8cc11bea6e5d3e0b5e1df8398c0e7aaf510e3a8a54e0f1874",
            "zh:4b7b73b86f4a0705d5d2a7f1d3ad3279706bdb3957a48f4a389c36918fba838e",
            "zh:9e26cdc3be97e3001c253c0ca28c5c8ff2d5476373ca1beb849f3f3957ce7f1a",
            "zh:9e73cf1304bf57968d3048d70c0b766d41497430a2a9a7a718a196f3a385106a",
            "zh:a30b5b66facfbb2b02814e4cd33ca9899f9ade5bbf478f78c41d2fe789f0582a",
            "zh:b06fb5da094db41cb5e430c95c988b73f32695e9f90f25499e926842dbd21b21",
            "zh:c5a4ff607e9e9edee3fcd6d6666241fb532adf88ea1fe24f2aa1eb36845b3ca3",
            "zh:df568a69087831c1780fac4395630a2cfb3cdf67b7dffbfe16bd78c64770bb75",
            "zh:fce1b69dd673aace19508640b0b9b7eb1ef7e746d76cb846b49e7d52e0f5fb7e",
          ]
        }

        provider "registry.terraform.io/hashicorp/azurerm" {
          version     = "2.50.0"
          constraints = "~> 2.50"
          hashes = [
            "h1:Vr6WUm88s9hXGkyVjHtHsP2Jmc2ypQXn6ww7dXtvk1M=",
            "zh:0c0688d5a743248f8646d39eb3645a4ac19fd7523ba1b47072fa3fb03b92b1b0",
            "zh:2beb3a55ee970f87a9292ae96d57134be8a03d0566117e7be0fe0d9c1267e4ea",
            "zh:38091b463fbafe5756420ce34c87845c2a391fec0cded27bdcbbca28febad382",
            "zh:4ba455da3b37ba8f8b03ff2781121d9c54d0bd8afd76dfe67593011c475dd73f",
            "zh:5d32b9ed871b3c3b774dc69f1fe14cdf7c1fd63d12bb5f21aad4bfbf75e5ee3d",
            "zh:6c80cf90a3fc1e17d9caf67cc558c2ff91f8b25e29fdf00942f67711895be5c0",
            "zh:c0a53e3165407999d10de7aaa983485d42797433c60b5775791ae299121279ed",
            "zh:dab51d6d76041505aeebf20111febe8616ec465ca31dfb7901f5f5c23a5af095",
            "zh:e1ad6399f6a6d799002206ee4cb7b794dbb2533b8c3c14502a4419955ec96bff",
            "zh:e98f1d178d1e111b3f3449e27d305ce263071226fad3d86272e1bd161c26fd43",
            "zh:eb76ec000c9c49a0bf730370c8880f671597bc01f7b7401ab301df7124c049ec",
          ]
        }

        provider "registry.terraform.io/hashicorp/random" {
          version     = "2.2.1"
          constraints = "~> 2.2"
          hashes = [
            "h1:Zg1Bpi6vr7b0H6no8kVDfEucn5pvNALivdrVKVHarGs=",
            "zh:072ce92b0138ee65df2e4e2e6e5f6632fa12a7e6453b91399bad89291855d426",
            "zh:5731987fe61051515f449033e456ee55207caf17ef41096eb82247810585f53b",
            "zh:6f18b10175708bb5839e1f2082dcc02651b876786cd54ec415a091f3821807c3",
            "zh:7fa7737661380d18cba3cdc71c4ec6f2fd281b9d61112f6b48d06ca8bbf97771",
            "zh:8466cb8fbb4de887b23039082a6e3dc85aeabce86dd808e2a7a65e4e1c51dbae",
            "zh:888c63417701c13bbe785ab11dc690d4803e6a2156318cf188970b7b6400b99e",
            "zh:a231df55d36fbad1a6705f5d3be4f7459a73ec76117d13f22aa83c10fc610278",
            "zh:b62d9a4cd64a2d229070260f4abfef476ebbd7c5511b43e9cdccf23ce938f630",
            "zh:b6bd1a325f909bb93f7c9bef00eb306bef1e406cbdf557901d755a3e7a4a5448",
            "zh:b9f59afc23cc5567075f76313214baa1e5ce909325229e23c9a4666f7b26e7f7",
            "zh:d040220c09b8d9d6bd937572bd5b14bc069af2b883185a873460530d8a1de6e6",
            "zh:f254c1f943eb016ae07ebe91b23f813dc79f2064616c65f98c8f64ce23be90c4",
          ]
        }
      `);
      expect(res).toMatchObject([
        {
          constraints: '3.0.0',
          hashes: [
            'h1:ULKfwySvQ4pDhy027ryRhLxDhg640wsojYc+7NHMFBU=',
            'zh:25294510ae9c250502f2e37ac32b01017439735f098f82a1728772427626a2fd',
            'zh:3b723e7772d47bd8cc11bea6e5d3e0b5e1df8398c0e7aaf510e3a8a54e0f1874',
            'zh:4b7b73b86f4a0705d5d2a7f1d3ad3279706bdb3957a48f4a389c36918fba838e',
            'zh:9e26cdc3be97e3001c253c0ca28c5c8ff2d5476373ca1beb849f3f3957ce7f1a',
            'zh:9e73cf1304bf57968d3048d70c0b766d41497430a2a9a7a718a196f3a385106a',
            'zh:a30b5b66facfbb2b02814e4cd33ca9899f9ade5bbf478f78c41d2fe789f0582a',
            'zh:b06fb5da094db41cb5e430c95c988b73f32695e9f90f25499e926842dbd21b21',
            'zh:c5a4ff607e9e9edee3fcd6d6666241fb532adf88ea1fe24f2aa1eb36845b3ca3',
            'zh:df568a69087831c1780fac4395630a2cfb3cdf67b7dffbfe16bd78c64770bb75',
            'zh:fce1b69dd673aace19508640b0b9b7eb1ef7e746d76cb846b49e7d52e0f5fb7e',
          ],
          packageName: 'hashicorp/aws',
          registryUrl: 'https://registry.terraform.io',
          version: '3.0.0',
        },
        {
          constraints: '~> 2.50',
          hashes: [
            'h1:Vr6WUm88s9hXGkyVjHtHsP2Jmc2ypQXn6ww7dXtvk1M=',
            'zh:0c0688d5a743248f8646d39eb3645a4ac19fd7523ba1b47072fa3fb03b92b1b0',
            'zh:2beb3a55ee970f87a9292ae96d57134be8a03d0566117e7be0fe0d9c1267e4ea',
            'zh:38091b463fbafe5756420ce34c87845c2a391fec0cded27bdcbbca28febad382',
            'zh:4ba455da3b37ba8f8b03ff2781121d9c54d0bd8afd76dfe67593011c475dd73f',
            'zh:5d32b9ed871b3c3b774dc69f1fe14cdf7c1fd63d12bb5f21aad4bfbf75e5ee3d',
            'zh:6c80cf90a3fc1e17d9caf67cc558c2ff91f8b25e29fdf00942f67711895be5c0',
            'zh:c0a53e3165407999d10de7aaa983485d42797433c60b5775791ae299121279ed',
            'zh:dab51d6d76041505aeebf20111febe8616ec465ca31dfb7901f5f5c23a5af095',
            'zh:e1ad6399f6a6d799002206ee4cb7b794dbb2533b8c3c14502a4419955ec96bff',
            'zh:e98f1d178d1e111b3f3449e27d305ce263071226fad3d86272e1bd161c26fd43',
            'zh:eb76ec000c9c49a0bf730370c8880f671597bc01f7b7401ab301df7124c049ec',
          ],
          packageName: 'hashicorp/azurerm',
          registryUrl: 'https://registry.terraform.io',
          version: '2.50.0',
        },
        {
          constraints: '~> 2.2',
          hashes: [
            'h1:Zg1Bpi6vr7b0H6no8kVDfEucn5pvNALivdrVKVHarGs=',
            'zh:072ce92b0138ee65df2e4e2e6e5f6632fa12a7e6453b91399bad89291855d426',
            'zh:5731987fe61051515f449033e456ee55207caf17ef41096eb82247810585f53b',
            'zh:6f18b10175708bb5839e1f2082dcc02651b876786cd54ec415a091f3821807c3',
            'zh:7fa7737661380d18cba3cdc71c4ec6f2fd281b9d61112f6b48d06ca8bbf97771',
            'zh:8466cb8fbb4de887b23039082a6e3dc85aeabce86dd808e2a7a65e4e1c51dbae',
            'zh:888c63417701c13bbe785ab11dc690d4803e6a2156318cf188970b7b6400b99e',
            'zh:a231df55d36fbad1a6705f5d3be4f7459a73ec76117d13f22aa83c10fc610278',
            'zh:b62d9a4cd64a2d229070260f4abfef476ebbd7c5511b43e9cdccf23ce938f630',
            'zh:b6bd1a325f909bb93f7c9bef00eb306bef1e406cbdf557901d755a3e7a4a5448',
            'zh:b9f59afc23cc5567075f76313214baa1e5ce909325229e23c9a4666f7b26e7f7',
            'zh:d040220c09b8d9d6bd937572bd5b14bc069af2b883185a873460530d8a1de6e6',
            'zh:f254c1f943eb016ae07ebe91b23f813dc79f2064616c65f98c8f64ce23be90c4',
          ],
          packageName: 'hashicorp/random',
          registryUrl: 'https://registry.terraform.io',
          version: '2.2.1',
        },
      ]);
    });
  });
});
