const severityOrder: Record<string, number> = {
  LOW: 1,
  MEDIUM: 2,
  MODERATE: 2,
  HIGH: 3,
  CRITICAL: 4,
  UNKNOWN: 5,
};

export function getHighestVulnerabilitySeverity<
  T extends Record<string, any>,
  TChild extends Record<string, any> | undefined,
>(parent: T, child: TChild): string {
  const parentVulSeverity = parent.vulnerabilitySeverity?.toUpperCase();
  const childVulSeverity = child?.vulnerabilitySeverity?.toUpperCase();

  if (childVulSeverity === undefined) {
    return parentVulSeverity;
  }

  if (parentVulSeverity === undefined) {
    return childVulSeverity;
  }

  return severityOrder[parentVulSeverity] >= severityOrder[childVulSeverity]
    ? parentVulSeverity
    : childVulSeverity;
}
