# Kontena

> The developer friendly container and micro services platform. Works on any cloud, easy to setup, simple to use. http://www.kontena.io

[![Build Status](https://travis-ci.org/kontena/kontena.svg?branch=master)](https://travis-ci.org/kontena/kontena)
[![Join the chat at https://slack.kontena.io](https://slack.kontena.io/badge.svg)](https://slack.kontena.io)
[![Join the chat at https://gitter.im/kontena/kontena](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/kontena/kontena?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)

[Kontena](https://www.kontena.io) is a new developer friendly, open source platform for orchestrating applications that are run on Docker containers. It simplifies deploying and running containerized applications on any infrastructure. By leveraging technologies such as [Docker](https://www.docker.com/), [CoreOS](https://coreos.com/) and [Weave](https://www.weave.works/), it provides complete solution for organizations of any size.

Kontena is built to maximize developer happiness; it is designed for application developers and therefore does not require ops teams to setup or maintain. Therefore, it is an ideal choice for organizations without aspiration to configure and maintain scalable Docker container infrastructure.

[![Kontena Introduction](https://asciinema.org/a/25815.png)](https://asciinema.org/a/25815)

To accelerate and break barriers for containerized application development, Kontena features some of the most essential technologies built-in such as:

* Multi-host, multi AZ container orchestration
* Overlay network technology by Weaveworks
* Zero-downtime dynamic load balancing
* Abstraction to describe services running in containers
* Private Docker image repository
* Kontena Vault - a secure storage for managing secrets
* VPN access to backend containers
* Heroku-like application deployment workflow

Kontena supports any application that can run in a Docker container, and can run on any machine that supports CoreOS. You can run Kontena on the cloud provider of your choice or on your own servers. We hope you enjoy!

**Learn more about Kontena:**
- [Kontena Website](https://www.kontena.io)
- [Kontena Blog](http://blog.kontena.io)
- [Documentation](https://www.kontena.io/docs)

## Getting Started

Please see our [Quick Start](http://www.kontena.io/docs/getting-started/quick-start) guide.

## Contact Us

Found a bug? Suggest a feature? Have a question? Please [submit an issue](https://github.com/kontena/kontena/issues) or email us at <a href="mailto:info@kontena.io">info@kontena.io</a>.

Follow us on Twitter: [@KontenaInc](https://twitter.com/KontenaInc).

Slack: [Join the Kontena Community Slack channel](https://slack.kontena.io/).

## License

Kontena software is open source, and you can use it for any purpose, personal or commercial. Kontena is licensed under the Apache License, Version 2.0. See [LICENSE](LICENSE) for full license text.
