---
title: Grids
---

# Grids

The [Grid](../core-concepts/architecture.md#the-grid) is a top-level object in Kontena that describes a single cluster of Kontena Nodes.

* [Manage](grids.md#manage-grids)
* [Logs](grids.md#grid-logs)
* [Users](grids.md#grid-users)
* [Trusted Subnets](grids.md#grid-trusted-subnets)

## Grid Options

There are a number of per-grid options. Some of these can be changed using `kontena grid update`, but others must be determined ahead of time when using `kontena grid create`, and cannot be changed later.

### Create options
These options can only be set when using `kontena grid create`, and cannot be changed later.

#### Initial Size

The `kontena grid create --initial-size=SIZE` option determines the minimum number of nodes in the grid.
For an `--initial-size=3` grid, the first three nodes that join the Grid will become initial nodes.

See the [Initial Nodes](#initial-nodes) section for further details.

#### Grid Token

The `kontena grid create --token=SECRET` is typically generated by the Kontena Server.
The grid token is used when provisioning nodes using the Kontena plugins or `kontena grid env` / `kontena grid cloud-config` methods.

The grid token is used to both grant access to the Kontena master, as well as the shared secret used for the overlay networking encryption.

## Update options
These options can be set using `kontena grid update` while the grid is running.

### Default Affinity

The `kontena grid create --default-affinity=AFFINITY-FILTER` option acts as if each Kontena service were configured with the given service affinity by default.
This can be used to avoid deploying services to specific grid nodes by default, using a per-service affinity to only deploy specific services to those grid nodes.

See the [Deployment Strategies](deploy.md#affinity) documentation for the affinity filter syntax.

This option can be changed using `kontena grid update --default-affinity ...`.
This will re-schedule the grid services, and may cause service instances to be moved to different nodes.

### `statsd` Server

The `kontena grid update --statsd-server HOST:PORT` option configures each host node to send stats metrics for each host node and service container to a remote statsd receiver using the UDP StatsD protocol.

See the [Statistics](stats.md#exporting-stats) documentation for further details.

## Initial Nodes

Each grid is created with an initial size, where the first `initial_size` nodes to join the grid will become ***initial*** nodes.
These initial nodes will act as `etcd` servers, and form an `etcd` cluster that provides the grid's `etcd` infrastructure service.
The remaining nodes in the grid will act as `etcd` proxy nodes to provide access to the `etcd` infrastructure service, but they do not form a part of the `etcd` cluster.

The Grid's `etcd` infrastructure service requires a majority of these initial nodes to be online and healthy.
A well designed production grid will be created with an odd `--initial-size` of either 3, 5 or 7, with initial nodes spread across different availability zones.
Refer to the [`etcd` admin guide](https://coreos.com/etcd/docs/latest/v2/admin_guide.html#optimal-cluster-size) for further details on the optimal grid `--initial-size`.

### Impact of initial node failures

If half or more of the initial nodes are offline or unhealthy, the grid's `etcd` service will stop working.
For an `--initial-size=3` grid, losing a single initial node will not affect the operation of the grid, but it should be repaired or replaced ASAP, as losing a second initial node will affect the operation of the grid.
An `--initial-size=5` grid may lose two initial nodes without affecting the operation of the grid.

An unhealthy `etcd` cluster will affect the operation of the Kontena grid in the following ways:

* New service containers cannot be deployed

  Deploying service containers requires allocating dynamic Grid subnet addresses from the Kontena IPAM, which uses `etcd`.

* Service container backends cannot be updated to the Kontena Load Balancers

  The Kontena Load Balancer reads the service backends from `etcd`, but the Kontena agent will be unable to update `etcd` as these service containers are started or stopped.

### Monitoring initial node health

The `kontena node list` command will show the number of initial nodes and their status.
This will show the grid's initial node configuration, as well as a health indicator for each grid node.

The `kontena grid health` command can be used to validate that the Grid's initial nodes are configured and online.
This will report an error if the grid does not have enough initial nodes provisioned, or they have failed.

The `kontena etcd health` command can be used to verify that the grid `etcd` infrastructure service is operating correctly on each node.
This will report an error for each grid node that does not have a working `etcd` service, which can be caused by overlay networking issues, or multiple initial node failures.

### Initial node replacement

In the case of initial node failure or replacement, Kontena can automatically provision a new initial node as part of the grid etcd cluster, as long as there has NOT been a majority loss.
This initial node replacement happens when an offline initial node is removed using `kontena node remove`.
The next new node to join the grid will be provisioned as a replacement initial node.
Kontena will not promote an existing non-initial node as a replacement initial node.

In practice this means that you can replace the grid's initial nodes by removing them one at a time (keeping the majority), and replacing them with new nodes.

## Manage Grids

Use the `kontena grid ...` commands to manage the grids.

#### Create a New Grid


Create a new Grid named `mygrid` with a initial size of three Nodes:

```
$ kontena grid create --initial-size=3 mygrid
```

See the [Grid Options](#grid-options) section for an explanation of the different `kontena grid create` options:

```
Usage:
    kontena grid create [OPTIONS] NAME

Parameters:
    NAME                          Grid name

Options:
    --initial-size INITIAL_SIZE   Initial grid size (number of nodes) (default: 1)
    --silent                      Reduce output verbosity
    --token [TOKEN]               Set grid token
    --default-affinity [AFFINITY] Default affinity rule for the grid
    -h, --help                    print help
```

#### List Grids

```
$ kontena grid list
```

#### Switch to Grid

```
$ kontena grid use another_grid
```

Switches cli scope to a Grid named `another_grid`.


#### Reconfigure a grid

```
$ kontena grid update --statsd-server influx.example.com:8125 mygrid
```

See the [Grid Options](#grid-options) section for an explanation of the different `kontena grid create` options:

```
Usage:
    kontena grid update [OPTIONS] NAME

Parameters:
    NAME                          Grid name

Options:
    --statsd-server STATSD_SERVER Statsd server address (host:port)
    --default-affinity [AFFINITY] Default affinity rule for the grid
    -h, --help                    print help
```

#### Remove a Grid

```
$ kontena grid remove mygrid

```

Removes a Grid named `mygrid`.

#### Show Current Grid

```
$ kontena grid current
```

Shows currently used Grid details.

### Grid Logs

#### Show Current Grid Logs

```
$ kontena grid logs
```

#### Show Current Grid Audit Log

```
$ kontena grid audit-log
```

### Show Current Grid Environment Details

```
$ kontena grid env
```

### Show Current Grid Cloud-Config

```
$ kontena grid cloud-config
```

### Grid Users

#### List Current Grid Users

```
$ kontena grid user list
```

#### Add User to the Current Grid

```
$ kontena grid user add not@val.id
```

Adds user with email `not@val.id` to the current Grid. Note: user has to be invited to Kontena Master first.

#### Remove a User from the Current Grid

```
$ kontena grid user remove not@val.id
```

Removes a user with an email `not@val.id` from the current grid.

### Grid Trusted Subnets

If some of the Grid nodes are colocated in a trusted network (for example, within the boundary of your own datacenter) you can add subnets to a Grid's trusted subnet list. This disables data plane encryption within a trusted subnet and switches overlay to faster (near-native) mode as an optimization.

#### List Trusted Subnets

```
$ kontena grid trusted-subnet ls
```

#### Add Trusted Subnet

```
$ kontena grid trusted-subnet add <grid> <subnet>
```

#### Remove Trusted Subnet

```
$ kontena grid trusted-subnet remove <grid> <subnet>
```
