# Rust API for petstore_api

This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\

## Overview
This client/server was generated by the [swagger-codegen]
(https://github.com/swagger-api/swagger-codegen) project.
By using the [OpenAPI-Spec](https://github.com/OAI/OpenAPI-Specification) from a remote server, you can easily generate a server stub.
-

To see how to make this your own, look here:

[README](https://github.com/swagger-api/swagger-codegen/blob/master/README.md)

- API version: 1.0.0
- Build date: 2018-10-22T18:41:22.807-05:00

This autogenerated project defines an API crate `petstore_api` which contains:
* An `Api` trait defining the API in Rust.
* Data types representing the underlying data model.
* A `Client` type which implements `Api` and issues HTTP requests for each operation.
* A router which accepts HTTP requests and invokes the appropriate `Api` method for each operation.

It also contains an example server and client which make use of `petstore_api`:
* The example server starts up a web server using the `petstore_api` router,
  and supplies a trivial implementation of `Api` which returns failure for every operation.
* The example client provides a CLI which lets you invoke any single operation on the
  `petstore_api` client by passing appropriate arguments on the command line.

You can use the example server and client as a basis for your own code.
See below for [more detail on implementing a server](#writing-a-server).


## Examples

Run examples with:

```
cargo run --example <example-name>
```

To pass in arguments to the examples, put them after `--`, for example:

```
cargo run --example client -- --help
```

### Running the server
To run the server, follow these simple steps:

```
cargo run --example server
```

### Running a client
To run a client, follow one of the following simple steps:

```
cargo run --example client TestSpecialTags
cargo run --example client FakeOuterBooleanSerialize
cargo run --example client FakeOuterCompositeSerialize
cargo run --example client FakeOuterNumberSerialize
cargo run --example client FakeOuterStringSerialize
cargo run --example client TestBodyWithQueryParams
cargo run --example client TestClientModel
cargo run --example client TestEndpointParameters
cargo run --example client TestEnumParameters
cargo run --example client TestInlineAdditionalProperties
cargo run --example client TestJsonFormData
cargo run --example client TestClassname
cargo run --example client AddPet
cargo run --example client DeletePet
cargo run --example client FindPetsByStatus
cargo run --example client FindPetsByTags
cargo run --example client GetPetById
cargo run --example client UpdatePet
cargo run --example client UpdatePetWithForm
cargo run --example client UploadFile
cargo run --example client DeleteOrder
cargo run --example client GetInventory
cargo run --example client GetOrderById
cargo run --example client PlaceOrder
cargo run --example client CreateUser
cargo run --example client CreateUsersWithArrayInput
cargo run --example client CreateUsersWithListInput
cargo run --example client DeleteUser
cargo run --example client GetUserByName
cargo run --example client LoginUser
cargo run --example client LogoutUser
cargo run --example client UpdateUser
```

### HTTPS
The examples can be run in HTTPS mode by passing in the flag `--https`, for example:

```
cargo run --example server -- --https
```

This will use the keys/certificates from the examples directory. Note that the server chain is signed with
`CN=localhost`.


## Writing a server

The server example is designed to form the basis for implementing your own server. Simply follow these steps.

* Set up a new Rust project, e.g., with `cargo init --bin`.
* Insert `petstore_api` into the `members` array under [workspace] in the root `Cargo.toml`, e.g., `members = [ "petstore_api" ]`.
* Add `petstore_api = {version = "1.0.0", path = "petstore_api"}` under `[dependencies]` in the root `Cargo.toml`.
* Copy the `[dependencies]` and `[dev-dependencies]` from `petstore_api/Cargo.toml` into the root `Cargo.toml`'s `[dependencies]` section.
  * Copy all of the `[dev-dependencies]`, but only the `[dependencies]` that are required by the example server. These should be clearly indicated by comments.
  * Remove `"optional = true"` from each of these lines if present.

Each autogenerated API will contain an implementation stub and main entry point, which should be copied into your project the first time:
```
cp petstore_api/examples/server.rs src/main.rs
cp petstore_api/examples/server_lib/mod.rs src/lib.rs
cp petstore_api/examples/server_lib/server.rs src/server.rs
```

Now

* From `src/main.rs`, remove the `mod server_lib;` line, and uncomment and fill in the `extern crate` line with the name of this server crate.
* Move the block of imports "required by the service library" from `src/main.rs` to `src/lib.rs` and uncomment.
* Change the `let server = server::Server {};` line to `let server = SERVICE_NAME::server().unwrap();` where `SERVICE_NAME` is the name of the server crate.
* Run `cargo build` to check it builds.
* Run `cargo fmt` to reformat the code.
* Commit the result before making any further changes (lest format changes get confused with your own updates).

Now replace the implementations in `src/server.rs` with your own code as required.

## Updating your server to track API changes

Later, if the API changes, you can copy new sections  from the autogenerated API stub into your implementation.
Alternatively, implement the now-missing methods based on the compiler's error messages.
