/**
 * Swagger Petstore
 * This is a sample server Petstore server.  You can find out more about Swagger at [http://swagger.io](http://swagger.io) or on [irc.freenode.net, #swagger](http://swagger.io/irc/).  For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: apiteam@swagger.io
 *
 * NOTE: This class is auto generated by the swagger code generator 2.4.3-SNAPSHOT.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include <corvusoft/restbed/byte.hpp>
#include <corvusoft/restbed/string.hpp>
#include <corvusoft/restbed/settings.hpp>
#include <corvusoft/restbed/request.hpp>

#include "StoreApi.h"

namespace io {
namespace swagger {
namespace server {
namespace api {

using namespace io::swagger::server::model;

StoreApi::StoreApi() {
	std::shared_ptr<StoreApiStoreOrderOrderIdResource> spStoreApiStoreOrderOrderIdResource = std::make_shared<StoreApiStoreOrderOrderIdResource>();
	this->publish(spStoreApiStoreOrderOrderIdResource);
	
	std::shared_ptr<StoreApiStoreInventoryResource> spStoreApiStoreInventoryResource = std::make_shared<StoreApiStoreInventoryResource>();
	this->publish(spStoreApiStoreInventoryResource);
	
	std::shared_ptr<StoreApiStoreOrderResource> spStoreApiStoreOrderResource = std::make_shared<StoreApiStoreOrderResource>();
	this->publish(spStoreApiStoreOrderResource);
	
}

StoreApi::~StoreApi() {}

void StoreApi::startService(int const& port) {
	std::shared_ptr<restbed::Settings> settings = std::make_shared<restbed::Settings>();
	settings->set_port(port);
	settings->set_root("/v2");
	
	this->start(settings);
}

void StoreApi::stopService() {
	this->stop();
}

StoreApiStoreOrderOrderIdResource::StoreApiStoreOrderOrderIdResource()
{
	this->set_path("/store/order/{orderId: .*}/");
	this->set_method_handler("DELETE",
		std::bind(&StoreApiStoreOrderOrderIdResource::DELETE_method_handler, this,
			std::placeholders::_1));
	this->set_method_handler("GET",
		std::bind(&StoreApiStoreOrderOrderIdResource::GET_method_handler, this,
			std::placeholders::_1));
}

StoreApiStoreOrderOrderIdResource::~StoreApiStoreOrderOrderIdResource()
{
}

void StoreApiStoreOrderOrderIdResource::DELETE_method_handler(const std::shared_ptr<restbed::Session> session) {

	const auto request = session->get_request();
			
			// Getting the path params
			const std::string orderId = request->get_path_parameter("orderId", "");
			

			
			// Change the value of this variable to the appropriate response before sending the response
			int status_code = 200;
			
			/**
			 * Process the received information here
			 */
			
			if (status_code == 400) {
				session->close(400, "Invalid ID supplied", { {"Connection", "close"} });
				return;
			}
			if (status_code == 404) {
				session->close(404, "Order not found", { {"Connection", "close"} });
				return;
			}

}

void StoreApiStoreOrderOrderIdResource::GET_method_handler(const std::shared_ptr<restbed::Session> session) {

	const auto request = session->get_request();

			// Getting the path params
			const int64_t orderId = request->get_path_parameter("orderId", 0L);
			
		
			
			// Change the value of this variable to the appropriate response before sending the response
			int status_code = 200;
			
			/**
			 * Process the received information here
			 */
			
			if (status_code == 200) {
				std::shared_ptr<Order> response = NULL;
				session->close(200, "successful operation", { {"Connection", "close"} });
				return;
			}
			if (status_code == 400) {
				session->close(400, "Invalid ID supplied", { {"Connection", "close"} });
				return;
			}
			if (status_code == 404) {
				session->close(404, "Order not found", { {"Connection", "close"} });
				return;
			}

}


StoreApiStoreInventoryResource::StoreApiStoreInventoryResource()
{
	this->set_path("/store/inventory/");
	this->set_method_handler("GET",
		std::bind(&StoreApiStoreInventoryResource::GET_method_handler, this,
			std::placeholders::_1));
}

StoreApiStoreInventoryResource::~StoreApiStoreInventoryResource()
{
}

void StoreApiStoreInventoryResource::GET_method_handler(const std::shared_ptr<restbed::Session> session) {

	const auto request = session->get_request();
			
			

			
			// Change the value of this variable to the appropriate response before sending the response
			int status_code = 200;
			
			/**
			 * Process the received information here
			 */
			
			if (status_code == 200) {
				session->close(200, "successful operation", { {"Connection", "close"} });
				return;
			}

}



StoreApiStoreOrderResource::StoreApiStoreOrderResource()
{
	this->set_path("/store/order/");
	this->set_method_handler("POST",
		std::bind(&StoreApiStoreOrderResource::POST_method_handler, this,
			std::placeholders::_1));
}

StoreApiStoreOrderResource::~StoreApiStoreOrderResource()
{
}

void StoreApiStoreOrderResource::POST_method_handler(const std::shared_ptr<restbed::Session> session) {

	const auto request = session->get_request();
	// Body params are present, therefore we have to fetch them
	int content_length = request->get_header("Content-Length", 0);
	session->fetch(content_length,
		[ this ]( const std::shared_ptr<restbed::Session> session, const restbed::Bytes & body )
		{

			const auto request = session->get_request();
			std::string requestBody = restbed::String::format("%.*s\n", ( int ) body.size( ), body.data( ));
			/**
			 * Get body params or form params here from the requestBody string
			 */
			
			

			
			// Change the value of this variable to the appropriate response before sending the response
			int status_code = 200;
			
			/**
			 * Process the received information here
			 */
			
			if (status_code == 200) {
				session->close(200, "successful operation", { {"Connection", "close"} });
				return;
			}
			if (status_code == 400) {
				session->close(400, "Invalid Order", { {"Connection", "close"} });
				return;
			}

		});
}




}
}
}
}

