# SwaggerServer
This is a sample server Petstore server.  You can find out more about Swagger at [http://swagger.io](http://swagger.io) or on [irc.freenode.net, #swagger](http://swagger.io/irc/).  For this sample, you can use the api key `special-key` to test the authorization filters.

This [Symfony](https://symfony.com/) bundle is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Build package: io.swagger.codegen.languages.SymfonyServerCodegen

## Requirements

PHP 5.4.0 and later

## Installation & Usage

To install the dependencies via [Composer](http://getcomposer.org/), add the following repository to `composer.json` of your Symfony project:

```json
{
    "repositories": [{
        "type": "path",
        "url": "//Path to your generated swagger bundle"
    }],
}
```

Then run:

```
composer require swagger/server-bundle:dev-master
```

to add the generated swagger bundle as a dependency.

## Tests

To run the unit tests for the generated bundle, first navigate to the directory containing the code, then run the following commands:

```
composer install
./vendor/bin/phpunit
```


## Getting Started

Step 1: Please follow the [installation procedure](#installation--usage) first.

Step 2: Enable the bundle in the kernel:

```php
<?php
// app/AppKernel.php

public function registerBundles()
{
    $bundles = array(
        // ...
        new Swagger\Server\SwaggerServerBundle(),
        // ...
    );
}
```

Step 3: Register the routes:

```yaml
# app/config/routing.yml
swagger_server:
    resource: "@SwaggerServerBundle/Resources/config/routing.yml"
```

Step 4: Implement the API calls:

```php
<?php
// src/Acme/MyBundle/Api/PetApiInterface.php

namespace Acme\MyBundle\Api;

use Swagger\Server\Api\PetApiInterface;

class PetApi implements PetApiInterface // An interface is autogenerated
{

    /**
     * Configure OAuth2 access token for authorization: petstore_auth
     */
    public function setpetstore_auth($oauthToken)
    {
        // Retrieve logged in user from $oauthToken ...
    }
    
    /**
     * Implementation of PetApiInterface#addPet
     */
    public function addPet(Pet $body)
    {
        // Implement the operation ...
    }

    // Other operation methods ...
}
```

Step 5: Tag your API implementation:

```yaml
# src/Acme/MyBundle/Resources/services.yml
services:
    # ...
    acme.my_bundle.api.pet:
        class: Acme\MyBundle\Api\PetApi
        tags:
            - { name: "swagger_server.api", api: "pet" }
    # ...
```

Now you can start using the bundle!


## Documentation for API Endpoints

All URIs are relative to *http://petstore.swagger.io/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*PetApiInterface* | [**addPet**](Resources/docs/Api/PetApiInterface.md#addpet) | **POST** /pet | Add a new pet to the store
*PetApiInterface* | [**deletePet**](Resources/docs/Api/PetApiInterface.md#deletepet) | **DELETE** /pet/{petId} | Deletes a pet
*PetApiInterface* | [**findPetsByStatus**](Resources/docs/Api/PetApiInterface.md#findpetsbystatus) | **GET** /pet/findByStatus | Finds Pets by status
*PetApiInterface* | [**findPetsByTags**](Resources/docs/Api/PetApiInterface.md#findpetsbytags) | **GET** /pet/findByTags | Finds Pets by tags
*PetApiInterface* | [**getPetById**](Resources/docs/Api/PetApiInterface.md#getpetbyid) | **GET** /pet/{petId} | Find pet by ID
*PetApiInterface* | [**updatePet**](Resources/docs/Api/PetApiInterface.md#updatepet) | **PUT** /pet | Update an existing pet
*PetApiInterface* | [**updatePetWithForm**](Resources/docs/Api/PetApiInterface.md#updatepetwithform) | **POST** /pet/{petId} | Updates a pet in the store with form data
*PetApiInterface* | [**uploadFile**](Resources/docs/Api/PetApiInterface.md#uploadfile) | **POST** /pet/{petId}/uploadImage | uploads an image
*StoreApiInterface* | [**deleteOrder**](Resources/docs/Api/StoreApiInterface.md#deleteorder) | **DELETE** /store/order/{orderId} | Delete purchase order by ID
*StoreApiInterface* | [**getInventory**](Resources/docs/Api/StoreApiInterface.md#getinventory) | **GET** /store/inventory | Returns pet inventories by status
*StoreApiInterface* | [**getOrderById**](Resources/docs/Api/StoreApiInterface.md#getorderbyid) | **GET** /store/order/{orderId} | Find purchase order by ID
*StoreApiInterface* | [**placeOrder**](Resources/docs/Api/StoreApiInterface.md#placeorder) | **POST** /store/order | Place an order for a pet
*UserApiInterface* | [**createUser**](Resources/docs/Api/UserApiInterface.md#createuser) | **POST** /user | Create user
*UserApiInterface* | [**createUsersWithArrayInput**](Resources/docs/Api/UserApiInterface.md#createuserswitharrayinput) | **POST** /user/createWithArray | Creates list of users with given input array
*UserApiInterface* | [**createUsersWithListInput**](Resources/docs/Api/UserApiInterface.md#createuserswithlistinput) | **POST** /user/createWithList | Creates list of users with given input array
*UserApiInterface* | [**deleteUser**](Resources/docs/Api/UserApiInterface.md#deleteuser) | **DELETE** /user/{username} | Delete user
*UserApiInterface* | [**getUserByName**](Resources/docs/Api/UserApiInterface.md#getuserbyname) | **GET** /user/{username} | Get user by user name
*UserApiInterface* | [**loginUser**](Resources/docs/Api/UserApiInterface.md#loginuser) | **GET** /user/login | Logs user into the system
*UserApiInterface* | [**logoutUser**](Resources/docs/Api/UserApiInterface.md#logoutuser) | **GET** /user/logout | Logs out current logged in user session
*UserApiInterface* | [**updateUser**](Resources/docs/Api/UserApiInterface.md#updateuser) | **PUT** /user/{username} | Updated user


## Documentation For Models

 - [Amount](Resources/docs/Model/Amount.md)
 - [ApiResponse](Resources/docs/Model/ApiResponse.md)
 - [Category](Resources/docs/Model/Category.md)
 - [Currency](Resources/docs/Model/Currency.md)
 - [Order](Resources/docs/Model/Order.md)
 - [Pet](Resources/docs/Model/Pet.md)
 - [Tag](Resources/docs/Model/Tag.md)
 - [User](Resources/docs/Model/User.md)


## Documentation For Authorization


## api_key

- **Type**: API key
- **API key parameter name**: api_key
- **Location**: HTTP header

## petstore_auth

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: http://petstore.swagger.io/api/oauth/dialog
- **Scopes**: 
 - **write:pets**: modify pets in your account
 - **read:pets**: read your pets


## Author

apiteam@swagger.io


