<?php

/**
 * Swagger Petstore
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * OpenAPI spec version: 1.0.0
 * Contact: apiteam@swagger.io
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

/**
 * Swagger Petstore
 * @version 1.0.0
 */

$app->get('/', function () use ($app) {
    return $app->version();
});

/**
 * patch testSpecialTags
 * Summary: To test special tags
 * Notes: To test special tags
 * Output-Formats: [application/json]
 */
$app->patch('/v2/another-fake/dummy', 'AnotherFakeApi@testSpecialTags');
/**
 * patch testClientModel
 * Summary: To test \&quot;client\&quot; model
 * Notes: To test \&quot;client\&quot; model
 * Output-Formats: [application/json]
 */
$app->patch('/v2/fake', 'FakeApi@testClientModel');
/**
 * post testEndpointParameters
 * Summary: Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트 
 * Notes: Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트 
 * Output-Formats: [application/xml; charset=utf-8, application/json; charset=utf-8]
 */
$app->post('/v2/fake', 'FakeApi@testEndpointParameters');
/**
 * get testEnumParameters
 * Summary: To test enum parameters
 * Notes: To test enum parameters
 * Output-Formats: [*/*]
 */
$app->get('/v2/fake', 'FakeApi@testEnumParameters');
/**
 * put testBodyWithQueryParams
 * Summary: 
 * Notes: 

 */
$app->put('/v2/fake/body-with-query-params', 'FakeApi@testBodyWithQueryParams');
/**
 * post testInlineAdditionalProperties
 * Summary: test inline additionalProperties
 * Notes: 

 */
$app->post('/v2/fake/inline-additionalProperties', 'FakeApi@testInlineAdditionalProperties');
/**
 * get testJsonFormData
 * Summary: test json serialization of form data
 * Notes: 

 */
$app->get('/v2/fake/jsonFormData', 'FakeApi@testJsonFormData');
/**
 * post fakeOuterBooleanSerialize
 * Summary: 
 * Notes: Test serialization of outer boolean types

 */
$app->post('/v2/fake/outer/boolean', 'FakeApi@fakeOuterBooleanSerialize');
/**
 * post fakeOuterCompositeSerialize
 * Summary: 
 * Notes: Test serialization of object with outer number type

 */
$app->post('/v2/fake/outer/composite', 'FakeApi@fakeOuterCompositeSerialize');
/**
 * post fakeOuterNumberSerialize
 * Summary: 
 * Notes: Test serialization of outer number types

 */
$app->post('/v2/fake/outer/number', 'FakeApi@fakeOuterNumberSerialize');
/**
 * post fakeOuterStringSerialize
 * Summary: 
 * Notes: Test serialization of outer string types

 */
$app->post('/v2/fake/outer/string', 'FakeApi@fakeOuterStringSerialize');
/**
 * patch testClassname
 * Summary: To test class name in snake case
 * Notes: To test class name in snake case
 * Output-Formats: [application/json]
 */
$app->patch('/v2/fake_classname_test', 'FakeClassnameTags123Api@testClassname');
/**
 * post addPet
 * Summary: Add a new pet to the store
 * Notes: 
 * Output-Formats: [application/xml, application/json]
 */
$app->post('/v2/pet', 'PetApi@addPet');
/**
 * put updatePet
 * Summary: Update an existing pet
 * Notes: 
 * Output-Formats: [application/xml, application/json]
 */
$app->put('/v2/pet', 'PetApi@updatePet');
/**
 * get findPetsByStatus
 * Summary: Finds Pets by status
 * Notes: Multiple status values can be provided with comma separated strings
 * Output-Formats: [application/xml, application/json]
 */
$app->get('/v2/pet/findByStatus', 'PetApi@findPetsByStatus');
/**
 * get findPetsByTags
 * Summary: Finds Pets by tags
 * Notes: Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
 * Output-Formats: [application/xml, application/json]
 */
$app->get('/v2/pet/findByTags', 'PetApi@findPetsByTags');
/**
 * delete deletePet
 * Summary: Deletes a pet
 * Notes: 
 * Output-Formats: [application/xml, application/json]
 */
$app->delete('/v2/pet/{petId}', 'PetApi@deletePet');
/**
 * get getPetById
 * Summary: Find pet by ID
 * Notes: Returns a single pet
 * Output-Formats: [application/xml, application/json]
 */
$app->get('/v2/pet/{petId}', 'PetApi@getPetById');
/**
 * post updatePetWithForm
 * Summary: Updates a pet in the store with form data
 * Notes: 
 * Output-Formats: [application/xml, application/json]
 */
$app->post('/v2/pet/{petId}', 'PetApi@updatePetWithForm');
/**
 * post uploadFile
 * Summary: uploads an image
 * Notes: 
 * Output-Formats: [application/json]
 */
$app->post('/v2/pet/{petId}/uploadImage', 'PetApi@uploadFile');
/**
 * get getInventory
 * Summary: Returns pet inventories by status
 * Notes: Returns a map of status codes to quantities
 * Output-Formats: [application/json]
 */
$app->get('/v2/store/inventory', 'StoreApi@getInventory');
/**
 * post placeOrder
 * Summary: Place an order for a pet
 * Notes: 
 * Output-Formats: [application/xml, application/json]
 */
$app->post('/v2/store/order', 'StoreApi@placeOrder');
/**
 * delete deleteOrder
 * Summary: Delete purchase order by ID
 * Notes: For valid response try integer IDs with value &lt; 1000. Anything above 1000 or nonintegers will generate API errors
 * Output-Formats: [application/xml, application/json]
 */
$app->delete('/v2/store/order/{order_id}', 'StoreApi@deleteOrder');
/**
 * get getOrderById
 * Summary: Find purchase order by ID
 * Notes: For valid response try integer IDs with value &lt;&#x3D; 5 or &gt; 10. Other values will generated exceptions
 * Output-Formats: [application/xml, application/json]
 */
$app->get('/v2/store/order/{order_id}', 'StoreApi@getOrderById');
/**
 * post createUser
 * Summary: Create user
 * Notes: This can only be done by the logged in user.
 * Output-Formats: [application/xml, application/json]
 */
$app->post('/v2/user', 'UserApi@createUser');
/**
 * post createUsersWithArrayInput
 * Summary: Creates list of users with given input array
 * Notes: 
 * Output-Formats: [application/xml, application/json]
 */
$app->post('/v2/user/createWithArray', 'UserApi@createUsersWithArrayInput');
/**
 * post createUsersWithListInput
 * Summary: Creates list of users with given input array
 * Notes: 
 * Output-Formats: [application/xml, application/json]
 */
$app->post('/v2/user/createWithList', 'UserApi@createUsersWithListInput');
/**
 * get loginUser
 * Summary: Logs user into the system
 * Notes: 
 * Output-Formats: [application/xml, application/json]
 */
$app->get('/v2/user/login', 'UserApi@loginUser');
/**
 * get logoutUser
 * Summary: Logs out current logged in user session
 * Notes: 
 * Output-Formats: [application/xml, application/json]
 */
$app->get('/v2/user/logout', 'UserApi@logoutUser');
/**
 * delete deleteUser
 * Summary: Delete user
 * Notes: This can only be done by the logged in user.
 * Output-Formats: [application/xml, application/json]
 */
$app->delete('/v2/user/{username}', 'UserApi@deleteUser');
/**
 * get getUserByName
 * Summary: Get user by user name
 * Notes: 
 * Output-Formats: [application/xml, application/json]
 */
$app->get('/v2/user/{username}', 'UserApi@getUserByName');
/**
 * put updateUser
 * Summary: Updated user
 * Notes: This can only be done by the logged in user.
 * Output-Formats: [application/xml, application/json]
 */
$app->put('/v2/user/{username}', 'UserApi@updateUser');

