//
// Swift4TestAPI.swift
//
// Generated by swagger-codegen
// https://github.com/swagger-api/swagger-codegen
//

import Foundation
import Alamofire



open class Swift4TestAPI {
    /**
     Get all of the models
     
     - parameter clientId: (query) id that represent the Api client 
     - parameter completion: completion handler to receive the data and the error objects
     */
    open class func getAllModels(clientId: String, completion: @escaping ((_ data: GetAllModelsResult?,_ error: Error?) -> Void)) {
        getAllModelsWithRequestBuilder(clientId: clientId).execute { (response, error) -> Void in
            completion(response?.body, error)
        }
    }


    /**
     Get all of the models
     - GET /allModels
     - This endpoint tests get a dictionary which contains examples of all of the models.
     - examples: [{contentType=application/json, example={
  "myPrimitive" : {
    "myDateTimeArray" : [ "2000-01-23T04:56:07.000+00:00", "2000-01-23T04:56:07.000+00:00" ],
    "myStringArray" : [ "myStringArray", "myStringArray" ],
    "myFile" : "",
    "myBytes" : "myBytes",
    "myLong" : 1,
    "myBooleanArray" : [ true, true ],
    "myInteger" : 0,
    "myBytesArray" : [ "myBytesArray", "myBytesArray" ],
    "myDouble" : 7.061401241503109,
    "myIntegerArray" : [ 6, 6 ],
    "myInlineStringEnum" : "inlineStringEnumValue1",
    "myFileArray" : [ "", "" ],
    "myFloat" : 5.637377,
    "myStringEnumArray" : [ null, null ],
    "myFloatArray" : [ 2.302136, 2.302136 ],
    "myDoubleArray" : [ 9.301444243932576, 9.301444243932576 ],
    "myString" : "myString",
    "myDate" : "2000-01-23",
    "myDateArray" : [ "2000-01-23", "2000-01-23" ],
    "myDateTime" : "2000-01-23T04:56:07.000+00:00",
    "myLongArray" : [ 5, 5 ],
    "myUUID" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "myBoolean" : true,
    "myStringEnum" : { },
    "myUUIDArray" : [ "046b6c7f-0b8a-43b9-b35d-6489e6daee91", "046b6c7f-0b8a-43b9-b35d-6489e6daee91" ]
  },
  "myVariableNameTest" : {
    "normalName" : "normalName",
    "for" : "for",
    "example_name" : "example_name"
  },
  "myPrimitiveArray" : [ {
    "myDateTimeArray" : [ "2000-01-23T04:56:07.000+00:00", "2000-01-23T04:56:07.000+00:00" ],
    "myStringArray" : [ "myStringArray", "myStringArray" ],
    "myFile" : "",
    "myBytes" : "myBytes",
    "myLong" : 1,
    "myBooleanArray" : [ true, true ],
    "myInteger" : 0,
    "myBytesArray" : [ "myBytesArray", "myBytesArray" ],
    "myDouble" : 7.061401241503109,
    "myIntegerArray" : [ 6, 6 ],
    "myInlineStringEnum" : "inlineStringEnumValue1",
    "myFileArray" : [ "", "" ],
    "myFloat" : 5.637377,
    "myStringEnumArray" : [ null, null ],
    "myFloatArray" : [ 2.302136, 2.302136 ],
    "myDoubleArray" : [ 9.301444243932576, 9.301444243932576 ],
    "myString" : "myString",
    "myDate" : "2000-01-23",
    "myDateArray" : [ "2000-01-23", "2000-01-23" ],
    "myDateTime" : "2000-01-23T04:56:07.000+00:00",
    "myLongArray" : [ 5, 5 ],
    "myUUID" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "myBoolean" : true,
    "myStringEnum" : { },
    "myUUIDArray" : [ "046b6c7f-0b8a-43b9-b35d-6489e6daee91", "046b6c7f-0b8a-43b9-b35d-6489e6daee91" ]
  }, {
    "myDateTimeArray" : [ "2000-01-23T04:56:07.000+00:00", "2000-01-23T04:56:07.000+00:00" ],
    "myStringArray" : [ "myStringArray", "myStringArray" ],
    "myFile" : "",
    "myBytes" : "myBytes",
    "myLong" : 1,
    "myBooleanArray" : [ true, true ],
    "myInteger" : 0,
    "myBytesArray" : [ "myBytesArray", "myBytesArray" ],
    "myDouble" : 7.061401241503109,
    "myIntegerArray" : [ 6, 6 ],
    "myInlineStringEnum" : "inlineStringEnumValue1",
    "myFileArray" : [ "", "" ],
    "myFloat" : 5.637377,
    "myStringEnumArray" : [ null, null ],
    "myFloatArray" : [ 2.302136, 2.302136 ],
    "myDoubleArray" : [ 9.301444243932576, 9.301444243932576 ],
    "myString" : "myString",
    "myDate" : "2000-01-23",
    "myDateArray" : [ "2000-01-23", "2000-01-23" ],
    "myDateTime" : "2000-01-23T04:56:07.000+00:00",
    "myLongArray" : [ 5, 5 ],
    "myUUID" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "myBoolean" : true,
    "myStringEnum" : { },
    "myUUIDArray" : [ "046b6c7f-0b8a-43b9-b35d-6489e6daee91", "046b6c7f-0b8a-43b9-b35d-6489e6daee91" ]
  } ]
}}]
     
     - parameter clientId: (query) id that represent the Api client 

     - returns: RequestBuilder<GetAllModelsResult> 
     */
    open class func getAllModelsWithRequestBuilder(clientId: String) -> RequestBuilder<GetAllModelsResult> {
        let path = "/allModels"
        let URLString = TestClientAPI.basePath + path
        let parameters: [String:Any]? = nil
        
        var url = URLComponents(string: URLString)
        url?.queryItems = APIHelper.mapValuesToQueryItems([
            "client_id": clientId
        ])

        let requestBuilder: RequestBuilder<GetAllModelsResult>.Type = TestClientAPI.requestBuilderFactory.getBuilder()

        return requestBuilder.init(method: "GET", URLString: (url?.string ?? URLString), parameters: parameters, isBody: false)
    }

}
