package io.swagger.client.api

trait QueryParam[A] {
  def toParamString(a: A): String
}

object QueryParam {
  implicit def strQueryParam: QueryParam[String] = new QueryParam[String] {
    def toParamString(s: String): String = s
  }

  implicit def listStrQueryParam: QueryParam[List[String]] = new QueryParam[List[String]] {
    def toParamString(s: List[String]): String = s.mkString(",")
  }
}
