# Swagger Petstore
#
# This is a sample server Petstore server.  You can find out more about Swagger at [http://swagger.io](http://swagger.io) or on [irc.freenode.net, #swagger](http://swagger.io/irc/).  For this sample, you can use the api key `special-key` to test the authorization filters.
#
# OpenAPI spec version: 1.0.0
# Contact: apiteam@swagger.io
# Generated by: https://github.com/swagger-api/swagger-codegen.git


#' Pet Class
#'
#' @field id 
#' @field category 
#' @field name 
#' @field photoUrls 
#' @field tags 
#' @field status 
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
Pet <- R6::R6Class(
  'Pet',
  public = list(
    `id` = NULL,
    `category` = NULL,
    `name` = NULL,
    `photoUrls` = NULL,
    `tags` = NULL,
    `status` = NULL,
    initialize = function(`id`, `category`, `name`, `photoUrls`, `tags`, `status`){
      if (!missing(`id`)) {
        stopifnot(is.numeric(`id`), length(`id`) == 1)
        self$`id` <- `id`
      }
      if (!missing(`category`)) {
        stopifnot(R6::is.R6(`category`))
        self$`category` <- `category`
      }
      if (!missing(`name`)) {
        stopifnot(is.character(`name`), length(`name`) == 1)
        self$`name` <- `name`
      }
      if (!missing(`photoUrls`)) {
        stopifnot(is.list(`photoUrls`), length(`photoUrls`) != 0)
        lapply(`photoUrls`, function(x) stopifnot(is.character(x)))
        self$`photoUrls` <- `photoUrls`
      }
      if (!missing(`tags`)) {
        stopifnot(is.list(`tags`), length(`tags`) != 0)
        lapply(`tags`, function(x) stopifnot(R6::is.R6(x)))
        self$`tags` <- `tags`
      }
      if (!missing(`status`)) {
        stopifnot(is.character(`status`), length(`status`) == 1)
        self$`status` <- `status`
      }
    },
    toJSON = function() {
      PetObject <- list()
      if (!is.null(self$`id`)) {
        PetObject[['id']] <- self$`id`
      }
      if (!is.null(self$`category`)) {
        PetObject[['category']] <- self$`category`$toJSON()
      }
      if (!is.null(self$`name`)) {
        PetObject[['name']] <- self$`name`
      }
      if (!is.null(self$`photoUrls`)) {
        PetObject[['photoUrls']] <- self$`photoUrls`
      }
      if (!is.null(self$`tags`)) {
        PetObject[['tags']] <- lapply(self$`tags`, function(x) x$toJSON())
      }
      if (!is.null(self$`status`)) {
        PetObject[['status']] <- self$`status`
      }

      PetObject
    },
    fromJSON = function(PetJson) {
      PetObject <- jsonlite::fromJSON(PetJson)
      if (!is.null(PetObject$`id`)) {
        self$`id` <- PetObject$`id`
      }
      if (!is.null(PetObject$`category`)) {
        categoryObject <- Category$new()
        categoryObject$fromJSON(jsonlite::toJSON(PetObject$category, auto_unbox = TRUE))
        self$`category` <- categoryObject
      }
      if (!is.null(PetObject$`name`)) {
        self$`name` <- PetObject$`name`
      }
      if (!is.null(PetObject$`photoUrls`)) {
        self$`photoUrls` <- PetObject$`photoUrls`
      }
      if (!is.null(PetObject$`tags`)) {
        self$`tags` <- lapply(PetObject$`tags`, function(x) {
          tagsObject <- Tag$new()
          tagsObject$fromJSON(jsonlite::toJSON(x, auto_unbox = TRUE))
          tagsObject
        })
      }
      if (!is.null(PetObject$`status`)) {
        self$`status` <- PetObject$`status`
      }
    },
    toJSONString = function() {
       sprintf(
        '{
           "id": %d,
           "category": %s,
           "name": %s,
           "photoUrls": [%s],
           "tags": [%s],
           "status": %s
        }',
        self$`id`,
        self$`category`$toJSON(),
        self$`name`,
        lapply(self$`photoUrls`, function(x) paste(paste0('"', x, '"'), sep=",")),
        lapply(self$`tags`, function(x) paste(x$toJSON(), sep=",")),
        self$`status`
      )
    },
    fromJSONString = function(PetJson) {
      PetObject <- jsonlite::fromJSON(PetJson)
      self$`id` <- PetObject$`id`
      CategoryObject <- Category$new()
      self$`category` <- CategoryObject$fromJSON(jsonlite::toJSON(PetObject$category, auto_unbox = TRUE))
      self$`name` <- PetObject$`name`
      self$`photoUrls` <- PetObject$`photoUrls`
      self$`tags` <- lapply(PetObject$`tags`, function(x) Tag$new()$fromJSON(jsonlite::toJSON(x, auto_unbox = TRUE)))
      self$`status` <- PetObject$`status`
    }
  )
)
