# Swagger Petstore
#
# This is a sample server Petstore server.  You can find out more about Swagger at [http://swagger.io](http://swagger.io) or on [irc.freenode.net, #swagger](http://swagger.io/irc/).  For this sample, you can use the api key `special-key` to test the authorization filters.
#
# OpenAPI spec version: 1.0.0
# Contact: apiteam@swagger.io
# Generated by: https://github.com/swagger-api/swagger-codegen.git


#' Order Class
#'
#' @field id 
#' @field petId 
#' @field quantity 
#' @field shipDate 
#' @field status 
#' @field complete 
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
Order <- R6::R6Class(
  'Order',
  public = list(
    `id` = NULL,
    `petId` = NULL,
    `quantity` = NULL,
    `shipDate` = NULL,
    `status` = NULL,
    `complete` = NULL,
    initialize = function(`id`, `petId`, `quantity`, `shipDate`, `status`, `complete`){
      if (!missing(`id`)) {
        stopifnot(is.numeric(`id`), length(`id`) == 1)
        self$`id` <- `id`
      }
      if (!missing(`petId`)) {
        stopifnot(is.numeric(`petId`), length(`petId`) == 1)
        self$`petId` <- `petId`
      }
      if (!missing(`quantity`)) {
        stopifnot(is.numeric(`quantity`), length(`quantity`) == 1)
        self$`quantity` <- `quantity`
      }
      if (!missing(`shipDate`)) {
        stopifnot(is.character(`shipDate`), length(`shipDate`) == 1)
        self$`shipDate` <- `shipDate`
      }
      if (!missing(`status`)) {
        stopifnot(is.character(`status`), length(`status`) == 1)
        self$`status` <- `status`
      }
      if (!missing(`complete`)) {
        self$`complete` <- `complete`
      }
    },
    toJSON = function() {
      OrderObject <- list()
      if (!is.null(self$`id`)) {
        OrderObject[['id']] <- self$`id`
      }
      if (!is.null(self$`petId`)) {
        OrderObject[['petId']] <- self$`petId`
      }
      if (!is.null(self$`quantity`)) {
        OrderObject[['quantity']] <- self$`quantity`
      }
      if (!is.null(self$`shipDate`)) {
        OrderObject[['shipDate']] <- self$`shipDate`
      }
      if (!is.null(self$`status`)) {
        OrderObject[['status']] <- self$`status`
      }
      if (!is.null(self$`complete`)) {
        OrderObject[['complete']] <- self$`complete`
      }

      OrderObject
    },
    fromJSON = function(OrderJson) {
      OrderObject <- jsonlite::fromJSON(OrderJson)
      if (!is.null(OrderObject$`id`)) {
        self$`id` <- OrderObject$`id`
      }
      if (!is.null(OrderObject$`petId`)) {
        self$`petId` <- OrderObject$`petId`
      }
      if (!is.null(OrderObject$`quantity`)) {
        self$`quantity` <- OrderObject$`quantity`
      }
      if (!is.null(OrderObject$`shipDate`)) {
        self$`shipDate` <- OrderObject$`shipDate`
      }
      if (!is.null(OrderObject$`status`)) {
        self$`status` <- OrderObject$`status`
      }
      if (!is.null(OrderObject$`complete`)) {
        self$`complete` <- OrderObject$`complete`
      }
    },
    toJSONString = function() {
       sprintf(
        '{
           "id": %d,
           "petId": %d,
           "quantity": %s,
           "shipDate": %s,
           "status": %s,
           "complete": %s
        }',
        self$`id`,
        self$`petId`,
        self$`quantity`,
        self$`shipDate`,
        self$`status`,
        self$`complete`
      )
    },
    fromJSONString = function(OrderJson) {
      OrderObject <- jsonlite::fromJSON(OrderJson)
      self$`id` <- OrderObject$`id`
      self$`petId` <- OrderObject$`petId`
      self$`quantity` <- OrderObject$`quantity`
      self$`shipDate` <- OrderObject$`shipDate`
      self$`status` <- OrderObject$`status`
      self$`complete` <- OrderObject$`complete`
    }
  )
)
