# Swagger Petstore
#
# This is a sample server Petstore server.  You can find out more about Swagger at [http://swagger.io](http://swagger.io) or on [irc.freenode.net, #swagger](http://swagger.io/irc/).  For this sample, you can use the api key `special-key` to test the authorization filters.
#
# OpenAPI spec version: 1.0.0
# Contact: apiteam@swagger.io
# Generated by: https://github.com/swagger-api/swagger-codegen.git


#' Amount Class
#'
#' @field value 
#' @field currency 
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
Amount <- R6::R6Class(
  'Amount',
  public = list(
    `value` = NULL,
    `currency` = NULL,
    initialize = function(`value`, `currency`){
      if (!missing(`value`)) {
        stopifnot(is.numeric(`value`), length(`value`) == 1)
        self$`value` <- `value`
      }
      if (!missing(`currency`)) {
        stopifnot(R6::is.R6(`currency`))
        self$`currency` <- `currency`
      }
    },
    toJSON = function() {
      AmountObject <- list()
      if (!is.null(self$`value`)) {
        AmountObject[['value']] <- self$`value`
      }
      if (!is.null(self$`currency`)) {
        AmountObject[['currency']] <- self$`currency`$toJSON()
      }

      AmountObject
    },
    fromJSON = function(AmountJson) {
      AmountObject <- jsonlite::fromJSON(AmountJson)
      if (!is.null(AmountObject$`value`)) {
        self$`value` <- AmountObject$`value`
      }
      if (!is.null(AmountObject$`currency`)) {
        currencyObject <- Currency$new()
        currencyObject$fromJSON(jsonlite::toJSON(AmountObject$currency, auto_unbox = TRUE))
        self$`currency` <- currencyObject
      }
    },
    toJSONString = function() {
       sprintf(
        '{
           "value": %d,
           "currency": %s
        }',
        self$`value`,
        self$`currency`$toJSON()
      )
    },
    fromJSONString = function(AmountJson) {
      AmountObject <- jsonlite::fromJSON(AmountJson)
      self$`value` <- AmountObject$`value`
      CurrencyObject <- Currency$new()
      self$`currency` <- CurrencyObject$fromJSON(jsonlite::toJSON(AmountObject$currency, auto_unbox = TRUE))
    }
  )
)
