/*
 * Swagger Petstore
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * OpenAPI spec version: 1.0.0
 * Contact: apiteam@swagger.io
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.api;

import io.restassured.builder.RequestSpecBuilder;
import io.restassured.filter.log.ErrorLoggingFilter;
import io.swagger.client.ApiClient;
import io.swagger.client.model.Order;
import org.junit.Before;
import org.junit.Test;
import org.threeten.bp.OffsetDateTime;

import java.util.Map;

import static io.restassured.config.ObjectMapperConfig.objectMapperConfig;
import static io.restassured.config.RestAssuredConfig.config;
import static io.swagger.client.GsonObjectMapper.gson;
import static io.swagger.client.ResponseSpecBuilders.shouldBeCode;
import static io.swagger.client.ResponseSpecBuilders.validatedWith;
import static org.apache.http.HttpStatus.SC_NOT_FOUND;
import static org.apache.http.HttpStatus.SC_OK;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.greaterThan;

/**
 * API tests for StoreApi
 */
public class StoreApiTest {

    private StoreApi api;

    @Before
    public void createApi() {
        api = ApiClient.api(ApiClient.Config.apiConfig().reqSpecSupplier(
                () -> new RequestSpecBuilder().setConfig(config().objectMapperConfig(objectMapperConfig().defaultObjectMapper(gson())))
                        .addFilter(new ErrorLoggingFilter())
                        .setBaseUri("http://petstore.swagger.io:80/v2"))).store();
    }

    @Test
    public void getInventoryTest() {
        Map<String, Integer> inventory = api.getInventory().executeAs(validatedWith(shouldBeCode(SC_OK)));
        assertThat(inventory.keySet().size(), greaterThan(0));
    }

    @Test
    public void getOrderByIdTest() {
        Order order = getOrder();
        api.placeOrder().body(order).execute(validatedWith(shouldBeCode(SC_OK)));
        Long orderId = api.getOrderById()
                .orderIdPath(order.getId()).executeAs(validatedWith(shouldBeCode(SC_OK))).getId();
        assertThat(orderId, equalTo(order.getId()));
        api.deleteOrder().orderIdPath(orderId).execute(validatedWith(shouldBeCode(SC_OK)));

    }

    @Test
    public void placeAndDeleteOrderTest() {
        Order order = getOrder();
        Long id = api.placeOrder()
                .body(order).executeAs(validatedWith(shouldBeCode(SC_OK))).getId();
        api.deleteOrder().orderIdPath(id)
                .execute(validatedWith(shouldBeCode(SC_OK)));
        api.getOrderById().orderIdPath(order.getId()).execute(validatedWith(shouldBeCode(SC_NOT_FOUND)));
    }

    private Order getOrder() {
        return new Order().id(TestUtils.nextId()).complete(false).petId(0L)
                .quantity(111).status(Order.StatusEnum.DELIVERED).shipDate(OffsetDateTime.now().withNano(123000000));
    }

}