/*
 * Swagger Petstore
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * OpenAPI spec version: 1.0.0
 * Contact: apiteam@swagger.io
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import io.swagger.client.model.ModelApiResponse;
import io.swagger.client.model.Pet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.builder.ResponseSpecBuilder;
import io.restassured.response.Response;

import java.lang.reflect.Type;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import io.swagger.client.JSON;

import static io.restassured.http.Method.*;

public class PetApi {

    private RequestSpecBuilder reqSpec;

    private PetApi(RequestSpecBuilder reqSpec) {
        this.reqSpec = reqSpec;
    }

    public static PetApi pet(RequestSpecBuilder reqSpec) {
        return new PetApi(reqSpec);
    }


    public AddPetOper addPet() {
        return new AddPetOper(reqSpec);
    }

    public DeletePetOper deletePet() {
        return new DeletePetOper(reqSpec);
    }

    public FindPetsByStatusOper findPetsByStatus() {
        return new FindPetsByStatusOper(reqSpec);
    }

    @Deprecated
    public FindPetsByTagsOper findPetsByTags() {
        return new FindPetsByTagsOper(reqSpec);
    }

    public GetPetByIdOper getPetById() {
        return new GetPetByIdOper(reqSpec);
    }

    public UpdatePetOper updatePet() {
        return new UpdatePetOper(reqSpec);
    }

    public UpdatePetWithFormOper updatePetWithForm() {
        return new UpdatePetWithFormOper(reqSpec);
    }

    public UploadFileOper uploadFile() {
        return new UploadFileOper(reqSpec);
    }

    /**
    * Customise request specification
    */
    public PetApi reqSpec(Consumer<RequestSpecBuilder> consumer) {
        consumer.accept(reqSpec);
        return this;
    }

    /**
     * Add a new pet to the store
     * 
     *
     * @see #body Pet object that needs to be added to the store (required)
     */
    public class AddPetOper {

        public static final String REQ_URI = "/pet";

        private RequestSpecBuilder reqSpec;

        private ResponseSpecBuilder respSpec;

        public AddPetOper() {
            this.reqSpec = new RequestSpecBuilder();
            reqSpec.setContentType("application/json");
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        public AddPetOper(RequestSpecBuilder reqSpec) {
            this.reqSpec = reqSpec;
            reqSpec.setContentType("application/json");
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        /**
         * POST /pet
         */
        public <T> T execute(Function<Response, T> handler) {
            return handler.apply(RestAssured.given().spec(reqSpec.build()).expect().spec(respSpec.build()).when().request(POST, REQ_URI));
        }

         /**
         * @param body (Pet) Pet object that needs to be added to the store (required)
         */
        public AddPetOper body(Pet body) {
            reqSpec.setBody(body);
            return this;
        }

        /**
         * Customise request specification
         */
        public AddPetOper reqSpec(Consumer<RequestSpecBuilder> consumer) {
            consumer.accept(reqSpec);
            return this;
        }

        /**
         * Customise response specification
         */
        public AddPetOper respSpec(Consumer<ResponseSpecBuilder> consumer) {
            consumer.accept(respSpec);
            return this;
        }
    }
    /**
     * Deletes a pet
     * 
     *
     * @see #petIdPath Pet id to delete (required)
     * @see #apiKeyHeader  (optional)
     */
    public class DeletePetOper {

        public static final String REQ_URI = "/pet/{petId}";

        private RequestSpecBuilder reqSpec;

        private ResponseSpecBuilder respSpec;

        public DeletePetOper() {
            this.reqSpec = new RequestSpecBuilder();
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        public DeletePetOper(RequestSpecBuilder reqSpec) {
            this.reqSpec = reqSpec;
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        /**
         * DELETE /pet/{petId}
         */
        public <T> T execute(Function<Response, T> handler) {
            return handler.apply(RestAssured.given().spec(reqSpec.build()).expect().spec(respSpec.build()).when().request(DELETE, REQ_URI));
        }

        /**
         * @param apiKey (String)  (optional)
         */
        public DeletePetOper apiKeyHeader(String apiKey) {
            reqSpec.addHeader("api_key", apiKey);
            return this;
        }

        /**
         * @param petId (Long) Pet id to delete (required)
         */
        public DeletePetOper petIdPath(Object petId) {
            reqSpec.addPathParam("petId", petId);
            return this;
        }

        /**
         * Customise request specification
         */
        public DeletePetOper reqSpec(Consumer<RequestSpecBuilder> consumer) {
            consumer.accept(reqSpec);
            return this;
        }

        /**
         * Customise response specification
         */
        public DeletePetOper respSpec(Consumer<ResponseSpecBuilder> consumer) {
            consumer.accept(respSpec);
            return this;
        }
    }
    /**
     * Finds Pets by status
     * Multiple status values can be provided with comma separated strings
     *
     * @see #statusQuery Status values that need to be considered for filter (required)
     * return List<Pet>
     */
    public class FindPetsByStatusOper {

        public static final String REQ_URI = "/pet/findByStatus";

        private RequestSpecBuilder reqSpec;

        private ResponseSpecBuilder respSpec;

        public FindPetsByStatusOper() {
            this.reqSpec = new RequestSpecBuilder();
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        public FindPetsByStatusOper(RequestSpecBuilder reqSpec) {
            this.reqSpec = reqSpec;
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        /**
         * GET /pet/findByStatus
         */
        public <T> T execute(Function<Response, T> handler) {
            return handler.apply(RestAssured.given().spec(reqSpec.build()).expect().spec(respSpec.build()).when().request(GET, REQ_URI));
        }

        /**
         * GET /pet/findByStatus
         * @return List<Pet>
         */
        public List<Pet> executeAs(Function<Response, Response> handler) {
            Type type = new TypeToken<List<Pet>>(){}.getType();
            return execute(handler).as(type);
        }

        /**
         * @param status (List<String>) Status values that need to be considered for filter (required)
         */
        public FindPetsByStatusOper statusQuery(Object... status) {
            reqSpec.addQueryParam("status", status);
            return this;
        }

        /**
         * Customise request specification
         */
        public FindPetsByStatusOper reqSpec(Consumer<RequestSpecBuilder> consumer) {
            consumer.accept(reqSpec);
            return this;
        }

        /**
         * Customise response specification
         */
        public FindPetsByStatusOper respSpec(Consumer<ResponseSpecBuilder> consumer) {
            consumer.accept(respSpec);
            return this;
        }
    }
    /**
     * Finds Pets by tags
     * Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
     *
     * @see #tagsQuery Tags to filter by (required)
     * return List<Pet>
     * @deprecated
     */
    @Deprecated
    public class FindPetsByTagsOper {

        public static final String REQ_URI = "/pet/findByTags";

        private RequestSpecBuilder reqSpec;

        private ResponseSpecBuilder respSpec;

        public FindPetsByTagsOper() {
            this.reqSpec = new RequestSpecBuilder();
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        public FindPetsByTagsOper(RequestSpecBuilder reqSpec) {
            this.reqSpec = reqSpec;
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        /**
         * GET /pet/findByTags
         */
        public <T> T execute(Function<Response, T> handler) {
            return handler.apply(RestAssured.given().spec(reqSpec.build()).expect().spec(respSpec.build()).when().request(GET, REQ_URI));
        }

        /**
         * GET /pet/findByTags
         * @return List<Pet>
         */
        public List<Pet> executeAs(Function<Response, Response> handler) {
            Type type = new TypeToken<List<Pet>>(){}.getType();
            return execute(handler).as(type);
        }

        /**
         * @param tags (List<String>) Tags to filter by (required)
         */
        public FindPetsByTagsOper tagsQuery(Object... tags) {
            reqSpec.addQueryParam("tags", tags);
            return this;
        }

        /**
         * Customise request specification
         */
        public FindPetsByTagsOper reqSpec(Consumer<RequestSpecBuilder> consumer) {
            consumer.accept(reqSpec);
            return this;
        }

        /**
         * Customise response specification
         */
        public FindPetsByTagsOper respSpec(Consumer<ResponseSpecBuilder> consumer) {
            consumer.accept(respSpec);
            return this;
        }
    }
    /**
     * Find pet by ID
     * Returns a single pet
     *
     * @see #petIdPath ID of pet to return (required)
     * return Pet
     */
    public class GetPetByIdOper {

        public static final String REQ_URI = "/pet/{petId}";

        private RequestSpecBuilder reqSpec;

        private ResponseSpecBuilder respSpec;

        public GetPetByIdOper() {
            this.reqSpec = new RequestSpecBuilder();
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        public GetPetByIdOper(RequestSpecBuilder reqSpec) {
            this.reqSpec = reqSpec;
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        /**
         * GET /pet/{petId}
         */
        public <T> T execute(Function<Response, T> handler) {
            return handler.apply(RestAssured.given().spec(reqSpec.build()).expect().spec(respSpec.build()).when().request(GET, REQ_URI));
        }

        /**
         * GET /pet/{petId}
         * @return Pet
         */
        public Pet executeAs(Function<Response, Response> handler) {
            Type type = new TypeToken<Pet>(){}.getType();
            return execute(handler).as(type);
        }

        /**
         * @param petId (Long) ID of pet to return (required)
         */
        public GetPetByIdOper petIdPath(Object petId) {
            reqSpec.addPathParam("petId", petId);
            return this;
        }

        /**
         * Customise request specification
         */
        public GetPetByIdOper reqSpec(Consumer<RequestSpecBuilder> consumer) {
            consumer.accept(reqSpec);
            return this;
        }

        /**
         * Customise response specification
         */
        public GetPetByIdOper respSpec(Consumer<ResponseSpecBuilder> consumer) {
            consumer.accept(respSpec);
            return this;
        }
    }
    /**
     * Update an existing pet
     * 
     *
     * @see #body Pet object that needs to be added to the store (required)
     */
    public class UpdatePetOper {

        public static final String REQ_URI = "/pet";

        private RequestSpecBuilder reqSpec;

        private ResponseSpecBuilder respSpec;

        public UpdatePetOper() {
            this.reqSpec = new RequestSpecBuilder();
            reqSpec.setContentType("application/json");
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        public UpdatePetOper(RequestSpecBuilder reqSpec) {
            this.reqSpec = reqSpec;
            reqSpec.setContentType("application/json");
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        /**
         * PUT /pet
         */
        public <T> T execute(Function<Response, T> handler) {
            return handler.apply(RestAssured.given().spec(reqSpec.build()).expect().spec(respSpec.build()).when().request(PUT, REQ_URI));
        }

         /**
         * @param body (Pet) Pet object that needs to be added to the store (required)
         */
        public UpdatePetOper body(Pet body) {
            reqSpec.setBody(body);
            return this;
        }

        /**
         * Customise request specification
         */
        public UpdatePetOper reqSpec(Consumer<RequestSpecBuilder> consumer) {
            consumer.accept(reqSpec);
            return this;
        }

        /**
         * Customise response specification
         */
        public UpdatePetOper respSpec(Consumer<ResponseSpecBuilder> consumer) {
            consumer.accept(respSpec);
            return this;
        }
    }
    /**
     * Updates a pet in the store with form data
     * 
     *
     * @see #petIdPath ID of pet that needs to be updated (required)
     * @see #nameForm Updated name of the pet (optional)
     * @see #statusForm Updated status of the pet (optional)
     */
    public class UpdatePetWithFormOper {

        public static final String REQ_URI = "/pet/{petId}";

        private RequestSpecBuilder reqSpec;

        private ResponseSpecBuilder respSpec;

        public UpdatePetWithFormOper() {
            this.reqSpec = new RequestSpecBuilder();
            reqSpec.setContentType("application/x-www-form-urlencoded");
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        public UpdatePetWithFormOper(RequestSpecBuilder reqSpec) {
            this.reqSpec = reqSpec;
            reqSpec.setContentType("application/x-www-form-urlencoded");
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        /**
         * POST /pet/{petId}
         */
        public <T> T execute(Function<Response, T> handler) {
            return handler.apply(RestAssured.given().spec(reqSpec.build()).expect().spec(respSpec.build()).when().request(POST, REQ_URI));
        }

        /**
         * @param petId (Long) ID of pet that needs to be updated (required)
         */
        public UpdatePetWithFormOper petIdPath(Object petId) {
            reqSpec.addPathParam("petId", petId);
            return this;
        }

         /**
         * @param name (String) Updated name of the pet (optional)
         */
         public UpdatePetWithFormOper nameForm(Object... name) {
            reqSpec.addFormParam("name", name);
            return this;
         }

         /**
         * @param status (String) Updated status of the pet (optional)
         */
         public UpdatePetWithFormOper statusForm(Object... status) {
            reqSpec.addFormParam("status", status);
            return this;
         }

        /**
         * Customise request specification
         */
        public UpdatePetWithFormOper reqSpec(Consumer<RequestSpecBuilder> consumer) {
            consumer.accept(reqSpec);
            return this;
        }

        /**
         * Customise response specification
         */
        public UpdatePetWithFormOper respSpec(Consumer<ResponseSpecBuilder> consumer) {
            consumer.accept(respSpec);
            return this;
        }
    }
    /**
     * uploads an image
     * 
     *
     * @see #petIdPath ID of pet to update (required)
     * @see #additionalMetadataForm Additional data to pass to server (optional)
     * @see #fileMultiPart file to upload (optional)
     * return ModelApiResponse
     */
    public class UploadFileOper {

        public static final String REQ_URI = "/pet/{petId}/uploadImage";

        private RequestSpecBuilder reqSpec;

        private ResponseSpecBuilder respSpec;

        public UploadFileOper() {
            this.reqSpec = new RequestSpecBuilder();
            reqSpec.setContentType("multipart/form-data");
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        public UploadFileOper(RequestSpecBuilder reqSpec) {
            this.reqSpec = reqSpec;
            reqSpec.setContentType("multipart/form-data");
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        /**
         * POST /pet/{petId}/uploadImage
         */
        public <T> T execute(Function<Response, T> handler) {
            return handler.apply(RestAssured.given().spec(reqSpec.build()).expect().spec(respSpec.build()).when().request(POST, REQ_URI));
        }

        /**
         * POST /pet/{petId}/uploadImage
         * @return ModelApiResponse
         */
        public ModelApiResponse executeAs(Function<Response, Response> handler) {
            Type type = new TypeToken<ModelApiResponse>(){}.getType();
            return execute(handler).as(type);
        }

        /**
         * @param petId (Long) ID of pet to update (required)
         */
        public UploadFileOper petIdPath(Object petId) {
            reqSpec.addPathParam("petId", petId);
            return this;
        }

         /**
         * @param additionalMetadata (String) Additional data to pass to server (optional)
         */
         public UploadFileOper additionalMetadataForm(Object... additionalMetadata) {
            reqSpec.addFormParam("additionalMetadata", additionalMetadata);
            return this;
         }

         /**
         * It will assume that the control name is file and the <content-type> is <application/octet-stream>
         * @see #reqSpec for customise
         * @param file (File) file to upload (optional)
         */
         public UploadFileOper fileMultiPart(File file) {
            reqSpec.addMultiPart(file);
            return this;
         }

        /**
         * Customise request specification
         */
        public UploadFileOper reqSpec(Consumer<RequestSpecBuilder> consumer) {
            consumer.accept(reqSpec);
            return this;
        }

        /**
         * Customise response specification
         */
        public UploadFileOper respSpec(Consumer<ResponseSpecBuilder> consumer) {
            consumer.accept(respSpec);
            return this;
        }
    }
}