{-
   Swagger Petstore

   This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\

   OpenAPI spec version: 2.0
   Swagger Petstore API version: 1.0.0
   Contact: apiteam@swagger.io
   Generated by Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
-}

{-|
Module : SwaggerPetstore.Model
-}

{-# LANGUAGE DeriveDataTypeable #-}
{-# LANGUAGE DeriveFoldable #-}
{-# LANGUAGE DeriveGeneric #-}
{-# LANGUAGE DeriveTraversable #-}
{-# LANGUAGE GeneralizedNewtypeDeriving #-}
{-# LANGUAGE LambdaCase #-}
{-# LANGUAGE MultiParamTypeClasses #-}
{-# LANGUAGE NamedFieldPuns #-}
{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE RecordWildCards #-}
{-# LANGUAGE TupleSections #-}
{-# LANGUAGE TypeFamilies #-}
{-# OPTIONS_GHC -fno-warn-unused-matches -fno-warn-unused-binds -fno-warn-unused-imports #-}

module SwaggerPetstore.Model where

import SwaggerPetstore.Core
import SwaggerPetstore.MimeTypes

import Data.Aeson ((.:),(.:!),(.:?),(.=))

import qualified Control.Arrow as P (left)
import qualified Data.Aeson as A
import qualified Data.ByteString as B
import qualified Data.ByteString.Base64 as B64
import qualified Data.ByteString.Char8 as BC
import qualified Data.ByteString.Lazy as BL
import qualified Data.Data as P (Typeable, TypeRep, typeOf, typeRep)
import qualified Data.Foldable as P
import qualified Data.HashMap.Lazy as HM
import qualified Data.Map as Map
import qualified Data.Maybe as P
import qualified Data.Set as Set
import qualified Data.Text as T
import qualified Data.Text.Encoding as T
import qualified Data.Time as TI
import qualified Lens.Micro as L
import qualified Web.FormUrlEncoded as WH
import qualified Web.HttpApiData as WH

import Control.Applicative ((<|>))
import Control.Applicative (Alternative)
import Data.Function ((&))
import Data.Monoid ((<>))
import Data.Text (Text)
import Prelude (($),(/=),(.),(<$>),(<*>),(>>=),(=<<),Maybe(..),Bool(..),Char,Double,FilePath,Float,Int,Integer,String,fmap,undefined,mempty,maybe,pure,Monad,Applicative,Functor)

import qualified Prelude as P



-- * Parameter newtypes


-- ** AdditionalMetadata
newtype AdditionalMetadata = AdditionalMetadata { unAdditionalMetadata :: Text } deriving (P.Eq, P.Show)

-- ** ApiKey
newtype ApiKey = ApiKey { unApiKey :: Text } deriving (P.Eq, P.Show)

-- ** Body
newtype Body = Body { unBody :: [User] } deriving (P.Eq, P.Show, A.ToJSON)

-- ** Byte
newtype Byte = Byte { unByte :: ByteArray } deriving (P.Eq, P.Show)

-- ** Callback
newtype Callback = Callback { unCallback :: Text } deriving (P.Eq, P.Show)

-- ** EnumFormString
newtype EnumFormString = EnumFormString { unEnumFormString :: E'EnumFormString } deriving (P.Eq, P.Show)

-- ** EnumFormStringArray
newtype EnumFormStringArray = EnumFormStringArray { unEnumFormStringArray :: [E'Inner2] } deriving (P.Eq, P.Show)

-- ** EnumHeaderString
newtype EnumHeaderString = EnumHeaderString { unEnumHeaderString :: E'EnumFormString } deriving (P.Eq, P.Show)

-- ** EnumHeaderStringArray
newtype EnumHeaderStringArray = EnumHeaderStringArray { unEnumHeaderStringArray :: [E'Inner2] } deriving (P.Eq, P.Show)

-- ** EnumQueryDouble
newtype EnumQueryDouble = EnumQueryDouble { unEnumQueryDouble :: E'EnumNumber } deriving (P.Eq, P.Show)

-- ** EnumQueryInteger
newtype EnumQueryInteger = EnumQueryInteger { unEnumQueryInteger :: E'EnumQueryInteger } deriving (P.Eq, P.Show)

-- ** EnumQueryString
newtype EnumQueryString = EnumQueryString { unEnumQueryString :: E'EnumFormString } deriving (P.Eq, P.Show)

-- ** EnumQueryStringArray
newtype EnumQueryStringArray = EnumQueryStringArray { unEnumQueryStringArray :: [E'Inner2] } deriving (P.Eq, P.Show)

-- ** File
newtype File = File { unFile :: FilePath } deriving (P.Eq, P.Show)

-- ** Int32
newtype Int32 = Int32 { unInt32 :: Int } deriving (P.Eq, P.Show)

-- ** Int64
newtype Int64 = Int64 { unInt64 :: Integer } deriving (P.Eq, P.Show)

-- ** Name2
newtype Name2 = Name2 { unName2 :: Text } deriving (P.Eq, P.Show)

-- ** Number
newtype Number = Number { unNumber :: Double } deriving (P.Eq, P.Show)

-- ** OrderId
newtype OrderId = OrderId { unOrderId :: Integer } deriving (P.Eq, P.Show)

-- ** OrderIdText
newtype OrderIdText = OrderIdText { unOrderIdText :: Text } deriving (P.Eq, P.Show)

-- ** Param
newtype Param = Param { unParam :: Text } deriving (P.Eq, P.Show)

-- ** Param2
newtype Param2 = Param2 { unParam2 :: Text } deriving (P.Eq, P.Show)

-- ** ParamBinary
newtype ParamBinary = ParamBinary { unParamBinary :: Binary } deriving (P.Eq, P.Show)

-- ** ParamDate
newtype ParamDate = ParamDate { unParamDate :: Date } deriving (P.Eq, P.Show)

-- ** ParamDateTime
newtype ParamDateTime = ParamDateTime { unParamDateTime :: DateTime } deriving (P.Eq, P.Show)

-- ** ParamDouble
newtype ParamDouble = ParamDouble { unParamDouble :: Double } deriving (P.Eq, P.Show)

-- ** ParamFloat
newtype ParamFloat = ParamFloat { unParamFloat :: Float } deriving (P.Eq, P.Show)

-- ** ParamInteger
newtype ParamInteger = ParamInteger { unParamInteger :: Int } deriving (P.Eq, P.Show)

-- ** ParamString
newtype ParamString = ParamString { unParamString :: Text } deriving (P.Eq, P.Show)

-- ** Password
newtype Password = Password { unPassword :: Text } deriving (P.Eq, P.Show)

-- ** PatternWithoutDelimiter
newtype PatternWithoutDelimiter = PatternWithoutDelimiter { unPatternWithoutDelimiter :: Text } deriving (P.Eq, P.Show)

-- ** PetId
newtype PetId = PetId { unPetId :: Integer } deriving (P.Eq, P.Show)

-- ** Query
newtype Query = Query { unQuery :: Text } deriving (P.Eq, P.Show)

-- ** Status
newtype Status = Status { unStatus :: [E'Status2] } deriving (P.Eq, P.Show)

-- ** StatusText
newtype StatusText = StatusText { unStatusText :: Text } deriving (P.Eq, P.Show)

-- ** Tags
newtype Tags = Tags { unTags :: [Text] } deriving (P.Eq, P.Show)

-- ** Username
newtype Username = Username { unUsername :: Text } deriving (P.Eq, P.Show)

-- * Models


-- ** AdditionalPropertiesClass
-- | AdditionalPropertiesClass
data AdditionalPropertiesClass = AdditionalPropertiesClass
  { additionalPropertiesClassMapProperty :: !(Maybe (Map.Map String Text)) -- ^ "map_property"
  , additionalPropertiesClassMapOfMapProperty :: !(Maybe (Map.Map String (Map.Map String Text))) -- ^ "map_of_map_property"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON AdditionalPropertiesClass
instance A.FromJSON AdditionalPropertiesClass where
  parseJSON = A.withObject "AdditionalPropertiesClass" $ \o ->
    AdditionalPropertiesClass
      <$> (o .:? "map_property")
      <*> (o .:? "map_of_map_property")

-- | ToJSON AdditionalPropertiesClass
instance A.ToJSON AdditionalPropertiesClass where
  toJSON AdditionalPropertiesClass {..} =
   _omitNulls
      [ "map_property" .= additionalPropertiesClassMapProperty
      , "map_of_map_property" .= additionalPropertiesClassMapOfMapProperty
      ]


-- | Construct a value of type 'AdditionalPropertiesClass' (by applying it's required fields, if any)
mkAdditionalPropertiesClass
  :: AdditionalPropertiesClass
mkAdditionalPropertiesClass =
  AdditionalPropertiesClass
  { additionalPropertiesClassMapProperty = Nothing
  , additionalPropertiesClassMapOfMapProperty = Nothing
  }

-- ** Animal
-- | Animal
data Animal = Animal
  { animalClassName :: !(Text) -- ^ /Required/ "className"
  , animalColor :: !(Maybe Text) -- ^ "color"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON Animal
instance A.FromJSON Animal where
  parseJSON = A.withObject "Animal" $ \o ->
    Animal
      <$> (o .:  "className")
      <*> (o .:? "color")

-- | ToJSON Animal
instance A.ToJSON Animal where
  toJSON Animal {..} =
   _omitNulls
      [ "className" .= animalClassName
      , "color" .= animalColor
      ]


-- | Construct a value of type 'Animal' (by applying it's required fields, if any)
mkAnimal
  :: Text -- ^ 'animalClassName' 
  -> Animal
mkAnimal animalClassName =
  Animal
  { animalClassName
  , animalColor = Nothing
  }

-- ** AnimalFarm
-- | AnimalFarm
data AnimalFarm = AnimalFarm
  { 
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON AnimalFarm
instance A.FromJSON AnimalFarm where
  parseJSON = A.withObject "AnimalFarm" $ \o ->
    pure AnimalFarm
      

-- | ToJSON AnimalFarm
instance A.ToJSON AnimalFarm where
  toJSON AnimalFarm  =
   _omitNulls
      [ 
      ]


-- | Construct a value of type 'AnimalFarm' (by applying it's required fields, if any)
mkAnimalFarm
  :: AnimalFarm
mkAnimalFarm =
  AnimalFarm
  { 
  }

-- ** ApiResponse
-- | ApiResponse
data ApiResponse = ApiResponse
  { apiResponseCode :: !(Maybe Int) -- ^ "code"
  , apiResponseType :: !(Maybe Text) -- ^ "type"
  , apiResponseMessage :: !(Maybe Text) -- ^ "message"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON ApiResponse
instance A.FromJSON ApiResponse where
  parseJSON = A.withObject "ApiResponse" $ \o ->
    ApiResponse
      <$> (o .:? "code")
      <*> (o .:? "type")
      <*> (o .:? "message")

-- | ToJSON ApiResponse
instance A.ToJSON ApiResponse where
  toJSON ApiResponse {..} =
   _omitNulls
      [ "code" .= apiResponseCode
      , "type" .= apiResponseType
      , "message" .= apiResponseMessage
      ]


-- | Construct a value of type 'ApiResponse' (by applying it's required fields, if any)
mkApiResponse
  :: ApiResponse
mkApiResponse =
  ApiResponse
  { apiResponseCode = Nothing
  , apiResponseType = Nothing
  , apiResponseMessage = Nothing
  }

-- ** ArrayOfArrayOfNumberOnly
-- | ArrayOfArrayOfNumberOnly
data ArrayOfArrayOfNumberOnly = ArrayOfArrayOfNumberOnly
  { arrayOfArrayOfNumberOnlyArrayArrayNumber :: !(Maybe [[Double]]) -- ^ "ArrayArrayNumber"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON ArrayOfArrayOfNumberOnly
instance A.FromJSON ArrayOfArrayOfNumberOnly where
  parseJSON = A.withObject "ArrayOfArrayOfNumberOnly" $ \o ->
    ArrayOfArrayOfNumberOnly
      <$> (o .:? "ArrayArrayNumber")

-- | ToJSON ArrayOfArrayOfNumberOnly
instance A.ToJSON ArrayOfArrayOfNumberOnly where
  toJSON ArrayOfArrayOfNumberOnly {..} =
   _omitNulls
      [ "ArrayArrayNumber" .= arrayOfArrayOfNumberOnlyArrayArrayNumber
      ]


-- | Construct a value of type 'ArrayOfArrayOfNumberOnly' (by applying it's required fields, if any)
mkArrayOfArrayOfNumberOnly
  :: ArrayOfArrayOfNumberOnly
mkArrayOfArrayOfNumberOnly =
  ArrayOfArrayOfNumberOnly
  { arrayOfArrayOfNumberOnlyArrayArrayNumber = Nothing
  }

-- ** ArrayOfNumberOnly
-- | ArrayOfNumberOnly
data ArrayOfNumberOnly = ArrayOfNumberOnly
  { arrayOfNumberOnlyArrayNumber :: !(Maybe [Double]) -- ^ "ArrayNumber"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON ArrayOfNumberOnly
instance A.FromJSON ArrayOfNumberOnly where
  parseJSON = A.withObject "ArrayOfNumberOnly" $ \o ->
    ArrayOfNumberOnly
      <$> (o .:? "ArrayNumber")

-- | ToJSON ArrayOfNumberOnly
instance A.ToJSON ArrayOfNumberOnly where
  toJSON ArrayOfNumberOnly {..} =
   _omitNulls
      [ "ArrayNumber" .= arrayOfNumberOnlyArrayNumber
      ]


-- | Construct a value of type 'ArrayOfNumberOnly' (by applying it's required fields, if any)
mkArrayOfNumberOnly
  :: ArrayOfNumberOnly
mkArrayOfNumberOnly =
  ArrayOfNumberOnly
  { arrayOfNumberOnlyArrayNumber = Nothing
  }

-- ** ArrayTest
-- | ArrayTest
data ArrayTest = ArrayTest
  { arrayTestArrayOfString :: !(Maybe [Text]) -- ^ "array_of_string"
  , arrayTestArrayArrayOfInteger :: !(Maybe [[Integer]]) -- ^ "array_array_of_integer"
  , arrayTestArrayArrayOfModel :: !(Maybe [[ReadOnlyFirst]]) -- ^ "array_array_of_model"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON ArrayTest
instance A.FromJSON ArrayTest where
  parseJSON = A.withObject "ArrayTest" $ \o ->
    ArrayTest
      <$> (o .:? "array_of_string")
      <*> (o .:? "array_array_of_integer")
      <*> (o .:? "array_array_of_model")

-- | ToJSON ArrayTest
instance A.ToJSON ArrayTest where
  toJSON ArrayTest {..} =
   _omitNulls
      [ "array_of_string" .= arrayTestArrayOfString
      , "array_array_of_integer" .= arrayTestArrayArrayOfInteger
      , "array_array_of_model" .= arrayTestArrayArrayOfModel
      ]


-- | Construct a value of type 'ArrayTest' (by applying it's required fields, if any)
mkArrayTest
  :: ArrayTest
mkArrayTest =
  ArrayTest
  { arrayTestArrayOfString = Nothing
  , arrayTestArrayArrayOfInteger = Nothing
  , arrayTestArrayArrayOfModel = Nothing
  }

-- ** Capitalization
-- | Capitalization
data Capitalization = Capitalization
  { capitalizationSmallCamel :: !(Maybe Text) -- ^ "smallCamel"
  , capitalizationCapitalCamel :: !(Maybe Text) -- ^ "CapitalCamel"
  , capitalizationSmallSnake :: !(Maybe Text) -- ^ "small_Snake"
  , capitalizationCapitalSnake :: !(Maybe Text) -- ^ "Capital_Snake"
  , capitalizationScaEthFlowPoints :: !(Maybe Text) -- ^ "SCA_ETH_Flow_Points"
  , capitalizationAttName :: !(Maybe Text) -- ^ "ATT_NAME" - Name of the pet 
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON Capitalization
instance A.FromJSON Capitalization where
  parseJSON = A.withObject "Capitalization" $ \o ->
    Capitalization
      <$> (o .:? "smallCamel")
      <*> (o .:? "CapitalCamel")
      <*> (o .:? "small_Snake")
      <*> (o .:? "Capital_Snake")
      <*> (o .:? "SCA_ETH_Flow_Points")
      <*> (o .:? "ATT_NAME")

-- | ToJSON Capitalization
instance A.ToJSON Capitalization where
  toJSON Capitalization {..} =
   _omitNulls
      [ "smallCamel" .= capitalizationSmallCamel
      , "CapitalCamel" .= capitalizationCapitalCamel
      , "small_Snake" .= capitalizationSmallSnake
      , "Capital_Snake" .= capitalizationCapitalSnake
      , "SCA_ETH_Flow_Points" .= capitalizationScaEthFlowPoints
      , "ATT_NAME" .= capitalizationAttName
      ]


-- | Construct a value of type 'Capitalization' (by applying it's required fields, if any)
mkCapitalization
  :: Capitalization
mkCapitalization =
  Capitalization
  { capitalizationSmallCamel = Nothing
  , capitalizationCapitalCamel = Nothing
  , capitalizationSmallSnake = Nothing
  , capitalizationCapitalSnake = Nothing
  , capitalizationScaEthFlowPoints = Nothing
  , capitalizationAttName = Nothing
  }

-- ** Category
-- | Category
data Category = Category
  { categoryId :: !(Maybe Integer) -- ^ "id"
  , categoryName :: !(Maybe Text) -- ^ "name"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON Category
instance A.FromJSON Category where
  parseJSON = A.withObject "Category" $ \o ->
    Category
      <$> (o .:? "id")
      <*> (o .:? "name")

-- | ToJSON Category
instance A.ToJSON Category where
  toJSON Category {..} =
   _omitNulls
      [ "id" .= categoryId
      , "name" .= categoryName
      ]


-- | Construct a value of type 'Category' (by applying it's required fields, if any)
mkCategory
  :: Category
mkCategory =
  Category
  { categoryId = Nothing
  , categoryName = Nothing
  }

-- ** ClassModel
-- | ClassModel
-- Model for testing model with \"_class\" property
data ClassModel = ClassModel
  { classModelClass :: !(Maybe Text) -- ^ "_class"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON ClassModel
instance A.FromJSON ClassModel where
  parseJSON = A.withObject "ClassModel" $ \o ->
    ClassModel
      <$> (o .:? "_class")

-- | ToJSON ClassModel
instance A.ToJSON ClassModel where
  toJSON ClassModel {..} =
   _omitNulls
      [ "_class" .= classModelClass
      ]


-- | Construct a value of type 'ClassModel' (by applying it's required fields, if any)
mkClassModel
  :: ClassModel
mkClassModel =
  ClassModel
  { classModelClass = Nothing
  }

-- ** Client
-- | Client
data Client = Client
  { clientClient :: !(Maybe Text) -- ^ "client"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON Client
instance A.FromJSON Client where
  parseJSON = A.withObject "Client" $ \o ->
    Client
      <$> (o .:? "client")

-- | ToJSON Client
instance A.ToJSON Client where
  toJSON Client {..} =
   _omitNulls
      [ "client" .= clientClient
      ]


-- | Construct a value of type 'Client' (by applying it's required fields, if any)
mkClient
  :: Client
mkClient =
  Client
  { clientClient = Nothing
  }

-- ** EnumArrays
-- | EnumArrays
data EnumArrays = EnumArrays
  { enumArraysJustSymbol :: !(Maybe E'JustSymbol) -- ^ "just_symbol"
  , enumArraysArrayEnum :: !(Maybe [E'ArrayEnum]) -- ^ "array_enum"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON EnumArrays
instance A.FromJSON EnumArrays where
  parseJSON = A.withObject "EnumArrays" $ \o ->
    EnumArrays
      <$> (o .:? "just_symbol")
      <*> (o .:? "array_enum")

-- | ToJSON EnumArrays
instance A.ToJSON EnumArrays where
  toJSON EnumArrays {..} =
   _omitNulls
      [ "just_symbol" .= enumArraysJustSymbol
      , "array_enum" .= enumArraysArrayEnum
      ]


-- | Construct a value of type 'EnumArrays' (by applying it's required fields, if any)
mkEnumArrays
  :: EnumArrays
mkEnumArrays =
  EnumArrays
  { enumArraysJustSymbol = Nothing
  , enumArraysArrayEnum = Nothing
  }

-- ** EnumTest
-- | EnumTest
data EnumTest = EnumTest
  { enumTestEnumString :: !(Maybe E'EnumString) -- ^ "enum_string"
  , enumTestEnumStringRequired :: !(E'EnumString) -- ^ /Required/ "enum_string_required"
  , enumTestEnumInteger :: !(Maybe E'EnumInteger) -- ^ "enum_integer"
  , enumTestEnumNumber :: !(Maybe E'EnumNumber) -- ^ "enum_number"
  , enumTestOuterEnum :: !(Maybe OuterEnum) -- ^ "outerEnum"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON EnumTest
instance A.FromJSON EnumTest where
  parseJSON = A.withObject "EnumTest" $ \o ->
    EnumTest
      <$> (o .:? "enum_string")
      <*> (o .:  "enum_string_required")
      <*> (o .:? "enum_integer")
      <*> (o .:? "enum_number")
      <*> (o .:? "outerEnum")

-- | ToJSON EnumTest
instance A.ToJSON EnumTest where
  toJSON EnumTest {..} =
   _omitNulls
      [ "enum_string" .= enumTestEnumString
      , "enum_string_required" .= enumTestEnumStringRequired
      , "enum_integer" .= enumTestEnumInteger
      , "enum_number" .= enumTestEnumNumber
      , "outerEnum" .= enumTestOuterEnum
      ]


-- | Construct a value of type 'EnumTest' (by applying it's required fields, if any)
mkEnumTest
  :: E'EnumString -- ^ 'enumTestEnumStringRequired' 
  -> EnumTest
mkEnumTest enumTestEnumStringRequired =
  EnumTest
  { enumTestEnumString = Nothing
  , enumTestEnumStringRequired
  , enumTestEnumInteger = Nothing
  , enumTestEnumNumber = Nothing
  , enumTestOuterEnum = Nothing
  }

-- ** FormatTest
-- | FormatTest
data FormatTest = FormatTest
  { formatTestInteger :: !(Maybe Int) -- ^ "integer"
  , formatTestInt32 :: !(Maybe Int) -- ^ "int32"
  , formatTestInt64 :: !(Maybe Integer) -- ^ "int64"
  , formatTestNumber :: !(Double) -- ^ /Required/ "number"
  , formatTestFloat :: !(Maybe Float) -- ^ "float"
  , formatTestDouble :: !(Maybe Double) -- ^ "double"
  , formatTestString :: !(Maybe Text) -- ^ "string"
  , formatTestByte :: !(ByteArray) -- ^ /Required/ "byte"
  , formatTestBinary :: !(Maybe Binary) -- ^ "binary"
  , formatTestDate :: !(Date) -- ^ /Required/ "date"
  , formatTestDateTime :: !(Maybe DateTime) -- ^ "dateTime"
  , formatTestUuid :: !(Maybe Text) -- ^ "uuid"
  , formatTestPassword :: !(Text) -- ^ /Required/ "password"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON FormatTest
instance A.FromJSON FormatTest where
  parseJSON = A.withObject "FormatTest" $ \o ->
    FormatTest
      <$> (o .:? "integer")
      <*> (o .:? "int32")
      <*> (o .:? "int64")
      <*> (o .:  "number")
      <*> (o .:? "float")
      <*> (o .:? "double")
      <*> (o .:? "string")
      <*> (o .:  "byte")
      <*> (o .:? "binary")
      <*> (o .:  "date")
      <*> (o .:? "dateTime")
      <*> (o .:? "uuid")
      <*> (o .:  "password")

-- | ToJSON FormatTest
instance A.ToJSON FormatTest where
  toJSON FormatTest {..} =
   _omitNulls
      [ "integer" .= formatTestInteger
      , "int32" .= formatTestInt32
      , "int64" .= formatTestInt64
      , "number" .= formatTestNumber
      , "float" .= formatTestFloat
      , "double" .= formatTestDouble
      , "string" .= formatTestString
      , "byte" .= formatTestByte
      , "binary" .= formatTestBinary
      , "date" .= formatTestDate
      , "dateTime" .= formatTestDateTime
      , "uuid" .= formatTestUuid
      , "password" .= formatTestPassword
      ]


-- | Construct a value of type 'FormatTest' (by applying it's required fields, if any)
mkFormatTest
  :: Double -- ^ 'formatTestNumber' 
  -> ByteArray -- ^ 'formatTestByte' 
  -> Date -- ^ 'formatTestDate' 
  -> Text -- ^ 'formatTestPassword' 
  -> FormatTest
mkFormatTest formatTestNumber formatTestByte formatTestDate formatTestPassword =
  FormatTest
  { formatTestInteger = Nothing
  , formatTestInt32 = Nothing
  , formatTestInt64 = Nothing
  , formatTestNumber
  , formatTestFloat = Nothing
  , formatTestDouble = Nothing
  , formatTestString = Nothing
  , formatTestByte
  , formatTestBinary = Nothing
  , formatTestDate
  , formatTestDateTime = Nothing
  , formatTestUuid = Nothing
  , formatTestPassword
  }

-- ** HasOnlyReadOnly
-- | HasOnlyReadOnly
data HasOnlyReadOnly = HasOnlyReadOnly
  { hasOnlyReadOnlyBar :: !(Maybe Text) -- ^ "bar"
  , hasOnlyReadOnlyFoo :: !(Maybe Text) -- ^ "foo"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON HasOnlyReadOnly
instance A.FromJSON HasOnlyReadOnly where
  parseJSON = A.withObject "HasOnlyReadOnly" $ \o ->
    HasOnlyReadOnly
      <$> (o .:? "bar")
      <*> (o .:? "foo")

-- | ToJSON HasOnlyReadOnly
instance A.ToJSON HasOnlyReadOnly where
  toJSON HasOnlyReadOnly {..} =
   _omitNulls
      [ "bar" .= hasOnlyReadOnlyBar
      , "foo" .= hasOnlyReadOnlyFoo
      ]


-- | Construct a value of type 'HasOnlyReadOnly' (by applying it's required fields, if any)
mkHasOnlyReadOnly
  :: HasOnlyReadOnly
mkHasOnlyReadOnly =
  HasOnlyReadOnly
  { hasOnlyReadOnlyBar = Nothing
  , hasOnlyReadOnlyFoo = Nothing
  }

-- ** MapTest
-- | MapTest
data MapTest = MapTest
  { mapTestMapMapOfString :: !(Maybe (Map.Map String (Map.Map String Text))) -- ^ "map_map_of_string"
  , mapTestMapOfEnumString :: !(Maybe (Map.Map String E'Inner)) -- ^ "map_of_enum_string"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON MapTest
instance A.FromJSON MapTest where
  parseJSON = A.withObject "MapTest" $ \o ->
    MapTest
      <$> (o .:? "map_map_of_string")
      <*> (o .:? "map_of_enum_string")

-- | ToJSON MapTest
instance A.ToJSON MapTest where
  toJSON MapTest {..} =
   _omitNulls
      [ "map_map_of_string" .= mapTestMapMapOfString
      , "map_of_enum_string" .= mapTestMapOfEnumString
      ]


-- | Construct a value of type 'MapTest' (by applying it's required fields, if any)
mkMapTest
  :: MapTest
mkMapTest =
  MapTest
  { mapTestMapMapOfString = Nothing
  , mapTestMapOfEnumString = Nothing
  }

-- ** MixedPropertiesAndAdditionalPropertiesClass
-- | MixedPropertiesAndAdditionalPropertiesClass
data MixedPropertiesAndAdditionalPropertiesClass = MixedPropertiesAndAdditionalPropertiesClass
  { mixedPropertiesAndAdditionalPropertiesClassUuid :: !(Maybe Text) -- ^ "uuid"
  , mixedPropertiesAndAdditionalPropertiesClassDateTime :: !(Maybe DateTime) -- ^ "dateTime"
  , mixedPropertiesAndAdditionalPropertiesClassMap :: !(Maybe (Map.Map String Animal)) -- ^ "map"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON MixedPropertiesAndAdditionalPropertiesClass
instance A.FromJSON MixedPropertiesAndAdditionalPropertiesClass where
  parseJSON = A.withObject "MixedPropertiesAndAdditionalPropertiesClass" $ \o ->
    MixedPropertiesAndAdditionalPropertiesClass
      <$> (o .:? "uuid")
      <*> (o .:? "dateTime")
      <*> (o .:? "map")

-- | ToJSON MixedPropertiesAndAdditionalPropertiesClass
instance A.ToJSON MixedPropertiesAndAdditionalPropertiesClass where
  toJSON MixedPropertiesAndAdditionalPropertiesClass {..} =
   _omitNulls
      [ "uuid" .= mixedPropertiesAndAdditionalPropertiesClassUuid
      , "dateTime" .= mixedPropertiesAndAdditionalPropertiesClassDateTime
      , "map" .= mixedPropertiesAndAdditionalPropertiesClassMap
      ]


-- | Construct a value of type 'MixedPropertiesAndAdditionalPropertiesClass' (by applying it's required fields, if any)
mkMixedPropertiesAndAdditionalPropertiesClass
  :: MixedPropertiesAndAdditionalPropertiesClass
mkMixedPropertiesAndAdditionalPropertiesClass =
  MixedPropertiesAndAdditionalPropertiesClass
  { mixedPropertiesAndAdditionalPropertiesClassUuid = Nothing
  , mixedPropertiesAndAdditionalPropertiesClassDateTime = Nothing
  , mixedPropertiesAndAdditionalPropertiesClassMap = Nothing
  }

-- ** Model200Response
-- | Model200Response
-- Model for testing model name starting with number
data Model200Response = Model200Response
  { model200ResponseName :: !(Maybe Int) -- ^ "name"
  , model200ResponseClass :: !(Maybe Text) -- ^ "class"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON Model200Response
instance A.FromJSON Model200Response where
  parseJSON = A.withObject "Model200Response" $ \o ->
    Model200Response
      <$> (o .:? "name")
      <*> (o .:? "class")

-- | ToJSON Model200Response
instance A.ToJSON Model200Response where
  toJSON Model200Response {..} =
   _omitNulls
      [ "name" .= model200ResponseName
      , "class" .= model200ResponseClass
      ]


-- | Construct a value of type 'Model200Response' (by applying it's required fields, if any)
mkModel200Response
  :: Model200Response
mkModel200Response =
  Model200Response
  { model200ResponseName = Nothing
  , model200ResponseClass = Nothing
  }

-- ** ModelList
-- | ModelList
data ModelList = ModelList
  { modelList123List :: !(Maybe Text) -- ^ "123-list"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON ModelList
instance A.FromJSON ModelList where
  parseJSON = A.withObject "ModelList" $ \o ->
    ModelList
      <$> (o .:? "123-list")

-- | ToJSON ModelList
instance A.ToJSON ModelList where
  toJSON ModelList {..} =
   _omitNulls
      [ "123-list" .= modelList123List
      ]


-- | Construct a value of type 'ModelList' (by applying it's required fields, if any)
mkModelList
  :: ModelList
mkModelList =
  ModelList
  { modelList123List = Nothing
  }

-- ** ModelReturn
-- | ModelReturn
-- Model for testing reserved words
data ModelReturn = ModelReturn
  { modelReturnReturn :: !(Maybe Int) -- ^ "return"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON ModelReturn
instance A.FromJSON ModelReturn where
  parseJSON = A.withObject "ModelReturn" $ \o ->
    ModelReturn
      <$> (o .:? "return")

-- | ToJSON ModelReturn
instance A.ToJSON ModelReturn where
  toJSON ModelReturn {..} =
   _omitNulls
      [ "return" .= modelReturnReturn
      ]


-- | Construct a value of type 'ModelReturn' (by applying it's required fields, if any)
mkModelReturn
  :: ModelReturn
mkModelReturn =
  ModelReturn
  { modelReturnReturn = Nothing
  }

-- ** Name
-- | Name
-- Model for testing model name same as property name
data Name = Name
  { nameName :: !(Int) -- ^ /Required/ "name"
  , nameSnakeCase :: !(Maybe Int) -- ^ "snake_case"
  , nameProperty :: !(Maybe Text) -- ^ "property"
  , name123Number :: !(Maybe Int) -- ^ "123Number"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON Name
instance A.FromJSON Name where
  parseJSON = A.withObject "Name" $ \o ->
    Name
      <$> (o .:  "name")
      <*> (o .:? "snake_case")
      <*> (o .:? "property")
      <*> (o .:? "123Number")

-- | ToJSON Name
instance A.ToJSON Name where
  toJSON Name {..} =
   _omitNulls
      [ "name" .= nameName
      , "snake_case" .= nameSnakeCase
      , "property" .= nameProperty
      , "123Number" .= name123Number
      ]


-- | Construct a value of type 'Name' (by applying it's required fields, if any)
mkName
  :: Int -- ^ 'nameName' 
  -> Name
mkName nameName =
  Name
  { nameName
  , nameSnakeCase = Nothing
  , nameProperty = Nothing
  , name123Number = Nothing
  }

-- ** NumberOnly
-- | NumberOnly
data NumberOnly = NumberOnly
  { numberOnlyJustNumber :: !(Maybe Double) -- ^ "JustNumber"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON NumberOnly
instance A.FromJSON NumberOnly where
  parseJSON = A.withObject "NumberOnly" $ \o ->
    NumberOnly
      <$> (o .:? "JustNumber")

-- | ToJSON NumberOnly
instance A.ToJSON NumberOnly where
  toJSON NumberOnly {..} =
   _omitNulls
      [ "JustNumber" .= numberOnlyJustNumber
      ]


-- | Construct a value of type 'NumberOnly' (by applying it's required fields, if any)
mkNumberOnly
  :: NumberOnly
mkNumberOnly =
  NumberOnly
  { numberOnlyJustNumber = Nothing
  }

-- ** Order
-- | Order
data Order = Order
  { orderId :: !(Maybe Integer) -- ^ "id"
  , orderPetId :: !(Maybe Integer) -- ^ "petId"
  , orderQuantity :: !(Maybe Int) -- ^ "quantity"
  , orderShipDate :: !(Maybe DateTime) -- ^ "shipDate"
  , orderStatus :: !(Maybe E'Status) -- ^ "status" - Order Status
  , orderComplete :: !(Maybe Bool) -- ^ "complete"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON Order
instance A.FromJSON Order where
  parseJSON = A.withObject "Order" $ \o ->
    Order
      <$> (o .:? "id")
      <*> (o .:? "petId")
      <*> (o .:? "quantity")
      <*> (o .:? "shipDate")
      <*> (o .:? "status")
      <*> (o .:? "complete")

-- | ToJSON Order
instance A.ToJSON Order where
  toJSON Order {..} =
   _omitNulls
      [ "id" .= orderId
      , "petId" .= orderPetId
      , "quantity" .= orderQuantity
      , "shipDate" .= orderShipDate
      , "status" .= orderStatus
      , "complete" .= orderComplete
      ]


-- | Construct a value of type 'Order' (by applying it's required fields, if any)
mkOrder
  :: Order
mkOrder =
  Order
  { orderId = Nothing
  , orderPetId = Nothing
  , orderQuantity = Nothing
  , orderShipDate = Nothing
  , orderStatus = Nothing
  , orderComplete = Nothing
  }

-- ** OuterBoolean
-- | OuterBoolean
newtype OuterBoolean = OuterBoolean
  { unOuterBoolean :: Bool
  } deriving (P.Eq, P.Show, P.Typeable, A.ToJSON, A.FromJSON, WH.ToHttpApiData, WH.FromHttpApiData)


-- ** OuterComposite
-- | OuterComposite
data OuterComposite = OuterComposite
  { outerCompositeMyNumber :: !(Maybe OuterNumber) -- ^ "my_number"
  , outerCompositeMyString :: !(Maybe OuterString) -- ^ "my_string"
  , outerCompositeMyBoolean :: !(Maybe OuterBoolean) -- ^ "my_boolean"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON OuterComposite
instance A.FromJSON OuterComposite where
  parseJSON = A.withObject "OuterComposite" $ \o ->
    OuterComposite
      <$> (o .:? "my_number")
      <*> (o .:? "my_string")
      <*> (o .:? "my_boolean")

-- | ToJSON OuterComposite
instance A.ToJSON OuterComposite where
  toJSON OuterComposite {..} =
   _omitNulls
      [ "my_number" .= outerCompositeMyNumber
      , "my_string" .= outerCompositeMyString
      , "my_boolean" .= outerCompositeMyBoolean
      ]


-- | Construct a value of type 'OuterComposite' (by applying it's required fields, if any)
mkOuterComposite
  :: OuterComposite
mkOuterComposite =
  OuterComposite
  { outerCompositeMyNumber = Nothing
  , outerCompositeMyString = Nothing
  , outerCompositeMyBoolean = Nothing
  }

-- ** OuterNumber
-- | OuterNumber
newtype OuterNumber = OuterNumber
  { unOuterNumber :: Double
  } deriving (P.Eq, P.Show, P.Typeable, A.ToJSON, A.FromJSON, WH.ToHttpApiData, WH.FromHttpApiData)


-- ** OuterString
-- | OuterString
newtype OuterString = OuterString
  { unOuterString :: Text
  } deriving (P.Eq, P.Show, P.Typeable, A.ToJSON, A.FromJSON, WH.ToHttpApiData, WH.FromHttpApiData)


-- ** Pet
-- | Pet
data Pet = Pet
  { petId :: !(Maybe Integer) -- ^ "id"
  , petCategory :: !(Maybe Category) -- ^ "category"
  , petName :: !(Text) -- ^ /Required/ "name"
  , petPhotoUrls :: !([Text]) -- ^ /Required/ "photoUrls"
  , petTags :: !(Maybe [Tag]) -- ^ "tags"
  , petStatus :: !(Maybe E'Status2) -- ^ "status" - pet status in the store
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON Pet
instance A.FromJSON Pet where
  parseJSON = A.withObject "Pet" $ \o ->
    Pet
      <$> (o .:? "id")
      <*> (o .:? "category")
      <*> (o .:  "name")
      <*> (o .:  "photoUrls")
      <*> (o .:? "tags")
      <*> (o .:? "status")

-- | ToJSON Pet
instance A.ToJSON Pet where
  toJSON Pet {..} =
   _omitNulls
      [ "id" .= petId
      , "category" .= petCategory
      , "name" .= petName
      , "photoUrls" .= petPhotoUrls
      , "tags" .= petTags
      , "status" .= petStatus
      ]


-- | Construct a value of type 'Pet' (by applying it's required fields, if any)
mkPet
  :: Text -- ^ 'petName' 
  -> [Text] -- ^ 'petPhotoUrls' 
  -> Pet
mkPet petName petPhotoUrls =
  Pet
  { petId = Nothing
  , petCategory = Nothing
  , petName
  , petPhotoUrls
  , petTags = Nothing
  , petStatus = Nothing
  }

-- ** ReadOnlyFirst
-- | ReadOnlyFirst
data ReadOnlyFirst = ReadOnlyFirst
  { readOnlyFirstBar :: !(Maybe Text) -- ^ "bar"
  , readOnlyFirstBaz :: !(Maybe Text) -- ^ "baz"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON ReadOnlyFirst
instance A.FromJSON ReadOnlyFirst where
  parseJSON = A.withObject "ReadOnlyFirst" $ \o ->
    ReadOnlyFirst
      <$> (o .:? "bar")
      <*> (o .:? "baz")

-- | ToJSON ReadOnlyFirst
instance A.ToJSON ReadOnlyFirst where
  toJSON ReadOnlyFirst {..} =
   _omitNulls
      [ "bar" .= readOnlyFirstBar
      , "baz" .= readOnlyFirstBaz
      ]


-- | Construct a value of type 'ReadOnlyFirst' (by applying it's required fields, if any)
mkReadOnlyFirst
  :: ReadOnlyFirst
mkReadOnlyFirst =
  ReadOnlyFirst
  { readOnlyFirstBar = Nothing
  , readOnlyFirstBaz = Nothing
  }

-- ** SpecialModelName
-- | SpecialModelName
data SpecialModelName = SpecialModelName
  { specialModelNameSpecialPropertyName :: !(Maybe Integer) -- ^ "$special[property.name]"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON SpecialModelName
instance A.FromJSON SpecialModelName where
  parseJSON = A.withObject "SpecialModelName" $ \o ->
    SpecialModelName
      <$> (o .:? "$special[property.name]")

-- | ToJSON SpecialModelName
instance A.ToJSON SpecialModelName where
  toJSON SpecialModelName {..} =
   _omitNulls
      [ "$special[property.name]" .= specialModelNameSpecialPropertyName
      ]


-- | Construct a value of type 'SpecialModelName' (by applying it's required fields, if any)
mkSpecialModelName
  :: SpecialModelName
mkSpecialModelName =
  SpecialModelName
  { specialModelNameSpecialPropertyName = Nothing
  }

-- ** Tag
-- | Tag
data Tag = Tag
  { tagId :: !(Maybe Integer) -- ^ "id"
  , tagName :: !(Maybe Text) -- ^ "name"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON Tag
instance A.FromJSON Tag where
  parseJSON = A.withObject "Tag" $ \o ->
    Tag
      <$> (o .:? "id")
      <*> (o .:? "name")

-- | ToJSON Tag
instance A.ToJSON Tag where
  toJSON Tag {..} =
   _omitNulls
      [ "id" .= tagId
      , "name" .= tagName
      ]


-- | Construct a value of type 'Tag' (by applying it's required fields, if any)
mkTag
  :: Tag
mkTag =
  Tag
  { tagId = Nothing
  , tagName = Nothing
  }

-- ** User
-- | User
data User = User
  { userId :: !(Maybe Integer) -- ^ "id"
  , userUsername :: !(Maybe Text) -- ^ "username"
  , userFirstName :: !(Maybe Text) -- ^ "firstName"
  , userLastName :: !(Maybe Text) -- ^ "lastName"
  , userEmail :: !(Maybe Text) -- ^ "email"
  , userPassword :: !(Maybe Text) -- ^ "password"
  , userPhone :: !(Maybe Text) -- ^ "phone"
  , userUserStatus :: !(Maybe Int) -- ^ "userStatus" - User Status
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON User
instance A.FromJSON User where
  parseJSON = A.withObject "User" $ \o ->
    User
      <$> (o .:? "id")
      <*> (o .:? "username")
      <*> (o .:? "firstName")
      <*> (o .:? "lastName")
      <*> (o .:? "email")
      <*> (o .:? "password")
      <*> (o .:? "phone")
      <*> (o .:? "userStatus")

-- | ToJSON User
instance A.ToJSON User where
  toJSON User {..} =
   _omitNulls
      [ "id" .= userId
      , "username" .= userUsername
      , "firstName" .= userFirstName
      , "lastName" .= userLastName
      , "email" .= userEmail
      , "password" .= userPassword
      , "phone" .= userPhone
      , "userStatus" .= userUserStatus
      ]


-- | Construct a value of type 'User' (by applying it's required fields, if any)
mkUser
  :: User
mkUser =
  User
  { userId = Nothing
  , userUsername = Nothing
  , userFirstName = Nothing
  , userLastName = Nothing
  , userEmail = Nothing
  , userPassword = Nothing
  , userPhone = Nothing
  , userUserStatus = Nothing
  }

-- ** Cat
-- | Cat
data Cat = Cat
  { catClassName :: !(Text) -- ^ /Required/ "className"
  , catColor :: !(Maybe Text) -- ^ "color"
  , catDeclawed :: !(Maybe Bool) -- ^ "declawed"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON Cat
instance A.FromJSON Cat where
  parseJSON = A.withObject "Cat" $ \o ->
    Cat
      <$> (o .:  "className")
      <*> (o .:? "color")
      <*> (o .:? "declawed")

-- | ToJSON Cat
instance A.ToJSON Cat where
  toJSON Cat {..} =
   _omitNulls
      [ "className" .= catClassName
      , "color" .= catColor
      , "declawed" .= catDeclawed
      ]


-- | Construct a value of type 'Cat' (by applying it's required fields, if any)
mkCat
  :: Text -- ^ 'catClassName' 
  -> Cat
mkCat catClassName =
  Cat
  { catClassName
  , catColor = Nothing
  , catDeclawed = Nothing
  }

-- ** Dog
-- | Dog
data Dog = Dog
  { dogClassName :: !(Text) -- ^ /Required/ "className"
  , dogColor :: !(Maybe Text) -- ^ "color"
  , dogBreed :: !(Maybe Text) -- ^ "breed"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON Dog
instance A.FromJSON Dog where
  parseJSON = A.withObject "Dog" $ \o ->
    Dog
      <$> (o .:  "className")
      <*> (o .:? "color")
      <*> (o .:? "breed")

-- | ToJSON Dog
instance A.ToJSON Dog where
  toJSON Dog {..} =
   _omitNulls
      [ "className" .= dogClassName
      , "color" .= dogColor
      , "breed" .= dogBreed
      ]


-- | Construct a value of type 'Dog' (by applying it's required fields, if any)
mkDog
  :: Text -- ^ 'dogClassName' 
  -> Dog
mkDog dogClassName =
  Dog
  { dogClassName
  , dogColor = Nothing
  , dogBreed = Nothing
  }


-- * Enums


-- ** E'ArrayEnum

-- | Enum of 'Text'
data E'ArrayEnum
  = E'ArrayEnum'Fish -- ^ @"fish"@
  | E'ArrayEnum'Crab -- ^ @"crab"@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'ArrayEnum where toJSON = A.toJSON . fromE'ArrayEnum
instance A.FromJSON E'ArrayEnum where parseJSON o = P.either P.fail (pure . P.id) . toE'ArrayEnum =<< A.parseJSON o
instance WH.ToHttpApiData E'ArrayEnum where toQueryParam = WH.toQueryParam . fromE'ArrayEnum
instance WH.FromHttpApiData E'ArrayEnum where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'ArrayEnum
instance MimeRender MimeMultipartFormData E'ArrayEnum where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'ArrayEnum' enum
fromE'ArrayEnum :: E'ArrayEnum -> Text
fromE'ArrayEnum = \case
  E'ArrayEnum'Fish -> "fish"
  E'ArrayEnum'Crab -> "crab"

-- | parse 'E'ArrayEnum' enum
toE'ArrayEnum :: Text -> P.Either String E'ArrayEnum
toE'ArrayEnum = \case
  "fish" -> P.Right E'ArrayEnum'Fish
  "crab" -> P.Right E'ArrayEnum'Crab
  s -> P.Left $ "toE'ArrayEnum: enum parse failure: " P.++ P.show s


-- ** E'EnumFormString

-- | Enum of 'Text'
data E'EnumFormString
  = E'EnumFormString'_abc -- ^ @"_abc"@
  | E'EnumFormString'_efg -- ^ @"-efg"@
  | E'EnumFormString'_xyz -- ^ @"(xyz)"@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'EnumFormString where toJSON = A.toJSON . fromE'EnumFormString
instance A.FromJSON E'EnumFormString where parseJSON o = P.either P.fail (pure . P.id) . toE'EnumFormString =<< A.parseJSON o
instance WH.ToHttpApiData E'EnumFormString where toQueryParam = WH.toQueryParam . fromE'EnumFormString
instance WH.FromHttpApiData E'EnumFormString where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'EnumFormString
instance MimeRender MimeMultipartFormData E'EnumFormString where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'EnumFormString' enum
fromE'EnumFormString :: E'EnumFormString -> Text
fromE'EnumFormString = \case
  E'EnumFormString'_abc -> "_abc"
  E'EnumFormString'_efg -> "-efg"
  E'EnumFormString'_xyz -> "(xyz)"

-- | parse 'E'EnumFormString' enum
toE'EnumFormString :: Text -> P.Either String E'EnumFormString
toE'EnumFormString = \case
  "_abc" -> P.Right E'EnumFormString'_abc
  "-efg" -> P.Right E'EnumFormString'_efg
  "(xyz)" -> P.Right E'EnumFormString'_xyz
  s -> P.Left $ "toE'EnumFormString: enum parse failure: " P.++ P.show s


-- ** E'EnumInteger

-- | Enum of 'Int'
data E'EnumInteger
  = E'EnumInteger'Num1 -- ^ @1@
  | E'EnumInteger'NumMinus_1 -- ^ @-1@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'EnumInteger where toJSON = A.toJSON . fromE'EnumInteger
instance A.FromJSON E'EnumInteger where parseJSON o = P.either P.fail (pure . P.id) . toE'EnumInteger =<< A.parseJSON o
instance WH.ToHttpApiData E'EnumInteger where toQueryParam = WH.toQueryParam . fromE'EnumInteger
instance WH.FromHttpApiData E'EnumInteger where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'EnumInteger
instance MimeRender MimeMultipartFormData E'EnumInteger where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'EnumInteger' enum
fromE'EnumInteger :: E'EnumInteger -> Int
fromE'EnumInteger = \case
  E'EnumInteger'Num1 -> 1
  E'EnumInteger'NumMinus_1 -> -1

-- | parse 'E'EnumInteger' enum
toE'EnumInteger :: Int -> P.Either String E'EnumInteger
toE'EnumInteger = \case
  1 -> P.Right E'EnumInteger'Num1
  -1 -> P.Right E'EnumInteger'NumMinus_1
  s -> P.Left $ "toE'EnumInteger: enum parse failure: " P.++ P.show s


-- ** E'EnumNumber

-- | Enum of 'Double'
data E'EnumNumber
  = E'EnumNumber'Num1_Dot_1 -- ^ @1.1@
  | E'EnumNumber'NumMinus_1_Dot_2 -- ^ @-1.2@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'EnumNumber where toJSON = A.toJSON . fromE'EnumNumber
instance A.FromJSON E'EnumNumber where parseJSON o = P.either P.fail (pure . P.id) . toE'EnumNumber =<< A.parseJSON o
instance WH.ToHttpApiData E'EnumNumber where toQueryParam = WH.toQueryParam . fromE'EnumNumber
instance WH.FromHttpApiData E'EnumNumber where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'EnumNumber
instance MimeRender MimeMultipartFormData E'EnumNumber where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'EnumNumber' enum
fromE'EnumNumber :: E'EnumNumber -> Double
fromE'EnumNumber = \case
  E'EnumNumber'Num1_Dot_1 -> 1.1
  E'EnumNumber'NumMinus_1_Dot_2 -> -1.2

-- | parse 'E'EnumNumber' enum
toE'EnumNumber :: Double -> P.Either String E'EnumNumber
toE'EnumNumber = \case
  1.1 -> P.Right E'EnumNumber'Num1_Dot_1
  -1.2 -> P.Right E'EnumNumber'NumMinus_1_Dot_2
  s -> P.Left $ "toE'EnumNumber: enum parse failure: " P.++ P.show s


-- ** E'EnumQueryInteger

-- | Enum of 'Int'
data E'EnumQueryInteger
  = E'EnumQueryInteger'Num1 -- ^ @1@
  | E'EnumQueryInteger'NumMinus_2 -- ^ @-2@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'EnumQueryInteger where toJSON = A.toJSON . fromE'EnumQueryInteger
instance A.FromJSON E'EnumQueryInteger where parseJSON o = P.either P.fail (pure . P.id) . toE'EnumQueryInteger =<< A.parseJSON o
instance WH.ToHttpApiData E'EnumQueryInteger where toQueryParam = WH.toQueryParam . fromE'EnumQueryInteger
instance WH.FromHttpApiData E'EnumQueryInteger where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'EnumQueryInteger
instance MimeRender MimeMultipartFormData E'EnumQueryInteger where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'EnumQueryInteger' enum
fromE'EnumQueryInteger :: E'EnumQueryInteger -> Int
fromE'EnumQueryInteger = \case
  E'EnumQueryInteger'Num1 -> 1
  E'EnumQueryInteger'NumMinus_2 -> -2

-- | parse 'E'EnumQueryInteger' enum
toE'EnumQueryInteger :: Int -> P.Either String E'EnumQueryInteger
toE'EnumQueryInteger = \case
  1 -> P.Right E'EnumQueryInteger'Num1
  -2 -> P.Right E'EnumQueryInteger'NumMinus_2
  s -> P.Left $ "toE'EnumQueryInteger: enum parse failure: " P.++ P.show s


-- ** E'EnumString

-- | Enum of 'Text'
data E'EnumString
  = E'EnumString'UPPER -- ^ @"UPPER"@
  | E'EnumString'Lower -- ^ @"lower"@
  | E'EnumString'Empty -- ^ @""@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'EnumString where toJSON = A.toJSON . fromE'EnumString
instance A.FromJSON E'EnumString where parseJSON o = P.either P.fail (pure . P.id) . toE'EnumString =<< A.parseJSON o
instance WH.ToHttpApiData E'EnumString where toQueryParam = WH.toQueryParam . fromE'EnumString
instance WH.FromHttpApiData E'EnumString where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'EnumString
instance MimeRender MimeMultipartFormData E'EnumString where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'EnumString' enum
fromE'EnumString :: E'EnumString -> Text
fromE'EnumString = \case
  E'EnumString'UPPER -> "UPPER"
  E'EnumString'Lower -> "lower"
  E'EnumString'Empty -> ""

-- | parse 'E'EnumString' enum
toE'EnumString :: Text -> P.Either String E'EnumString
toE'EnumString = \case
  "UPPER" -> P.Right E'EnumString'UPPER
  "lower" -> P.Right E'EnumString'Lower
  "" -> P.Right E'EnumString'Empty
  s -> P.Left $ "toE'EnumString: enum parse failure: " P.++ P.show s


-- ** E'Inner

-- | Enum of 'Text'
data E'Inner
  = E'Inner'UPPER -- ^ @"UPPER"@
  | E'Inner'Lower -- ^ @"lower"@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'Inner where toJSON = A.toJSON . fromE'Inner
instance A.FromJSON E'Inner where parseJSON o = P.either P.fail (pure . P.id) . toE'Inner =<< A.parseJSON o
instance WH.ToHttpApiData E'Inner where toQueryParam = WH.toQueryParam . fromE'Inner
instance WH.FromHttpApiData E'Inner where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'Inner
instance MimeRender MimeMultipartFormData E'Inner where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'Inner' enum
fromE'Inner :: E'Inner -> Text
fromE'Inner = \case
  E'Inner'UPPER -> "UPPER"
  E'Inner'Lower -> "lower"

-- | parse 'E'Inner' enum
toE'Inner :: Text -> P.Either String E'Inner
toE'Inner = \case
  "UPPER" -> P.Right E'Inner'UPPER
  "lower" -> P.Right E'Inner'Lower
  s -> P.Left $ "toE'Inner: enum parse failure: " P.++ P.show s


-- ** E'Inner2

-- | Enum of 'Text'
data E'Inner2
  = E'Inner2'GreaterThan -- ^ @">"@
  | E'Inner2'Dollar -- ^ @"$"@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'Inner2 where toJSON = A.toJSON . fromE'Inner2
instance A.FromJSON E'Inner2 where parseJSON o = P.either P.fail (pure . P.id) . toE'Inner2 =<< A.parseJSON o
instance WH.ToHttpApiData E'Inner2 where toQueryParam = WH.toQueryParam . fromE'Inner2
instance WH.FromHttpApiData E'Inner2 where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'Inner2
instance MimeRender MimeMultipartFormData E'Inner2 where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'Inner2' enum
fromE'Inner2 :: E'Inner2 -> Text
fromE'Inner2 = \case
  E'Inner2'GreaterThan -> ">"
  E'Inner2'Dollar -> "$"

-- | parse 'E'Inner2' enum
toE'Inner2 :: Text -> P.Either String E'Inner2
toE'Inner2 = \case
  ">" -> P.Right E'Inner2'GreaterThan
  "$" -> P.Right E'Inner2'Dollar
  s -> P.Left $ "toE'Inner2: enum parse failure: " P.++ P.show s


-- ** E'JustSymbol

-- | Enum of 'Text'
data E'JustSymbol
  = E'JustSymbol'Greater_Than_Or_Equal_To -- ^ @">="@
  | E'JustSymbol'Dollar -- ^ @"$"@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'JustSymbol where toJSON = A.toJSON . fromE'JustSymbol
instance A.FromJSON E'JustSymbol where parseJSON o = P.either P.fail (pure . P.id) . toE'JustSymbol =<< A.parseJSON o
instance WH.ToHttpApiData E'JustSymbol where toQueryParam = WH.toQueryParam . fromE'JustSymbol
instance WH.FromHttpApiData E'JustSymbol where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'JustSymbol
instance MimeRender MimeMultipartFormData E'JustSymbol where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'JustSymbol' enum
fromE'JustSymbol :: E'JustSymbol -> Text
fromE'JustSymbol = \case
  E'JustSymbol'Greater_Than_Or_Equal_To -> ">="
  E'JustSymbol'Dollar -> "$"

-- | parse 'E'JustSymbol' enum
toE'JustSymbol :: Text -> P.Either String E'JustSymbol
toE'JustSymbol = \case
  ">=" -> P.Right E'JustSymbol'Greater_Than_Or_Equal_To
  "$" -> P.Right E'JustSymbol'Dollar
  s -> P.Left $ "toE'JustSymbol: enum parse failure: " P.++ P.show s


-- ** E'Status

-- | Enum of 'Text' . 
-- Order Status
data E'Status
  = E'Status'Placed -- ^ @"placed"@
  | E'Status'Approved -- ^ @"approved"@
  | E'Status'Delivered -- ^ @"delivered"@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'Status where toJSON = A.toJSON . fromE'Status
instance A.FromJSON E'Status where parseJSON o = P.either P.fail (pure . P.id) . toE'Status =<< A.parseJSON o
instance WH.ToHttpApiData E'Status where toQueryParam = WH.toQueryParam . fromE'Status
instance WH.FromHttpApiData E'Status where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'Status
instance MimeRender MimeMultipartFormData E'Status where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'Status' enum
fromE'Status :: E'Status -> Text
fromE'Status = \case
  E'Status'Placed -> "placed"
  E'Status'Approved -> "approved"
  E'Status'Delivered -> "delivered"

-- | parse 'E'Status' enum
toE'Status :: Text -> P.Either String E'Status
toE'Status = \case
  "placed" -> P.Right E'Status'Placed
  "approved" -> P.Right E'Status'Approved
  "delivered" -> P.Right E'Status'Delivered
  s -> P.Left $ "toE'Status: enum parse failure: " P.++ P.show s


-- ** E'Status2

-- | Enum of 'Text' . 
-- pet status in the store
data E'Status2
  = E'Status2'Available -- ^ @"available"@
  | E'Status2'Pending -- ^ @"pending"@
  | E'Status2'Sold -- ^ @"sold"@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'Status2 where toJSON = A.toJSON . fromE'Status2
instance A.FromJSON E'Status2 where parseJSON o = P.either P.fail (pure . P.id) . toE'Status2 =<< A.parseJSON o
instance WH.ToHttpApiData E'Status2 where toQueryParam = WH.toQueryParam . fromE'Status2
instance WH.FromHttpApiData E'Status2 where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'Status2
instance MimeRender MimeMultipartFormData E'Status2 where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'Status2' enum
fromE'Status2 :: E'Status2 -> Text
fromE'Status2 = \case
  E'Status2'Available -> "available"
  E'Status2'Pending -> "pending"
  E'Status2'Sold -> "sold"

-- | parse 'E'Status2' enum
toE'Status2 :: Text -> P.Either String E'Status2
toE'Status2 = \case
  "available" -> P.Right E'Status2'Available
  "pending" -> P.Right E'Status2'Pending
  "sold" -> P.Right E'Status2'Sold
  s -> P.Left $ "toE'Status2: enum parse failure: " P.++ P.show s


-- ** EnumClass

-- | Enum of 'Text'
data EnumClass
  = EnumClass'_abc -- ^ @"_abc"@
  | EnumClass'_efg -- ^ @"-efg"@
  | EnumClass'_xyz -- ^ @"(xyz)"@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON EnumClass where toJSON = A.toJSON . fromEnumClass
instance A.FromJSON EnumClass where parseJSON o = P.either P.fail (pure . P.id) . toEnumClass =<< A.parseJSON o
instance WH.ToHttpApiData EnumClass where toQueryParam = WH.toQueryParam . fromEnumClass
instance WH.FromHttpApiData EnumClass where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toEnumClass
instance MimeRender MimeMultipartFormData EnumClass where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'EnumClass' enum
fromEnumClass :: EnumClass -> Text
fromEnumClass = \case
  EnumClass'_abc -> "_abc"
  EnumClass'_efg -> "-efg"
  EnumClass'_xyz -> "(xyz)"

-- | parse 'EnumClass' enum
toEnumClass :: Text -> P.Either String EnumClass
toEnumClass = \case
  "_abc" -> P.Right EnumClass'_abc
  "-efg" -> P.Right EnumClass'_efg
  "(xyz)" -> P.Right EnumClass'_xyz
  s -> P.Left $ "toEnumClass: enum parse failure: " P.++ P.show s


-- ** OuterEnum

-- | Enum of 'Text'
data OuterEnum
  = OuterEnum'Placed -- ^ @"placed"@
  | OuterEnum'Approved -- ^ @"approved"@
  | OuterEnum'Delivered -- ^ @"delivered"@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON OuterEnum where toJSON = A.toJSON . fromOuterEnum
instance A.FromJSON OuterEnum where parseJSON o = P.either P.fail (pure . P.id) . toOuterEnum =<< A.parseJSON o
instance WH.ToHttpApiData OuterEnum where toQueryParam = WH.toQueryParam . fromOuterEnum
instance WH.FromHttpApiData OuterEnum where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toOuterEnum
instance MimeRender MimeMultipartFormData OuterEnum where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'OuterEnum' enum
fromOuterEnum :: OuterEnum -> Text
fromOuterEnum = \case
  OuterEnum'Placed -> "placed"
  OuterEnum'Approved -> "approved"
  OuterEnum'Delivered -> "delivered"

-- | parse 'OuterEnum' enum
toOuterEnum :: Text -> P.Either String OuterEnum
toOuterEnum = \case
  "placed" -> P.Right OuterEnum'Placed
  "approved" -> P.Right OuterEnum'Approved
  "delivered" -> P.Right OuterEnum'Delivered
  s -> P.Left $ "toOuterEnum: enum parse failure: " P.++ P.show s


-- * Auth Methods

-- ** AuthApiKeyApiKey
data AuthApiKeyApiKey =
  AuthApiKeyApiKey Text -- ^ secret
  deriving (P.Eq, P.Show, P.Typeable)

instance AuthMethod AuthApiKeyApiKey where
  applyAuthMethod _ a@(AuthApiKeyApiKey secret) req =
    P.pure $
    if (P.typeOf a `P.elem` rAuthTypes req)
      then req `setHeader` toHeader ("api_key", secret)
           & L.over rAuthTypesL (P.filter (/= P.typeOf a))
      else req

-- ** AuthApiKeyApiKeyQuery
data AuthApiKeyApiKeyQuery =
  AuthApiKeyApiKeyQuery Text -- ^ secret
  deriving (P.Eq, P.Show, P.Typeable)

instance AuthMethod AuthApiKeyApiKeyQuery where
  applyAuthMethod _ a@(AuthApiKeyApiKeyQuery secret) req =
    P.pure $
    if (P.typeOf a `P.elem` rAuthTypes req)
      then req `setQuery` toQuery ("api_key_query", Just secret)
           & L.over rAuthTypesL (P.filter (/= P.typeOf a))
      else req

-- ** AuthBasicHttpBasicTest
data AuthBasicHttpBasicTest =
  AuthBasicHttpBasicTest B.ByteString B.ByteString -- ^ username password
  deriving (P.Eq, P.Show, P.Typeable)

instance AuthMethod AuthBasicHttpBasicTest where
  applyAuthMethod _ a@(AuthBasicHttpBasicTest user pw) req =
    P.pure $
    if (P.typeOf a `P.elem` rAuthTypes req)
      then req `setHeader` toHeader ("Authorization", T.decodeUtf8 cred)
           & L.over rAuthTypesL (P.filter (/= P.typeOf a))
      else req
    where cred = BC.append "Basic " (B64.encode $ BC.concat [ user, ":", pw ])

-- ** AuthOAuthPetstoreAuth
data AuthOAuthPetstoreAuth =
  AuthOAuthPetstoreAuth Text -- ^ secret
  deriving (P.Eq, P.Show, P.Typeable)

instance AuthMethod AuthOAuthPetstoreAuth where
  applyAuthMethod _ a@(AuthOAuthPetstoreAuth secret) req =
    P.pure $
    if (P.typeOf a `P.elem` rAuthTypes req)
      then req `setHeader` toHeader ("Authorization", "Bearer " <> secret) 
           & L.over rAuthTypesL (P.filter (/= P.typeOf a))
      else req

