{-
   Swagger Petstore

   This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\

   OpenAPI spec version: 2.0
   Swagger Petstore API version: 1.0.0
   Contact: apiteam@swagger.io
   Generated by Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
-}

{-|
Module : SwaggerPetstore.API.Fake
-}

{-# LANGUAGE FlexibleContexts #-}
{-# LANGUAGE FlexibleInstances #-}
{-# LANGUAGE MonoLocalBinds #-}
{-# LANGUAGE MultiParamTypeClasses #-}
{-# LANGUAGE OverloadedStrings #-}
{-# OPTIONS_GHC -fno-warn-name-shadowing -fno-warn-unused-binds -fno-warn-unused-imports #-}

module SwaggerPetstore.API.Fake where

import SwaggerPetstore.Core
import SwaggerPetstore.MimeTypes
import SwaggerPetstore.Model as M

import qualified Data.Aeson as A
import qualified Data.ByteString as B
import qualified Data.ByteString.Lazy as BL
import qualified Data.Data as P (Typeable, TypeRep, typeOf, typeRep)
import qualified Data.Foldable as P
import qualified Data.Map as Map
import qualified Data.Maybe as P
import qualified Data.Proxy as P (Proxy(..))
import qualified Data.Set as Set
import qualified Data.String as P
import qualified Data.Text as T
import qualified Data.Text.Encoding as T
import qualified Data.Text.Lazy as TL
import qualified Data.Text.Lazy.Encoding as TL
import qualified Data.Time as TI
import qualified Network.HTTP.Client.MultipartFormData as NH
import qualified Network.HTTP.Media as ME
import qualified Network.HTTP.Types as NH
import qualified Web.FormUrlEncoded as WH
import qualified Web.HttpApiData as WH

import Data.Text (Text)
import GHC.Base ((<|>))

import Prelude ((==),(/=),($), (.),(<$>),(<*>),(>>=),Maybe(..),Bool(..),Char,Double,FilePath,Float,Int,Integer,String,fmap,undefined,mempty,maybe,pure,Monad,Applicative,Functor)
import qualified Prelude as P

-- * Operations


-- ** Fake

-- *** fakeOuterBooleanSerialize

-- | @POST \/fake\/outer\/boolean@
-- 
-- Test serialization of outer boolean types
-- 
fakeOuterBooleanSerialize 
  :: (Consumes FakeOuterBooleanSerialize contentType)
  => ContentType contentType -- ^ request content-type ('MimeType')
  -> Accept accept -- ^ request accept ('MimeType')
  -> SwaggerPetstoreRequest FakeOuterBooleanSerialize contentType OuterBoolean accept
fakeOuterBooleanSerialize _  _ =
  _mkRequest "POST" ["/fake/outer/boolean"]

data FakeOuterBooleanSerialize 

-- | /Body Param/ "body" - Input boolean as post body
instance HasBodyParam FakeOuterBooleanSerialize OuterBoolean 

-- *** fakeOuterCompositeSerialize

-- | @POST \/fake\/outer\/composite@
-- 
-- Test serialization of object with outer number type
-- 
fakeOuterCompositeSerialize 
  :: (Consumes FakeOuterCompositeSerialize contentType)
  => ContentType contentType -- ^ request content-type ('MimeType')
  -> Accept accept -- ^ request accept ('MimeType')
  -> SwaggerPetstoreRequest FakeOuterCompositeSerialize contentType OuterComposite accept
fakeOuterCompositeSerialize _  _ =
  _mkRequest "POST" ["/fake/outer/composite"]

data FakeOuterCompositeSerialize 

-- | /Body Param/ "body" - Input composite as post body
instance HasBodyParam FakeOuterCompositeSerialize OuterComposite 

-- *** fakeOuterNumberSerialize

-- | @POST \/fake\/outer\/number@
-- 
-- Test serialization of outer number types
-- 
fakeOuterNumberSerialize 
  :: (Consumes FakeOuterNumberSerialize contentType)
  => ContentType contentType -- ^ request content-type ('MimeType')
  -> Accept accept -- ^ request accept ('MimeType')
  -> SwaggerPetstoreRequest FakeOuterNumberSerialize contentType OuterNumber accept
fakeOuterNumberSerialize _  _ =
  _mkRequest "POST" ["/fake/outer/number"]

data FakeOuterNumberSerialize 

-- | /Body Param/ "body" - Input number as post body
instance HasBodyParam FakeOuterNumberSerialize OuterNumber 

-- *** fakeOuterStringSerialize

-- | @POST \/fake\/outer\/string@
-- 
-- Test serialization of outer string types
-- 
fakeOuterStringSerialize 
  :: (Consumes FakeOuterStringSerialize contentType)
  => ContentType contentType -- ^ request content-type ('MimeType')
  -> Accept accept -- ^ request accept ('MimeType')
  -> SwaggerPetstoreRequest FakeOuterStringSerialize contentType OuterString accept
fakeOuterStringSerialize _  _ =
  _mkRequest "POST" ["/fake/outer/string"]

data FakeOuterStringSerialize 

-- | /Body Param/ "body" - Input string as post body
instance HasBodyParam FakeOuterStringSerialize OuterString 

-- *** testBodyWithQueryParams

-- | @PUT \/fake\/body-with-query-params@
-- 
testBodyWithQueryParams 
  :: (Consumes TestBodyWithQueryParams MimeJSON, MimeRender MimeJSON User)
  => User -- ^ "body"
  -> Query -- ^ "query"
  -> SwaggerPetstoreRequest TestBodyWithQueryParams MimeJSON NoContent MimeNoContent
testBodyWithQueryParams body (Query query) =
  _mkRequest "PUT" ["/fake/body-with-query-params"]
    `setBodyParam` body
    `setQuery` toQuery ("query", Just query)

data TestBodyWithQueryParams 
instance HasBodyParam TestBodyWithQueryParams User 

-- | @application/json@
instance Consumes TestBodyWithQueryParams MimeJSON


-- *** testClientModel

-- | @PATCH \/fake@
-- 
-- To test \"client\" model
-- 
-- To test \"client\" model
-- 
testClientModel 
  :: (Consumes TestClientModel MimeJSON, MimeRender MimeJSON Client)
  => Client -- ^ "body" -  client model
  -> SwaggerPetstoreRequest TestClientModel MimeJSON Client MimeJSON
testClientModel body =
  _mkRequest "PATCH" ["/fake"]
    `setBodyParam` body

data TestClientModel 

-- | /Body Param/ "body" - client model
instance HasBodyParam TestClientModel Client 

-- | @application/json@
instance Consumes TestClientModel MimeJSON

-- | @application/json@
instance Produces TestClientModel MimeJSON


-- *** testEndpointParameters

-- | @POST \/fake@
-- 
-- Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트 
-- 
-- Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트 
-- 
-- AuthMethod: 'AuthBasicHttpBasicTest'
-- 
-- Note: Has 'Produces' instances, but no response schema
-- 
testEndpointParameters 
  :: (Consumes TestEndpointParameters contentType)
  => ContentType contentType -- ^ request content-type ('MimeType')
  -> Accept accept -- ^ request accept ('MimeType')
  -> Number -- ^ "number" -  None
  -> ParamDouble -- ^ "double" -  None
  -> PatternWithoutDelimiter -- ^ "patternWithoutDelimiter" -  None
  -> Byte -- ^ "byte" -  None
  -> SwaggerPetstoreRequest TestEndpointParameters contentType res accept
testEndpointParameters _  _ (Number number) (ParamDouble double) (PatternWithoutDelimiter patternWithoutDelimiter) (Byte byte) =
  _mkRequest "POST" ["/fake"]
    `_hasAuthType` (P.Proxy :: P.Proxy AuthBasicHttpBasicTest)
    `addForm` toForm ("number", number)
    `addForm` toForm ("double", double)
    `addForm` toForm ("pattern_without_delimiter", patternWithoutDelimiter)
    `addForm` toForm ("byte", byte)

data TestEndpointParameters  

-- | /Optional Param/ "integer" - None
instance HasOptionalParam TestEndpointParameters ParamInteger where
  applyOptionalParam req (ParamInteger xs) =
    req `addForm` toForm ("integer", xs)

-- | /Optional Param/ "int32" - None
instance HasOptionalParam TestEndpointParameters Int32 where
  applyOptionalParam req (Int32 xs) =
    req `addForm` toForm ("int32", xs)

-- | /Optional Param/ "int64" - None
instance HasOptionalParam TestEndpointParameters Int64 where
  applyOptionalParam req (Int64 xs) =
    req `addForm` toForm ("int64", xs)

-- | /Optional Param/ "float" - None
instance HasOptionalParam TestEndpointParameters ParamFloat where
  applyOptionalParam req (ParamFloat xs) =
    req `addForm` toForm ("float", xs)

-- | /Optional Param/ "string" - None
instance HasOptionalParam TestEndpointParameters ParamString where
  applyOptionalParam req (ParamString xs) =
    req `addForm` toForm ("string", xs)

-- | /Optional Param/ "binary" - None
instance HasOptionalParam TestEndpointParameters ParamBinary where
  applyOptionalParam req (ParamBinary xs) =
    req `addForm` toForm ("binary", xs)

-- | /Optional Param/ "date" - None
instance HasOptionalParam TestEndpointParameters ParamDate where
  applyOptionalParam req (ParamDate xs) =
    req `addForm` toForm ("date", xs)

-- | /Optional Param/ "dateTime" - None
instance HasOptionalParam TestEndpointParameters ParamDateTime where
  applyOptionalParam req (ParamDateTime xs) =
    req `addForm` toForm ("dateTime", xs)

-- | /Optional Param/ "password" - None
instance HasOptionalParam TestEndpointParameters Password where
  applyOptionalParam req (Password xs) =
    req `addForm` toForm ("password", xs)

-- | /Optional Param/ "callback" - None
instance HasOptionalParam TestEndpointParameters Callback where
  applyOptionalParam req (Callback xs) =
    req `addForm` toForm ("callback", xs)

-- | @application/xml; charset=utf-8@
instance Consumes TestEndpointParameters MimeXmlCharsetutf8
-- | @application/json; charset=utf-8@
instance Consumes TestEndpointParameters MimeJsonCharsetutf8

-- | @application/xml; charset=utf-8@
instance Produces TestEndpointParameters MimeXmlCharsetutf8
-- | @application/json; charset=utf-8@
instance Produces TestEndpointParameters MimeJsonCharsetutf8


-- *** testEnumParameters

-- | @GET \/fake@
-- 
-- To test enum parameters
-- 
-- To test enum parameters
-- 
-- Note: Has 'Produces' instances, but no response schema
-- 
testEnumParameters 
  :: (Consumes TestEnumParameters contentType)
  => ContentType contentType -- ^ request content-type ('MimeType')
  -> Accept accept -- ^ request accept ('MimeType')
  -> SwaggerPetstoreRequest TestEnumParameters contentType res accept
testEnumParameters _  _ =
  _mkRequest "GET" ["/fake"]

data TestEnumParameters  

-- | /Optional Param/ "enum_form_string_array" - Form parameter enum test (string array)
instance HasOptionalParam TestEnumParameters EnumFormStringArray where
  applyOptionalParam req (EnumFormStringArray xs) =
    req `addForm` toFormColl CommaSeparated ("enum_form_string_array", xs)

-- | /Optional Param/ "enum_form_string" - Form parameter enum test (string)
instance HasOptionalParam TestEnumParameters EnumFormString where
  applyOptionalParam req (EnumFormString xs) =
    req `addForm` toForm ("enum_form_string", xs)

-- | /Optional Param/ "enum_header_string_array" - Header parameter enum test (string array)
instance HasOptionalParam TestEnumParameters EnumHeaderStringArray where
  applyOptionalParam req (EnumHeaderStringArray xs) =
    req `setHeader` toHeaderColl CommaSeparated ("enum_header_string_array", xs)

-- | /Optional Param/ "enum_header_string" - Header parameter enum test (string)
instance HasOptionalParam TestEnumParameters EnumHeaderString where
  applyOptionalParam req (EnumHeaderString xs) =
    req `setHeader` toHeader ("enum_header_string", xs)

-- | /Optional Param/ "enum_query_string_array" - Query parameter enum test (string array)
instance HasOptionalParam TestEnumParameters EnumQueryStringArray where
  applyOptionalParam req (EnumQueryStringArray xs) =
    req `setQuery` toQueryColl CommaSeparated ("enum_query_string_array", Just xs)

-- | /Optional Param/ "enum_query_string" - Query parameter enum test (string)
instance HasOptionalParam TestEnumParameters EnumQueryString where
  applyOptionalParam req (EnumQueryString xs) =
    req `setQuery` toQuery ("enum_query_string", Just xs)

-- | /Optional Param/ "enum_query_integer" - Query parameter enum test (double)
instance HasOptionalParam TestEnumParameters EnumQueryInteger where
  applyOptionalParam req (EnumQueryInteger xs) =
    req `setQuery` toQuery ("enum_query_integer", Just xs)

-- | /Optional Param/ "enum_query_double" - Query parameter enum test (double)
instance HasOptionalParam TestEnumParameters EnumQueryDouble where
  applyOptionalParam req (EnumQueryDouble xs) =
    req `addForm` toForm ("enum_query_double", xs)

-- | @*/*@
instance MimeType mtype => Consumes TestEnumParameters mtype

-- | @*/*@
instance MimeType mtype => Produces TestEnumParameters mtype


-- *** testInlineAdditionalProperties

-- | @POST \/fake\/inline-additionalProperties@
-- 
-- test inline additionalProperties
-- 
-- 
-- 
testInlineAdditionalProperties 
  :: (Consumes TestInlineAdditionalProperties MimeJSON, MimeRender MimeJSON A.Value)
  => A.Value -- ^ "param" -  request body
  -> SwaggerPetstoreRequest TestInlineAdditionalProperties MimeJSON NoContent MimeNoContent
testInlineAdditionalProperties param =
  _mkRequest "POST" ["/fake/inline-additionalProperties"]
    `setBodyParam` param

data TestInlineAdditionalProperties 

-- | /Body Param/ "param" - request body
instance HasBodyParam TestInlineAdditionalProperties A.Value 

-- | @application/json@
instance Consumes TestInlineAdditionalProperties MimeJSON


-- *** testJsonFormData

-- | @GET \/fake\/jsonFormData@
-- 
-- test json serialization of form data
-- 
-- 
-- 
testJsonFormData 
  :: (Consumes TestJsonFormData MimeJSON)
  => Param -- ^ "param" -  field1
  -> Param2 -- ^ "param2" -  field2
  -> SwaggerPetstoreRequest TestJsonFormData MimeJSON NoContent MimeNoContent
testJsonFormData (Param param) (Param2 param2) =
  _mkRequest "GET" ["/fake/jsonFormData"]
    `addForm` toForm ("param", param)
    `addForm` toForm ("param2", param2)

data TestJsonFormData  

-- | @application/json@
instance Consumes TestJsonFormData MimeJSON

