module Main exposing (..)

import Json.Decode as Decode
import Html exposing (Html, button, div, text)
import Html.Events exposing (onClick)
import Http


main : Program Never Model Msg
main =
    Html.program
        { init = init
        , view = view
        , update = update
        , subscriptions = subscriptions
        }

type alias Model =
    { status : Maybe Int
    }

init : (Model, Cmd Msg)
init =
    ( Model Nothing, Cmd.none )

type Msg
    = NoOp

update : Msg -> Model -> (Model, Cmd Msg)
update msg model =
    case msg of
        NoOp ->
            ( model, Cmd.none )


view : Model -> Html Msg
view model =
    Html.text "main"


subscriptions : Model -> Sub Msg
subscriptions model =
    Sub.none
