/* 
 * Swagger Petstore
 *
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * OpenAPI spec version: 1.0.0
 * Contact: apiteam@swagger.io
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.Serialization;

namespace IO.Swagger.Client
{
    public class ReadOnlyDictionary<T, K> : IDictionary<T, K>
    {
        private IDictionary<T, K> _dictionaryImplementation;
        public IEnumerator<KeyValuePair<T, K>> GetEnumerator()
        {
            return _dictionaryImplementation.GetEnumerator();
        }

        public ReadOnlyDictionary()
        {
            _dictionaryImplementation = new Dictionary<T, K>();
        }

        public ReadOnlyDictionary(IDictionary<T, K> dictionaryImplementation)
        {
            if (dictionaryImplementation == null) throw new ArgumentNullException("dictionaryImplementation");
            _dictionaryImplementation = dictionaryImplementation;
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return ((IEnumerable) _dictionaryImplementation).GetEnumerator();
        }

        public void Add(KeyValuePair<T, K> item)
        {
            throw new ReadonlyOperationException("This instance is readonly.");
        }

        public void Clear()
        {
            throw new ReadonlyOperationException("This instance is readonly.");
        }

        public bool Contains(KeyValuePair<T, K> item)
        {
            return _dictionaryImplementation.Contains(item);
        }

        public void CopyTo(KeyValuePair<T, K>[] array, int arrayIndex)
        {
            _dictionaryImplementation.CopyTo(array, arrayIndex);
        }

        public bool Remove(KeyValuePair<T, K> item)
        {
            throw new ReadonlyOperationException("This instance is readonly.");
        }

        public int Count
        {
            get { return _dictionaryImplementation.Count; }
        }

        public bool IsReadOnly
        {
            get { return true; }
        }

        public void Add(T key, K value)
        {
            throw new ReadonlyOperationException("This instance is readonly.");
        }

        public bool ContainsKey(T key)
        {
            return _dictionaryImplementation.ContainsKey(key);
        }

        public bool Remove(T key)
        {
            throw new ReadonlyOperationException("This instance is readonly.");
        }

        public bool TryGetValue(T key, out K value)
        {
            return _dictionaryImplementation.TryGetValue(key, out value);
        }

        public K this[T key]
        {
            get { return _dictionaryImplementation[key]; }
            set
            {
                throw new ReadonlyOperationException("This instance is readonly.");

            }
        }

        public ICollection<T> Keys
        {
            get { return _dictionaryImplementation.Keys; }
        }

        public ICollection<K> Values
        {
            get { return _dictionaryImplementation.Values; }
        }
    }

    [Serializable]
    public class ReadonlyOperationException : Exception
    {
        //
        // For guidelines regarding the creation of new exception types, see
        //    http://msdn.microsoft.com/library/default.asp?url=/library/en-us/cpgenref/html/cpconerrorraisinghandlingguidelines.asp
        // and
        //    http://msdn.microsoft.com/library/default.asp?url=/library/en-us/dncscol/html/csharp07192001.asp
        //

        public ReadonlyOperationException()
        {
        }

        public ReadonlyOperationException(string message) : base(message)
        {
        }

        public ReadonlyOperationException(string message, Exception inner) : base(message, inner)
        {
        }

        protected ReadonlyOperationException(
            SerializationInfo info,
            StreamingContext context) : base(info, context)
        {
        }
    }
}
