/*
 * Swagger Petstore
 * This is a sample server Petstore server.  You can find out more about Swagger at [http://swagger.io](http://swagger.io) or on [irc.freenode.net, #swagger](http://swagger.io/irc/).  For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: apiteam@swagger.io
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

public class SwagStoreApi {
    SwagClient client;

    public SwagStoreApi(SwagClient client) {
        this.client = client;
    }

    public SwagStoreApi() {
        this.client = new SwagClient();
    }

    public SwagClient getClient() {
        return this.client;
    }

    /**
     * Delete purchase order by ID
     * For valid response try integer IDs with value &lt; 1000. Anything above 1000 or nonintegers will generate API errors
     * @param orderId ID of the order that needs to be deleted (required)
     * @throws Swagger.ApiException if fails to make API call
     */
    public void deleteOrder(Map<String, Object> params) {
        client.assertNotNull(params.get('orderId'), 'orderId');
        List<Swagger.Param> query = new List<Swagger.Param>();
        List<Swagger.Param> form = new List<Swagger.Param>();

        client.invoke(
            'DELETE', '/store/order/{orderId}', '',
            query, form,
            new Map<String, Object>{
                'orderId' => (String) params.get('orderId')
            },
            new Map<String, Object>(),
            new List<String>{ 'application/json' },
            new List<String>{ 'application/json' },
            new List<String>(),
            null
        );
    }
    /**
     * Returns pet inventories by status
     * Returns a map of status codes to quantities
     * @return Map<String, Integer>
     * @throws Swagger.ApiException if fails to make API call
     */
    public Map<String, Integer> getInventory() {
        List<Swagger.Param> query = new List<Swagger.Param>();
        List<Swagger.Param> form = new List<Swagger.Param>();

        return (Map<String, Integer>) client.invoke(
            'GET', '/store/inventory', '',
            query, form,
            new Map<String, Object>(),
            new Map<String, Object>(),
            new List<String>{ 'application/json' },
            new List<String>{ 'application/json' },
            new List<String> { 'api_key' },
            Map<String, Integer>.class
        );
    }
    /**
     * Find purchase order by ID
     * For valid response try integer IDs with value &lt;&#x3D; 5 or &gt; 10. Other values will generated exceptions
     * @param orderId ID of pet that needs to be fetched (required)
     * @return SwagOrder
     * @throws Swagger.ApiException if fails to make API call
     */
    public SwagOrder getOrderById(Map<String, Object> params) {
        client.assertNotNull(params.get('orderId'), 'orderId');
        List<Swagger.Param> query = new List<Swagger.Param>();
        List<Swagger.Param> form = new List<Swagger.Param>();

        return (SwagOrder) client.invoke(
            'GET', '/store/order/{orderId}', '',
            query, form,
            new Map<String, Object>{
                'orderId' => (Long) params.get('orderId')
            },
            new Map<String, Object>(),
            new List<String>{ 'application/json' },
            new List<String>{ 'application/json' },
            new List<String>(),
            SwagOrder.class
        );
    }
    /**
     * Place an order for a pet
     * 
     * @param body order placed for purchasing the pet (required)
     * @return SwagOrder
     * @throws Swagger.ApiException if fails to make API call
     */
    public SwagOrder placeOrder(Map<String, Object> params) {
        client.assertNotNull(params.get('body'), 'body');
        List<Swagger.Param> query = new List<Swagger.Param>();
        List<Swagger.Param> form = new List<Swagger.Param>();

        return (SwagOrder) client.invoke(
            'POST', '/store/order',
            (SwagOrder) params.get('body'),
            query, form,
            new Map<String, Object>(),
            new Map<String, Object>(),
            new List<String>{ 'application/json' },
            new List<String>{ 'application/json' },
            new List<String>(),
            SwagOrder.class
        );
    }
}
