# scala-akka-petstore-client

Swagger Petstore
- API version: 1.0.0

This is a sample server Petstore server.  You can find out more about Swagger at [http://swagger.io](http://swagger.io) or on [irc.freenode.net, #swagger](http://swagger.io/irc/).  For this sample, you can use the api key `special-key` to test the authorization filters.


*Automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen)*

## Requirements

Building the API client library requires:
1. Java 1.7+
2. Maven/Gradle/SBT

## Installation

To install the API client library to your local Maven repository, simply execute:

```shell
mvn clean install
```

To deploy it to a remote Maven repository instead, configure the settings of the repository and execute:

```shell
mvn clean deploy
```

Refer to the [OSSRH Guide](http://central.sonatype.org/pages/ossrh-guide.html) for more information.

### Maven users

Add this dependency to your project's POM:

```xml
<dependency>
  <groupId>io.swagger</groupId>
  <artifactId>scala-akka-petstore-client</artifactId>
  <version>1.0.0</version>
  <scope>compile</scope>
</dependency>
```

### Gradle users

Add this dependency to your project's build file:

```groovy
compile "io.swagger:scala-akka-petstore-client:1.0.0"
```

### SBT users

```scala
libraryDependencies += "io.swagger" % "scala-akka-petstore-client" % "1.0.0"
```

## Getting Started

## Documentation for API Endpoints

All URIs are relative to *http://petstore.swagger.io/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*PetApi* | **addPet** | **POST** /pet | Add a new pet to the store
*PetApi* | **deletePet** | **DELETE** /pet/{petId} | Deletes a pet
*PetApi* | **findPetsByStatus** | **GET** /pet/findByStatus | Finds Pets by status
*PetApi* | **findPetsByTags** | **GET** /pet/findByTags | Finds Pets by tags
*PetApi* | **getPetById** | **GET** /pet/{petId} | Find pet by ID
*PetApi* | **updatePet** | **PUT** /pet | Update an existing pet
*PetApi* | **updatePetWithForm** | **POST** /pet/{petId} | Updates a pet in the store with form data
*PetApi* | **uploadFile** | **POST** /pet/{petId}/uploadImage | uploads an image
*StoreApi* | **deleteOrder** | **DELETE** /store/order/{orderId} | Delete purchase order by ID
*StoreApi* | **getInventory** | **GET** /store/inventory | Returns pet inventories by status
*StoreApi* | **getOrderById** | **GET** /store/order/{orderId} | Find purchase order by ID
*StoreApi* | **placeOrder** | **POST** /store/order | Place an order for a pet
*UserApi* | **createUser** | **POST** /user | Create user
*UserApi* | **createUsersWithArrayInput** | **POST** /user/createWithArray | Creates list of users with given input array
*UserApi* | **createUsersWithListInput** | **POST** /user/createWithList | Creates list of users with given input array
*UserApi* | **deleteUser** | **DELETE** /user/{username} | Delete user
*UserApi* | **getUserByName** | **GET** /user/{username} | Get user by user name
*UserApi* | **loginUser** | **GET** /user/login | Logs user into the system
*UserApi* | **logoutUser** | **GET** /user/logout | Logs out current logged in user session
*UserApi* | **updateUser** | **PUT** /user/{username} | Updated user


## Documentation for Models

 - [Amount](Amount.md)
 - [ApiResponse](ApiResponse.md)
 - [Category](Category.md)
 - [Currency](Currency.md)
 - [Order](Order.md)
 - [Pet](Pet.md)
 - [Tag](Tag.md)
 - [User](User.md)


## Documentation for Authorization

Authentication schemes defined for the API:
### api_key

- **Type**: API key
- **API key parameter name**: api_key
- **Location**: HTTP header


## Author

apiteam@swagger.io
