# Swagger Petstore
# 
# This is a sample server Petstore server.  You can find out more about Swagger at [http://swagger.io](http://swagger.io) or on [irc.freenode.net, #swagger](http://swagger.io/irc/).  For this sample, you can use the api key `special-key` to test the authorization filters.
# 
# OpenAPI spec version: 1.0.0
# Contact: apiteam@swagger.io
# Generated by: https://github.com/swagger-api/swagger-codegen.git

UserApi <- R6::R6Class(
  'UserApi',
  public = list(
    userAgent = "Swagger-Codegen/1.0.0/r",
    basePath = "http://petstore.swagger.io/v2",
    initialize = function(basePath){
      if (!missing(basePath)) {
        stopifnot(is.character(basePath), length(basePath) == 1)
        self$basePath <- basePath
      }
    },

    create_user = function(body){
      resp <- httr::POST(paste0(self$basePath),
          httr::add_headers("User-Agent" = self$userAgent, "content-type" = "application/xml")
          ,body = body$toJSON()
          )

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        # void response, no need to return anything
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499){
        Response$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599){
        Response$new("API server error", resp)
      }

    },
    create_users_with_array_input = function(body){
      resp <- httr::POST(paste0(self$basePath),
          httr::add_headers("User-Agent" = self$userAgent, "content-type" = "application/xml")
          ,body = body$toJSON()
          )

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        # void response, no need to return anything
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499){
        Response$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599){
        Response$new("API server error", resp)
      }

    },
    create_users_with_list_input = function(body){
      resp <- httr::POST(paste0(self$basePath),
          httr::add_headers("User-Agent" = self$userAgent, "content-type" = "application/xml")
          ,body = body$toJSON()
          )

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        # void response, no need to return anything
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499){
        Response$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599){
        Response$new("API server error", resp)
      }

    },
    delete_user = function(username){
      resp <- httr::DELETE(paste0(self$basePath, username),
          httr::add_headers("User-Agent" = self$userAgent, "content-type" = "application/xml")
          )

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        # void response, no need to return anything
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499){
        Response$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599){
        Response$new("API server error", resp)
      }

    },
    get_user_by_name = function(username){
      resp <- httr::GET(paste0(self$basePath, username),
          httr::add_headers("User-Agent" = self$userAgent, "content-type" = "application/xml")
          )

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        result <- User$new()$fromJSON(httr::content(resp, "text", encoding = "UTF-8"), simplifyVector = FALSE)
        Response$new(result, resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499){
        Response$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599){
        Response$new("API server error", resp)
      }

    },
    login_user = function(username, password){
      resp <- httr::GET(paste0(self$basePath),
          httr::add_headers("User-Agent" = self$userAgent, "content-type" = "application/xml")
          ,query = list(
            "username" = username,
            "password" = password
			)
          )

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        result <- Character$new()$fromJSON(httr::content(resp, "text", encoding = "UTF-8"), simplifyVector = FALSE)
        Response$new(result, resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499){
        Response$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599){
        Response$new("API server error", resp)
      }

    },
    logout_user = function(){
      resp <- httr::GET(paste0(self$basePath),
          httr::add_headers("User-Agent" = self$userAgent, "content-type" = "application/xml")
          )

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        # void response, no need to return anything
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499){
        Response$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599){
        Response$new("API server error", resp)
      }

    },
    update_user = function(username, body){
      resp <- httr::PUT(paste0(self$basePath, username),
          httr::add_headers("User-Agent" = self$userAgent, "content-type" = "application/xml")
          ,body = body$toJSON()
          )

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        # void response, no need to return anything
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499){
        Response$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599){
        Response$new("API server error", resp)
      }

    }
  )
) 
