# Swagger Petstore
# 
# This is a sample server Petstore server.  You can find out more about Swagger at [http://swagger.io](http://swagger.io) or on [irc.freenode.net, #swagger](http://swagger.io/irc/).  For this sample, you can use the api key `special-key` to test the authorization filters.
# 
# OpenAPI spec version: 1.0.0
# Contact: apiteam@swagger.io
# Generated by: https://github.com/swagger-api/swagger-codegen.git

PetApi <- R6::R6Class(
  'PetApi',
  public = list(
    userAgent = "Swagger-Codegen/1.0.0/r",
    basePath = "http://petstore.swagger.io/v2",
    initialize = function(basePath){
      if (!missing(basePath)) {
        stopifnot(is.character(basePath), length(basePath) == 1)
        self$basePath <- basePath
      }
    },

    add_pet = function(body){
      resp <- httr::POST(paste0(self$basePath),
          httr::add_headers("User-Agent" = self$userAgent, "accept" = "application/json", "content-type" = "application/xml")
          ,body = body$toJSON()
          )

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        # void response, no need to return anything
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499){
        Response$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599){
        Response$new("API server error", resp)
      }

    },
    delete_pet = function(pet_id, api_key){
      resp <- httr::DELETE(paste0(self$basePath, pet_id),
          httr::add_headers("User-Agent" = self$userAgent, "content-type" = "application/xml", "api_key" = api_key)
          )

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        # void response, no need to return anything
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499){
        Response$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599){
        Response$new("API server error", resp)
      }

    },
    find_pets_by_status = function(status){
      resp <- httr::GET(paste0(self$basePath),
          httr::add_headers("User-Agent" = self$userAgent, "content-type" = "application/xml")
          ,query = list(
            "status" = status
			)
          )

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        result <- Pet$new()$fromJSON(httr::content(resp, "text", encoding = "UTF-8"), simplifyVector = FALSE)
        Response$new(result, resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499){
        Response$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599){
        Response$new("API server error", resp)
      }

    },
    find_pets_by_tags = function(tags){
      resp <- httr::GET(paste0(self$basePath),
          httr::add_headers("User-Agent" = self$userAgent, "content-type" = "application/xml")
          ,query = list(
            "tags" = tags
			)
          )

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        result <- Pet$new()$fromJSON(httr::content(resp, "text", encoding = "UTF-8"), simplifyVector = FALSE)
        Response$new(result, resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499){
        Response$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599){
        Response$new("API server error", resp)
      }

    },
    get_pet_by_id = function(pet_id){
      resp <- httr::GET(paste0(self$basePath, pet_id),
          httr::add_headers("User-Agent" = self$userAgent, "content-type" = "application/xml")
          )

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        result <- Pet$new()$fromJSON(httr::content(resp, "text", encoding = "UTF-8"), simplifyVector = FALSE)
        Response$new(result, resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499){
        Response$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599){
        Response$new("API server error", resp)
      }

    },
    update_pet = function(body){
      resp <- httr::PUT(paste0(self$basePath),
          httr::add_headers("User-Agent" = self$userAgent, "accept" = "application/json", "content-type" = "application/xml")
          ,body = body$toJSON()
          )

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        # void response, no need to return anything
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499){
        Response$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599){
        Response$new("API server error", resp)
      }

    },
    update_pet_with_form = function(pet_id, name, status){
      resp <- httr::POST(paste0(self$basePath, pet_id),
          httr::add_headers("User-Agent" = self$userAgent, "accept" = "application/x-www-form-urlencoded", "content-type" = "application/xml")
          ,body = list(
              "name" = name,
              "status" = status
            )
          )

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        # void response, no need to return anything
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499){
        Response$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599){
        Response$new("API server error", resp)
      }

    },
    upload_file = function(pet_id, additional_metadata, file){
      resp <- httr::POST(paste0(self$basePath, pet_id),
          httr::add_headers("User-Agent" = self$userAgent, "accept" = "multipart/form-data", "content-type" = "application/json")
          ,body = list(
              "additionalMetadata" = additional_metadata,
              "file" = httr::upload_file(file)
            )
          )

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        result <- ApiResponse$new()$fromJSON(httr::content(resp, "text", encoding = "UTF-8"), simplifyVector = FALSE)
        Response$new(result, resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499){
        Response$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599){
        Response$new("API server error", resp)
      }

    }
  )
) 
