import * as $ from 'jquery';

let defaultBasePath = 'https://petstore.swagger.io *_/ ' \" =end -- \\r\\n \\n \\r/v2 *_/ ' \" =end -- \\r\\n \\n \\r';

// ===============================================
// This file is autogenerated - Please do not edit
// ===============================================

/* tslint:disable:no-unused-variable */

    /**
    * Model for testing reserved words  *_/ ' \" =end -- \\r\\n \\n \\r
    */
export class ModelReturn {
        /**
        * property description  *_/ ' \" =end -- \\r\\n \\n \\r
        */
    'return': number;
}


export interface Authentication {
    /**
    * Apply authentication settings to header and query params.
    */
    applyToRequest(requestOptions: JQueryAjaxSettings): void;
}

export class HttpBasicAuth implements Authentication {
    public username: string;
    public password: string;
    applyToRequest(requestOptions: any): void {
        requestOptions.username = this.username;
        requestOptions.password = this.password;
    }
}

export class ApiKeyAuth implements Authentication {
    public apiKey: string;

    constructor(private location: string, private paramName: string) {
    }

    applyToRequest(requestOptions: JQueryAjaxSettings): void {
        requestOptions.headers[this.paramName] = this.apiKey;
    }
}

export class OAuth implements Authentication {
    public accessToken: string;

    applyToRequest(requestOptions: JQueryAjaxSettings): void {
        requestOptions.headers["Authorization"] = "Bearer " + this.accessToken;
    }
}

export class VoidAuth implements Authentication {
    public username: string;
    public password: string;
    applyToRequest(requestOptions: JQueryAjaxSettings): void {
        // Do nothing
    }
}

export enum FakeApiApiKeys {
    api_key,
}

export class FakeApi {
    protected basePath = defaultBasePath;
    protected defaultHeaders : any = {};

    protected authentications = {
        'default': <Authentication>new VoidAuth(),
        'api_key': new ApiKeyAuth('header', 'api_key  */ &#39; &quot; &#x3D;end -- \r\n \n \r'),
        'petstore_auth': new OAuth(),
    }

    constructor(basePath?: string);
    constructor(basePathOrUsername: string, password?: string, basePath?: string) {
        if (password) {
            if (basePath) {
                this.basePath = basePath;
            }
        } else {
            if (basePathOrUsername) {
                this.basePath = basePathOrUsername
            }
        }
    }

    public setApiKey(key: FakeApiApiKeys, value: string) {
        this.authentications[FakeApiApiKeys[key]].apiKey = value;
    }

    set accessToken(token: string) {
        this.authentications.petstore_auth.accessToken = token;
    }
    private extendObj<T1, T2 extends T1>(objA: T2, objB: T2): T1|T2 {
        for(let key in objB){
            if(objB.hasOwnProperty(key)){
            objA[key] = objB[key];
            }
        }
        return objA;
    }

    /**
     * To test code injection *_/ &#39; \&quot; &#x3D;end -- \\r\\n \\n \\r
     * 
     * @param test code inject * &#39; &quot; &#x3D;end  rn n r To test code injection *_/ &#39; \&quot; &#x3D;end -- \\r\\n \\n \\r
     */
    public testCodeInjectEndRnNR (test code inject * &#39; &quot; &#x3D;end  rn n r?: string) : JQueryPromise<{ response: JQueryXHR; body?: any;  }> {
        let localVarPath = this.basePath + '/fake';
        let queryParameters: any = {};
        let headerParams: any = this.extendObj({}, this.defaultHeaders);



        localVarPath = localVarPath + "?" + $.param(queryParameters);


        let reqHasFile = false;
        let reqDict = {};
        let reqFormData = new FormData();
        if (test code inject * &#39; &quot; &#x3D;end  rn n r !== undefined) {
            reqFormData.append('test code inject */ &#39; &quot; &#x3D;end -- \r\n \n \r', test code inject * &#39; &quot; &#x3D;end  rn n r);
            reqDict['test code inject */ &#39; &quot; &#x3D;end -- \r\n \n \r'] = test code inject * &#39; &quot; &#x3D;end  rn n r;
        }


        let requestOptions: JQueryAjaxSettings = {
            url: localVarPath,
            type: 'PUT',
            headers: headerParams,
            processData: false
        };

        if (Object.keys(reqDict).length) {
            requestOptions.data = reqHasFile ? reqFormData : JSON.stringify(reqDict);
            requestOptions.contentType = reqHasFile ? false : 'application/json; charset=utf-8';
        }

        this.authentications.default.applyToRequest(requestOptions);

        let dfd = $.Deferred();
        $.ajax(requestOptions).then(
            (data: any, textStatus: string, jqXHR: JQueryXHR) =>
                dfd.resolve({ response: jqXHR, body: data }),
            (xhr: JQueryXHR, textStatus: string, errorThrown: string) =>
                dfd.reject({ response: xhr, body: errorThrown })
        );
        return dfd.promise();
    }
}
