package io.swagger.codegen.options;

import io.swagger.codegen.CodegenConstants;

import com.google.common.collect.ImmutableMap;
import io.swagger.codegen.languages.Qt5CPPGenerator;

import java.util.Map;

public class Qt5CPPOptionsProvider implements OptionsProvider {
    public static final String SORT_PARAMS_VALUE = "false";
    public static final String ENSURE_UNIQUE_PARAMS_VALUE = "true";
    public static final String ALLOW_UNICODE_IDENTIFIERS_VALUE = "false";
    public static final String CPP_NAMESPACE_VALUE = "Swagger";
    public static final String OPTIONAL_PROJECT_FILE_VALUE = "true";


    @Override
    public String getLanguage() {
        return "qt5cpp";
    }

    @Override
    public Map<String, String> createOptions() {
        ImmutableMap.Builder<String, String> builder = new ImmutableMap.Builder<String, String>();
        return builder.put(CodegenConstants.SORT_PARAMS_BY_REQUIRED_FLAG, SORT_PARAMS_VALUE)
                .put(CodegenConstants.ENSURE_UNIQUE_PARAMS, ENSURE_UNIQUE_PARAMS_VALUE)
                .put(CodegenConstants.ALLOW_UNICODE_IDENTIFIERS, ALLOW_UNICODE_IDENTIFIERS_VALUE)
                .put(Qt5CPPGenerator.CPP_NAMESPACE, CPP_NAMESPACE_VALUE)
                .put(CodegenConstants.OPTIONAL_PROJECT_FILE, OPTIONAL_PROJECT_FILE_VALUE)
                .build();
    }

    @Override
    public boolean isServer() {
        return false;
    }
}
