<?php
/* $Id$ */
/*
	firewall_rules_edit.php
	part of pfSense (http://www.pfsense.com)
        Copyright (C) 2005 Scott Ullrich (sullrich@gmail.com)

	originally part of m0n0wall (http://m0n0.ch/wall)
	Copyright (C) 2003-2004 Manuel Kasper <mk@neon1.net>.
	All rights reserved.

	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions are met:

	1. Redistributions of source code must retain the above copyright notice,
	   this list of conditions and the following disclaimer.

	2. Redistributions in binary form must reproduce the above copyright
	   notice, this list of conditions and the following disclaimer in the
	   documentation and/or other materials provided with the distribution.

	THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
	AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
	OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	POSSIBILITY OF SUCH DAMAGE.
*/
/*
	pfSense_MODULE:	filter
*/

##|+PRIV
##|*IDENT=page-firewall-rules-edit
##|*NAME=Firewall: Rules: Edit page
##|*DESCR=Allow access to the 'Firewall: Rules: Edit' page.
##|*MATCH=firewall_rules_edit.php*
##|-PRIV

require("guiconfig.inc");
require("filter.inc");
require("shaper.inc");

$specialsrcdst = explode(" ", "any pptp pppoe l2tp openvpn");
$ifdisp = get_configured_interface_with_descr();
foreach ($ifdisp as $kif => $kdescr) {
	$specialsrcdst[] = "{$kif}";
	$specialsrcdst[] = "{$kif}ip";
}

if (!is_array($config['filter']['rule'])) {
	$config['filter']['rule'] = array();
}
filter_rules_sort();
$a_filter = &$config['filter']['rule'];

$id = $_GET['id'];
if (is_numeric($_POST['id']))
	$id = $_POST['id'];

$after = $_GET['after'];

if (isset($_POST['after']))
	$after = $_POST['after'];

if (isset($_GET['dup'])) {
	$id = $_GET['dup'];
	$after = $_GET['dup'];
}

if (isset($id) && $a_filter[$id]) {
	$pconfig['interface'] = $a_filter[$id]['interface'];

	if (isset($a_filter[$id]['id']))
		$pconfig['ruleid'] = $a_filter[$id]['id'];

	if (!isset($a_filter[$id]['type']))
		$pconfig['type'] = "pass";
	else
		$pconfig['type'] = $a_filter[$id]['type'];

	if (isset($a_filter[$id]['floating']) || $if == "FloatingRules") {
		$pconfig['floating'] = $a_filter[$id]['floating'];
		if (isset($a_filter[$id]['interface']) && $a_filter[$id]['interface'] <> "") 
			$pconfig['interface'] = $a_filter[$id]['interface'];
	}
	
	if (isset($a_filter['floating'])) 
		$pconfig['floating'] = "yes";

	if (isset($a_filter[$id]['direction']))
                $pconfig['direction'] = $a_filter[$id]['direction'];

	if (isset($a_filter[$id]['protocol']))
		$pconfig['proto'] = $a_filter[$id]['protocol'];
	else
		$pconfig['proto'] = "any";

	if ($a_filter[$id]['protocol'] == "icmp")
		$pconfig['icmptype'] = $a_filter[$id]['icmptype'];

	address_to_pconfig($a_filter[$id]['source'], $pconfig['src'],
		$pconfig['srcmask'], $pconfig['srcnot'],
		$pconfig['srcbeginport'], $pconfig['srcendport']);

	if($a_filter[$id]['os'] <> "")
		$pconfig['os'] = $a_filter[$id]['os'];

	address_to_pconfig($a_filter[$id]['destination'], $pconfig['dst'],
		$pconfig['dstmask'], $pconfig['dstnot'],
		$pconfig['dstbeginport'], $pconfig['dstendport']);

	if ($a_filter[$id]['dscp'] <> "")
		$pconfig['dscp'] = $a_filter[$id]['dscp'];

	$pconfig['disabled'] = isset($a_filter[$id]['disabled']);
	$pconfig['log'] = isset($a_filter[$id]['log']);
	$pconfig['descr'] = $a_filter[$id]['descr'];

	if (isset($a_filter[$id]['tcpflags_any']))
		$pconfig['tcpflags_any'] = true;
	else {
		if (isset($a_filter[$id]['tcpflags1']) && $a_filter[$id]['tcpflags1'] <> "") 
			$pconfig['tcpflags1'] = $a_filter[$id]['tcpflags1'];
		if (isset($a_filter[$id]['tcpflags2']) && $a_filter[$id]['tcpflags2'] <> "") 
			$pconfig['tcpflags2'] = $a_filter[$id]['tcpflags2'];
	}

	if (isset($a_filter[$id]['tag']) && $a_filter[$id]['tag'] <> "") 
		$pconfig['tag'] = $a_filter[$id]['tag'];
	if (isset($a_filter[$id]['tagged']) && $a_filter[$id]['tagged'] <> "")
        	$pconfig['tagged'] = $a_filter[$id]['tagged'];
	if (isset($a_filter[$id]['quick']) && $a_filter[$id]['quick'])
		$pconfig['quick'] = $a_filter[$id]['quick'];
	if (isset($a_filter[$id]['allowopts']))
		$pconfig['allowopts'] = true;
	if (isset($a_filter[$id]['disablereplyto']))
		$pconfig['disablereplyto'] = true;

	/* advanced */
	$pconfig['max'] = $a_filter[$id]['max'];
	$pconfig['max-src-nodes'] = $a_filter[$id]['max-src-nodes'];
	$pconfig['max-src-conn'] = $a_filter[$id]['max-src-conn'];
	$pconfig['max-src-states'] = $a_filter[$id]['max-src-states'];
	$pconfig['statetype'] = $a_filter[$id]['statetype'];
	$pconfig['statetimeout'] = $a_filter[$id]['statetimeout'];

	/* advanced - nosync */
	$pconfig['nosync'] = isset($a_filter[$id]['nosync']);

	/* advanced - new connection per second banning*/
	$pconfig['max-src-conn-rate'] = $a_filter[$id]['max-src-conn-rate'];
	$pconfig['max-src-conn-rates'] = $a_filter[$id]['max-src-conn-rates'];

	/* Multi-WAN next-hop support */
	$pconfig['gateway'] = $a_filter[$id]['gateway'];
	
	/* Shaper support */
	$pconfig['defaultqueue'] = $a_filter[$id]['defaultqueue'];
	$pconfig['ackqueue'] = $a_filter[$id]['ackqueue'];
	$pconfig['dnpipe'] = $a_filter[$id]['dnpipe'];
	$pconfig['pdnpipe'] = $a_filter[$id]['pdnpipe'];
	$pconfig['l7container'] = $a_filter[$id]['l7container'];

	//schedule support
	$pconfig['sched'] = $a_filter[$id]['sched'];
	if (!isset($_GET['dup']))
		$pconfig['associated-rule-id'] = $a_filter[$id]['associated-rule-id'];

} else {
	/* defaults */
	if ($_GET['if'])
		$pconfig['interface'] = $_GET['if'];
	$pconfig['type'] = "pass";
	$pconfig['src'] = "any";
	$pconfig['dst'] = "any";
}
/* Allow the FlotingRules to work */
$if = $pconfig['interface'];

if (isset($_GET['dup']))
	unset($id);

if ($_POST) {

	if( isset($a_filter[$id]['associated-rule-id']) ) {
		$_POST['proto'] = $pconfig['proto'];
		if ($pconfig['proto'] == "icmp")
			$_POST['icmptype'] = $pconfig['icmptype'];
	}

	if ($_POST['type'] == "reject" && $_POST['proto'] <> "tcp")
		$input_errors[] = gettext("Reject type rules only works when the protocol is set to TCP.");

	if ($_POST['type'] == "match" && $_POST['defaultqueue'] == "none")
		$input_errors[] = gettext("Queue type rules only work with queues.");

	if (($_POST['proto'] != "tcp") && ($_POST['proto'] != "udp") && ($_POST['proto'] != "tcp/udp")) {
		$_POST['srcbeginport'] = 0;
		$_POST['srcendport'] = 0;
		$_POST['dstbeginport'] = 0;
		$_POST['dstendport'] = 0;
	} else {

		if ($_POST['srcbeginport_cust'] && !$_POST['srcbeginport'])
			$_POST['srcbeginport'] = $_POST['srcbeginport_cust'];
		if ($_POST['srcendport_cust'] && !$_POST['srcendport'])
			$_POST['srcendport'] = $_POST['srcendport_cust'];

		if ($_POST['srcbeginport'] == "any") {
			$_POST['srcbeginport'] = 0;
			$_POST['srcendport'] = 0;
		} else {
			if (!$_POST['srcendport'])
				$_POST['srcendport'] = $_POST['srcbeginport'];
		}
		if ($_POST['srcendport'] == "any")
			$_POST['srcendport'] = $_POST['srcbeginport'];

		if ($_POST['dstbeginport_cust'] && !$_POST['dstbeginport'])
			$_POST['dstbeginport'] = $_POST['dstbeginport_cust'];
		if ($_POST['dstendport_cust'] && !$_POST['dstendport'])
			$_POST['dstendport'] = $_POST['dstendport_cust'];

		if ($_POST['dstbeginport'] == "any") {
			$_POST['dstbeginport'] = 0;
			$_POST['dstendport'] = 0;
		} else {
			if (!$_POST['dstendport'])
				$_POST['dstendport'] = $_POST['dstbeginport'];
		}
		if ($_POST['dstendport'] == "any")
			$_POST['dstendport'] = $_POST['dstbeginport'];
	}

	if (is_specialnet($_POST['srctype'])) {
		$_POST['src'] = $_POST['srctype'];
		$_POST['srcmask'] = 0;
	} else if ($_POST['srctype'] == "single") {
		$_POST['srcmask'] = 32;
	}
	if (is_specialnet($_POST['dsttype'])) {
		$_POST['dst'] = $_POST['dsttype'];
		$_POST['dstmask'] = 0;
	}  else if ($_POST['dsttype'] == "single") {
		$_POST['dstmask'] = 32;
	}

	unset($input_errors);
	$pconfig = $_POST;

	/* input validation */
	$reqdfields = explode(" ", "type proto");
	if ( isset($a_filter[$id]['associated-rule-id'])===false ) {
		$reqdfields[] = "src";
		$reqdfields[] = "dst";
	}
	$reqdfieldsn = explode(",", "Type,Protocol");
	if ( isset($a_filter[$id]['associated-rule-id'])===false ) {
		$reqdfieldsn[] = "Source";
		$reqdfieldsn[] = "Destination";
	}

	if($_POST['statetype'] == "modulate state" or $_POST['statetype'] == "synproxy state") {
		if( $_POST['proto'] != "tcp" )
			$input_errors[] = sprintf(gettext("%s is only valid with protocol tcp."),$_POST['statetype']);
		if(($_POST['statetype'] == "synproxy state") && ($_POST['gateway'] != ""))
			$input_errors[] = sprintf(gettext("%s is only valid if the gateway is set to 'default'."),$_POST['statetype']);
	}
        
	if ( isset($a_filter[$id]['associated-rule-id'])===false &&
	(!(is_specialnet($_POST['srctype']) || ($_POST['srctype'] == "single"))) ) {
		$reqdfields[] = "srcmask";
		$reqdfieldsn[] = "Source bit count";
	}
	if ( isset($a_filter[$id]['associated-rule-id'])===false &&
	(!(is_specialnet($_POST['dsttype']) || ($_POST['dsttype'] == "single"))) ) {
		$reqdfields[] = "dstmask";
		$reqdfieldsn[] = gettext("Destination bit count");
	}

	do_input_validation($_POST, $reqdfields, $reqdfieldsn, &$input_errors);

	if (!$_POST['srcbeginport']) {
		$_POST['srcbeginport'] = 0;
		$_POST['srcendport'] = 0;
	}
	if (!$_POST['dstbeginport']) {
		$_POST['dstbeginport'] = 0;
		$_POST['dstendport'] = 0;
	}

	if ($_POST['srcbeginport'] && !is_portoralias($_POST['srcbeginport']))
                $input_errors[] = sprintf(gettext("%s is not a valid start source port. It must be a port alias or integer between 1 and 65535."),$_POST['srcbeginposrt']);
        if ($_POST['srcendport'] && !is_portoralias($_POST['srcendport']))
                $input_errors[] = sprintf(gettext("%s  is not a valid end source port. It must be a port alias or integer between 1 and 65535."),$_POST['srcendport']);
        if ($_POST['dstbeginport'] && !is_portoralias($_POST['dstbeginport']))
                $input_errors[] = sprintf(gettext("%s is not a valid start destination port. It must be a port alias or integer between 1 and 65535."),$_POST['dstbeginport']);
        if ($_POST['dstendport'] && !is_portoralias($_POST['dstendport']))
                $input_errors[] = sprintf(gettext("%s is not a valid end destination port. It must be a port alias or integer between 1 and 65535."),$_POST['dstendport']);
	if ( !$_POST['srcbeginport_cust'] && $_POST['srcendport_cust'])
		if (is_alias($_POST['srcendport_cust']))
			$input_errors[] = 'If you put port alias in Source port range to: field you must put the same port alias in from: field';
	if ( $_POST['srcbeginport_cust'] && $_POST['srcendport_cust']){
		if (is_alias($_POST['srcendport_cust']) && is_alias($_POST['srcendport_cust']) && $_POST['srcbeginport_cust'] != $_POST['srcendport_cust'])
			$input_errors[] = 'The same port alias must be used in Source port range from: and to: fields';
		if ((is_alias($_POST['srcbeginport_cust']) && (!is_alias($_POST['srcendport_cust']) && $_POST['srcendport_cust']!='')) || 
		    ((!is_alias($_POST['srcbeginport_cust']) && $_POST['srcbeginport_cust']!='') && is_alias($_POST['srcendport_cust']))) 
			$input_errors[] = 'You cannot specify numbers and port aliases at the same time in Source port range from: and to: field';
	}
	if ( !$_POST['dstbeginport_cust'] && $_POST['dstendport_cust'])
		if (is_alias($_POST['dstendport_cust']))
			$input_errors[] = 'If you put port alias in Destination port range to: field you must put the same port alias in from: field';
	if ( $_POST['dstbeginport_cust'] && $_POST['dstendport_cust']){
		if (is_alias($_POST['dstendport_cust']) && is_alias($_POST['dstendport_cust']) && $_POST['dstbeginport_cust'] != $_POST['dstendport_cust'])
			$input_errors[] = 'The same port alias must be used in Destination port range from: and to: fields';
		if ((is_alias($_POST['dstbeginport_cust']) && (!is_alias($_POST['dstendport_cust']) && $_POST['dstendport_cust']!='')) || 
		    ((!is_alias($_POST['dstbeginport_cust']) && $_POST['dstbeginport_cust']!='') && is_alias($_POST['dstendport_cust']))) 
			$input_errors[] = 'You cannot specify numbers and port aliases at the same time in Destination port range from: and to: field';
	}

	/* if user enters an alias and selects "network" then disallow. */
	if($_POST['srctype'] == "network") {
		if(is_alias($_POST['src']))
			$input_errors[] = gettext("You must specify single host or alias for alias entries.");
	}
	if($_POST['dsttype'] == "network") {
		if(is_alias($_POST['dst']))
			$input_errors[] = gettext("You must specify single host or alias for alias entries.");
	}

	if (!is_specialnet($_POST['srctype'])) {
		if (($_POST['src'] && !is_ipaddroralias($_POST['src']))) {
			$input_errors[] = sprintf(gettext("%s is not a valid source IP address or alias."),$_POST['src']);
		}
		if (($_POST['srcmask'] && !is_numericint($_POST['srcmask']))) {
			$input_errors[] = gettext("A valid source bit count must be specified.");
		}
	}
	if (!is_specialnet($_POST['dsttype'])) {
		if (($_POST['dst'] && !is_ipaddroralias($_POST['dst']))) {
			$input_errors[] = sprintf(gettext("%s is not a valid destination IP address or alias."),$_POST['dst']);
		}
		if (($_POST['dstmask'] && !is_numericint($_POST['dstmask']))) {
			$input_errors[] = gettext("A valid destination bit count must be specified.");
		}
	}

	if ($_POST['srcbeginport'] > $_POST['srcendport']) {
		/* swap */
		$tmp = $_POST['srcendport'];
		$_POST['srcendport'] = $_POST['srcbeginport'];
		$_POST['srcbeginport'] = $tmp;
	}
	if ($_POST['dstbeginport'] > $_POST['dstendport']) {
		/* swap */
		$tmp = $_POST['dstendport'];
		$_POST['dstendport'] = $_POST['dstbeginport'];
		$_POST['dstbeginport'] = $tmp;
	}
	if ($_POST['os'])
		if( $_POST['proto'] != "tcp" )
			$input_errors[] = gettext("OS detection is only valid with protocol tcp.");

	if ($_POST['ackqueue'] && $_POST['ackqueue'] != "none") {
		if ($_POST['defaultqueue'] == "none" )
			$input_errors[] = gettext("You have to select a queue when you select an acknowledge queue too.");
		else if ($_POST['ackqueue'] == $_POST['defaultqueue'])
			$input_errors[] = gettext("Acknowledge queue and Queue cannot be the same.");		
	}
	if (isset($_POST['floating']) && $_POST['pdnpipe'] != "none" && (empty($_POST['direction']) || $_POST['direction'] == "any"))
		$input_errors[] = gettext("You can not use limiters in Floating rules without choosing a direction.");
	if (isset($_POST['floating']) && $_POST['gateway'] != "" && (empty($_POST['direction']) || $_POST['direction'] == "any"))
		$input_errors[] = gettext("You can not use gateways in Floating rules without choosing a direction.");
	if ($_POST['pdnpipe'] && $_POST['pdnpipe'] != "none") {
		if ($_POST['dnpipe'] == "none" )
			$input_errors[] = gettext("You must select a queue for the In direction before selecting one for Out too.");
		else if ($_POST['pdnpipe'] == $_POST['dnpipe'])
			$input_errors[] = gettext("In and Out Queue cannot be the same.");
		else if ($pdnpipe[0] == "?" && $dnpipe[0] <> "?")
			$input_errors[] = gettext("You cannot select one queue and one virtual interface for IN and Out. both must be from the same type.");
		else if ($dnpipe[0] == "?" && $pdnpipe[0] <> "?")			
			$input_errors[] = gettext("You cannot select one queue and one virtual interface for IN and Out. both must be from the same type.");
		if ($_POST['direction'] == "out" && empty($_POST['gateway']))
			$input_errors[] = gettext("Please select a gateway, normaly the interface selected gateway, so the limiters work correctly");
	}
	if( !empty($_POST['ruleid']) && !ctype_digit($_POST['ruleid']))
		$input_errors[] = gettext('ID must be an integer');
	if($_POST['l7container'] && $_POST['l7container'] != "none") {
		if(!($_POST['proto'] == "tcp" || $_POST['proto'] == "udp" || $_POST['proto'] == "tcp/udp"))
			$input_errors[] = gettext("You can only select a layer7 container for TCP and/or UDP protocols");
		if ($_POST['type'] <> "pass")
			$input_errors[] = gettext("You can only select a layer7 container for Pass type rules.");
	}

	if (!$_POST['tcpflags_any']) {
		$settcpflags = array();
		$outoftcpflags = array();
		foreach ($tcpflags as $tcpflag) {
			if ($_POST['tcpflags1_' . $tcpflag] == "on")
				$settcpflags[] = $tcpflag;
			if ($_POST['tcpflags2_' . $tcpflag] == "on")
				$outoftcpflags[] = $tcpflag;
		}
		if (empty($outoftcpflags) && !empty($settcpflags))
			$input_errors[] = gettext("If you specify TCP flags that should be set you should specify out of which flags as well.");
	}

	// Allow extending of the firewall edit page and include custom input validation 
	pfSense_handle_custom_code("/usr/local/pkg/firewall_rules/input_validation");

	if (!$input_errors) {
		$filterent = array();
		$filterent['id'] = $_POST['ruleid']>0?$_POST['ruleid']:'';
		$filterent['type'] = $_POST['type'];
		if (isset($_POST['interface'] ))
			$filterent['interface'] = $_POST['interface'];

		if ($_POST['tcpflags_any']) {
			$filterent['tcpflags_any'] = true;
		} else {
			$settcpflags = array();
			$outoftcpflags = array();
			foreach ($tcpflags as $tcpflag) {
				if ($_POST['tcpflags1_' . $tcpflag] == "on")
					$settcpflags[] = $tcpflag;
				if ($_POST['tcpflags2_' . $tcpflag] == "on")
					$outoftcpflags[] = $tcpflag;
			}
			if (!empty($outoftcpflags)) {
				$filterent['tcpflags2'] = join(",", $outoftcpflags);
				if (!empty($settcpflags))
					$filterent['tcpflags1'] = join(",", $settcpflags);
			}
		}

		if (isset($_POST['tag']))
			$filterent['tag'] = $_POST['tag'];
		if (isset($_POST['tagged']))
			$filterent['tagged'] = $_POST['tagged'];
		if ($if == "FloatingRules" || isset($_POST['floating'])) {
			$filterent['direction'] = $_POST['direction'];
			if (isset($_POST['quick']) && $_POST['quick'] <> "")
				$filterent['quick'] = $_POST['quick'];
			$filterent['floating'] = "yes";
			if (isset($_POST['interface']) && count($_POST['interface']) > 0)  {
				$filterent['interface'] = implode(",", $_POST['interface']);
			}
		}

		/* Advanced options */
		if ($_POST['allowopts'] == "yes")
			$filterent['allowopts'] = true;
		else
			unset($filterent['allowopts']);
		if ($_POST['disablereplyto'] == "yes")
			$filterent['disablereplyto'] = true;
		else
			unset($filterent['disablereplyto']);
		$filterent['max'] = $_POST['max'];
		$filterent['max-src-nodes'] = $_POST['max-src-nodes'];
		$filterent['max-src-conn'] = $_POST['max-src-conn'];
		$filterent['max-src-states'] = $_POST['max-src-states'];
		$filterent['statetimeout'] = $_POST['statetimeout'];
		$filterent['statetype'] = $_POST['statetype'];
		$filterent['os'] = $_POST['os'];

		/* Nosync directive - do not xmlrpc sync this item */
		if($_POST['nosync'] <> "")
			$filterent['nosync'] = true;
		else
			unset($filterent['nosync']);

		/* unless both values are provided, unset the values - ticket #650 */
		if($_POST['max-src-conn-rate'] <> "" and $_POST['max-src-conn-rates'] <> "") {
			$filterent['max-src-conn-rate'] = $_POST['max-src-conn-rate'];
			$filterent['max-src-conn-rates'] = $_POST['max-src-conn-rates'];
		} else {
			unset($filterent['max-src-conn-rate']);
			unset($filterent['max-src-conn-rates']);
		}

		if ($_POST['proto'] != "any")
			$filterent['protocol'] = $_POST['proto'];
		else
			unset($filterent['protocol']);

		if ($_POST['proto'] == "icmp" && $_POST['icmptype'])
			$filterent['icmptype'] = $_POST['icmptype'];
		else
			unset($filterent['icmptype']);

		pconfig_to_address($filterent['source'], $_POST['src'],
			$_POST['srcmask'], $_POST['srcnot'],
			$_POST['srcbeginport'], $_POST['srcendport']);

		pconfig_to_address($filterent['destination'], $_POST['dst'],
			$_POST['dstmask'], $_POST['dstnot'],
			$_POST['dstbeginport'], $_POST['dstendport']);

		if ($_POST['disabled'])
			$filterent['disabled'] = true;
		else
			unset($filterent['disabled']);

		if ($_POST['dscp'])
			$filterent['dscp'] = $_POST['dscp'];

		if ($_POST['log'])
			$filterent['log'] = true;
		else
			unset($filterent['log']);
		strncpy($filterent['descr'], $_POST['descr'], 52);

		if ($_POST['gateway'] != "") {
			$filterent['gateway'] = $_POST['gateway'];
		}
		
		if (isset($_POST['defaultqueue']) && $_POST['defaultqueue'] != "none") {
			$filterent['defaultqueue'] = $_POST['defaultqueue'];
			if (isset($_POST['ackqueue']) && $_POST['ackqueue'] != "none")
				$filterent['ackqueue'] = $_POST['ackqueue'];
		}

		if (isset($_POST['dnpipe']) && $_POST['dnpipe'] != "none") {
			$filterent['dnpipe'] = $_POST['dnpipe'];
			if (isset($_POST['pdnpipe']) && $_POST['pdnpipe'] != "none")
				$filterent['pdnpipe'] = $_POST['pdnpipe'];
		}

		if (isset($_POST['l7container']) && $_POST['l7container'] != "none") {
			$filterent['l7container'] = $_POST['l7container'];
		}
		
		if ($_POST['sched'] != "") {
			$filterent['sched'] = $_POST['sched'];
		}

		// If we have an associated nat rule, make sure the source and destination doesn't change
		if( isset($a_filter[$id]['associated-rule-id']) ) {
			$filterent['interface'] = $a_filter[$id]['interface'];
			if (isset($a_filter[$id]['protocol']))
				$filterent['protocol'] = $a_filter[$id]['protocol'];
			else if (isset($filterent['protocol']))
				unset($filterent['protocol']);
			if ($a_filter[$id]['protocol'] == "icmp" && $a_filter[$id]['icmptype'])
				$filterent['icmptype'] = $a_filter[$id]['icmptype'];
			else if (isset($filterent['icmptype']))
				unset($filterent['icmptype']);
			$filterent['source'] = $a_filter[$id]['source'];
			$filterent['destination'] = $a_filter[$id]['destination'];
			$filterent['associated-rule-id'] = $a_filter[$id]['associated-rule-id'];
		}

		// Allow extending of the firewall edit page and include custom input validation 
		pfSense_handle_custom_code("/usr/local/pkg/firewall_rules/pre_write_config");

		if (isset($id) && $a_filter[$id])
			$a_filter[$id] = $filterent;
		else {
			if (is_numeric($after))
				array_splice($a_filter, $after+1, 0, array($filterent));
			else
				$a_filter[] = $filterent;
		}

		filter_rules_sort();

		write_config();
		mark_subsystem_dirty('filter');

		if (isset($_POST['floating']))
			header("Location: firewall_rules.php?if=FloatingRules");
		else
			header("Location: firewall_rules.php?if=" . htmlspecialchars($_POST['interface']));
		exit;
	}
}

read_altq_config(); /* XXX: */
$qlist =& get_unique_queue_list();
read_dummynet_config(); /* XXX: */
$dnqlist =& get_unique_dnqueue_list();
read_layer7_config();
$l7clist =& get_l7_unique_list();

$pgtitle = array(gettext("Firewall"),gettext("Rules"),gettext("Edit"));
$statusurl = "status_filter_reload.php";
$logurl = "diag_logs_filter.php";

$closehead = false;

$page_filename = "firewall_rules_edit.php";
include("head.inc");

?>
<link rel="stylesheet" href="javascript/chosen/chosen.css" />
</head>

<body link="#0000CC" vlink="#0000CC" alink="#0000CC">
<script src="javascript/chosen/chosen.proto.js" type="text/javascript"></script>
<?php include("fbegin.inc"); ?>
<?php pfSense_handle_custom_code("/usr/local/pkg/firewall_rules/pre_input_errors"); ?>
<?php if ($input_errors) print_input_errors($input_errors); ?>

<form action="firewall_rules_edit.php" method="post" name="iform" id="iform">
<input type='hidden' name="ruleid" value="<?=(isset($pconfig['ruleid'])&&$pconfig['ruleid']>0)?htmlspecialchars($pconfig['ruleid']):''?>">

	<table width="100%" border="0" cellpadding="6" cellspacing="0">
		<tr>
			<td colspan="2" valign="top" class="listtopic"><?=gettext("Edit Firewall rule");?></td>
		</tr>	
<?php
		// Allow extending of the firewall edit page and include custom input validation 
		pfSense_handle_custom_code("/usr/local/pkg/firewall_rules/htmlphpearly");
?>
    	<tr>
			<td width="22%" valign="top" class="vncellreq"><?=gettext("Action");?></td>
			<td width="78%" class="vtable">
				<select name="type" class="formselect">
					<?php $types = explode(" ", "Pass Block Reject"); foreach ($types as $type): ?>
					<option value="<?=strtolower($type);?>" <?php if (strtolower($type) == strtolower($pconfig['type'])) echo "selected"; ?>>
					<?=htmlspecialchars($type);?>
					</option>
					<?php endforeach; ?>
<?php if ($if == "FloatingRules" || isset($pconfig['floating'])): ?>
					<option value="match" <?php if ("match" == strtolower($pconfig['type'])) echo "selected"; ?>>Queue</option>
<?php endif; ?>
				</select>
				<br/>
				<span class="vexpl">
					<?=gettext("Choose what to do with packets that match the criteria specified below.");?> <br/>
					<?=gettext("Hint: the difference between block and reject is that with reject, a packet (TCP RST or ICMP port unreachable for UDP) is returned to the sender, whereas with block the packet is dropped silently. In either case, the original packet is discarded.");?> 
				</span>
			</td>
		</tr>
		<tr>
			<td width="22%" valign="top" class="vncellreq"><?=gettext("Disabled");?></td>
			<td width="78%" class="vtable">
				<input name="disabled" type="checkbox" id="disabled" value="yes" <?php if ($pconfig['disabled']) echo "checked"; ?>>
				<strong><?=gettext("Disable this rule");?></strong><br />
				<span class="vexpl"><?=gettext("Set this option to disable this rule without removing it from the list.");?></span>
			</td>
		</tr>
<?php if ($if == "FloatingRules" || isset($pconfig['floating'])): ?>
		<tr>
			<td width="22%" valign="top" class="vncellreq">
				<?=gettext("Quick");?>
			</td>
			<td width="78%" class="vtable">
				<input name="quick" type="checkbox" id="quick" value="yes" <?php if ($pconfig['quick']) echo "checked=\"checked\""; ?> />
				<strong><?=gettext("Apply the action immediately on match.");?></strong><br />
				<span class="vexpl"><?=gettext("Set this option if you need to apply this action to traffic that matches this rule immediately.");?></span>
			</td>
		</tr>
<?php endif; ?>
<?php $edit_disabled = ""; ?>
<?php if( isset($pconfig['associated-rule-id']) ): ?>
		<tr>
			<td width="22%" valign="top" class="vncell"><?=gettext("Associated filter rule");?></td>
			<td width="78%" class="vtable">
				<span class="red"><strong><?=gettext("Note: ");?></strong></span><?=gettext("This is associated to a NAT rule.");?><br />
				<?=gettext("You cannot edit the interface, protocol, source, or destination of associated filter rules.");?><br />
				<br />
				<?php
					$edit_disabled = "disabled";
					if (is_array($config['nat']['rule'])) {
						foreach( $config['nat']['rule'] as $index => $nat_rule ) {
							if( isset($nat_rule['associated-rule-id']) && $nat_rule['associated-rule-id']==$pconfig['associated-rule-id'] ) {
								echo "<a href=\"firewall_nat_edit.php?id={$index}\">" . gettext("View the NAT rule") . "</a><br>";
								break;
							}
						}
					}
					echo "<input name='associated-rule-id' id='associated-rule-id' type='hidden' value='{$pconfig['associated-rule-id']}' >";
					if (!empty($pconfig['interface']))
						echo "<input name='interface' id='interface' type='hidden' value='{$pconfig['interface']}' >";
				?>
				<script type="text/javascript">
				editenabled = 0;
				</script>
			</td>
		</tr>
<?php endif; ?>
		<tr>
			<td width="22%" valign="top" class="vncellreq"><?=gettext("Interface");?></td>
			<td width="78%" class="vtable">
<?php if ($if == "FloatingRules" || isset($pconfig['floating'])): ?>
				<select name="interface[]" multiple="true" class="formselect" size="3" <?=$edit_disabled;?>>
<?php else: ?>
				<select name="interface" class="formselect" <?=$edit_disabled;?>>
<?php
   endif;
				/* add group interfaces */
				if (is_array($config['ifgroups']['ifgroupentry']))
					foreach($config['ifgroups']['ifgroupentry'] as $ifgen)
						if (have_ruleint_access($ifgen['ifname']))
							$interfaces[$ifgen['ifname']] = $ifgen['ifname'];
				$ifdescs = get_configured_interface_with_descr();
				// Allow extending of the firewall edit page and include custom input validation 
				pfSense_handle_custom_code("/usr/local/pkg/firewall_rules/pre_interfaces_edit");
				foreach ($ifdescs as $ifent => $ifdesc)
        				if(have_ruleint_access($ifent))
							$interfaces[$ifent] = $ifdesc;
					if ($config['l2tp']['mode'] == "server")
						if(have_ruleint_access("l2tp"))
							$interfaces['l2tp'] = "L2TP VPN";
					if ($config['pptpd']['mode'] == "server")
						if(have_ruleint_access("pptp")) 
							$interfaces['pptp'] = "PPTP VPN";
					
					if (is_pppoe_server_enabled() && have_ruleint_access("pppoe"))
						$interfaces['pppoe'] = "PPPoE VPN";
					/* add ipsec interfaces */
					if (isset($config['ipsec']['enable']) || isset($config['ipsec']['client']['enable']))
						if(have_ruleint_access("enc0")) 
							$interfaces["enc0"] = "IPsec";
					/* add openvpn/tun interfaces */
					if  ($config['openvpn']["openvpn-server"] || $config['openvpn']["openvpn-client"])
						$interfaces["openvpn"] = "OpenVPN";
					if (is_array($pconfig['interface']))
						$pconfig['interface'] = implode(",", $pconfig['interface']);
					$selected_interfaces = explode(",", $pconfig['interface']);
					foreach ($interfaces as $iface => $ifacename): ?>
						<option value="<?=$iface;?>" <?php if ($pconfig['interface'] <> "" && ( strcasecmp($pconfig['interface'], $iface) == 0 || in_array($iface, $selected_interfaces) )) echo "selected"; ?>><?=$ifacename?></option>
<?php 				endforeach; ?>
				</select>
				<br />
				<span class="vexpl"><?=gettext("Choose on which interface packets must come in to match this rule.");?></span>
			</td>
		</tr>
<?php if ($if == "FloatingRules" || isset($pconfig['floating'])): ?>
		<tr>
			<td width="22%" valign="top" class="vncellreq">
				<?=gettext("Direction");?>
			</td>
			<td width="78%" class="vtable">
				<select name="direction" class="formselect">
					<?php      $directions = array('any','in','out');
				foreach ($directions as $direction): ?>
				<option value="<?=$direction;?>"
					<?php if ($direction == $pconfig['direction']): ?>
						selected="selected" 
					<?php endif; ?>
					><?=$direction;?></option>
				<?php endforeach; ?>      
				</select>
				<input type="hidden" id="floating" name="floating" value="floating">
			</td>
		<tr>
<?php endif; ?>
		<tr>
			<td width="22%" valign="top" class="vncellreq"><?=gettext("Protocol");?></td>
			<td width="78%" class="vtable">
				<select <?=$edit_disabled;?> name="proto" class="formselect" onchange="proto_change()">
<?php
				$protocols = explode(" ", "TCP UDP TCP/UDP ICMP ESP AH GRE IGMP OSPF any carp pfsync");
				foreach ($protocols as $proto): ?>
					<option value="<?=strtolower($proto);?>" <?php if (strtolower($proto) == $pconfig['proto']) echo "selected"; ?>><?=htmlspecialchars($proto);?></option>
<?php 			endforeach; ?>
				</select>
				<br />
				<span class="vexpl"><?=gettext("Choose which IP protocol this rule should match.");?> <br /> <?=gettext("Hint: in most cases, you should specify ");?><em>TCP</em> &nbsp;<?=gettext("here.");?></span>
			</td>
		</tr>
		<tr id="icmpbox" name="icmpbox">
			<td valign="top" class="vncell"><?=gettext("ICMP type");?></td>
			<td class="vtable">
				<select <?=$edit_disabled;?> name="icmptype" class="formselect">
<?php
				$icmptypes = array(
				"" => gettext("any"),
				"echoreq" => gettext("Echo request"),
				"echorep" => gettext("Echo reply"),
				"unreach" => gettext("Destination unreachable"),
				"squench" => gettext("Source quench"),
				"redir" => gettext("Redirect"),
				"althost" => gettext("Alternate Host"),
				"routeradv" => gettext("Router advertisement"),
				"routersol" => gettext("Router solicitation"),
				"timex" => gettext("Time exceeded"),
				"paramprob" => gettext("Invalid IP header"),
				"timereq" => gettext("Timestamp"),
				"timerep" => gettext("Timestamp reply"),
				"inforeq" => gettext("Information request"),
				"inforep" => gettext("Information reply"),
				"maskreq" => gettext("Address mask request"),
				"maskrep" => gettext("Address mask reply")
				);

				foreach ($icmptypes as $icmptype => $descr): ?>
					<option value="<?=$icmptype;?>" <?php if ($icmptype == $pconfig['icmptype']) echo "selected"; ?>><?=htmlspecialchars($descr);?></option>
<?php 			endforeach; ?>
			</select>
			<br />
			<span class="vexpl"><?=gettext("If you selected ICMP for the protocol above, you may specify an ICMP type here.");?></span>
		</td>
		</tr>
		<tr>
			<td width="22%" valign="top" class="vncellreq"><?=gettext("Source");?></td>
			<td width="78%" class="vtable">
				<input <?=$edit_disabled;?> name="srcnot" type="checkbox" id="srcnot" value="yes" <?php if ($pconfig['srcnot']) echo "checked"; ?>>
				<strong><?=gettext("not");?></strong>
				<br />
				<?=gettext("Use this option to invert the sense of the match.");?>
				<br />
				<br />
				<table border="0" cellspacing="0" cellpadding="0">
					<tr>
						<td><?=gettext("Type:");?>&nbsp;&nbsp;</td>
						<td>
							<select <?=$edit_disabled;?> name="srctype" class="formselect" onChange="typesel_change()">
<?php
								$sel = is_specialnet($pconfig['src']); ?>
								<option value="any"     <?php if ($pconfig['src'] == "any") { echo "selected"; } ?>><?=gettext("any");?></option>
								<option value="single"  <?php if (($pconfig['srcmask'] == 32) && !$sel) { echo "selected"; $sel = 1; } ?>><?=gettext("Single host or alias");?></option>
								<option value="network" <?php if (!$sel) echo "selected"; ?>><?=gettext("Network");?></option>
								<?php if(have_ruleint_access("pptp")): ?>
								<option value="pptp"    <?php if ($pconfig['src'] == "pptp") { echo "selected"; } ?>><?=gettext("PPTP clients");?></option>
								<?php endif; ?>
								<?php if(have_ruleint_access("pppoe")): ?>
								<option value="pppoe"   <?php if ($pconfig['src'] == "pppoe") { echo "selected"; } ?>><?=gettext("PPPoE clients");?></option>
								<?php endif; ?>								
								 <?php if(have_ruleint_access("l2tp")): ?>
                                                                <option value="l2tp"   <?php if ($pconfig['src'] == "l2tp") { echo "selected"; } ?>><?=gettext("L2TP clients");?></option>
                                                                <?php endif; ?>
<?php
								foreach ($ifdisp as $ifent => $ifdesc): ?>
								<?php if(have_ruleint_access($ifent)): ?>
									<option value="<?=$ifent;?>" <?php if ($pconfig['src'] == $ifent) { echo "selected"; } ?>><?=htmlspecialchars($ifdesc);?><?=gettext(" subnet");?></option>
									<option value="<?=$ifent;?>ip"<?php if ($pconfig['src'] ==  $ifent . "ip") { echo "selected"; } ?>>
										<?=$ifdesc?> <?=gettext("address");?>
									</option>
								<?php endif; ?>
<?php 							endforeach; ?>
							</select>
						</td>
					</tr>
					<tr>
						<td><?=gettext("Address:");?>&nbsp;&nbsp;</td>
						<td>
							<input <?=$edit_disabled;?> autocomplete='off' name="src" type="text" class="formfldalias" id="src" size="20" value="<?php if (!is_specialnet($pconfig['src'])) echo htmlspecialchars($pconfig['src']);?>"> /
							<select <?=$edit_disabled;?> name="srcmask" class="formselect" id="srcmask">
<?php						for ($i = 31; $i > 0; $i--): ?>
								<option value="<?=$i;?>" <?php if ($i == $pconfig['srcmask']) echo "selected"; ?>><?=$i;?></option>
<?php 						endfor; ?>
							</select>
						</td>
					</tr>
				</table>
				<div id="showadvancedboxspr">
					<p>
					<input <?=$edit_disabled;?> type="button" onClick="show_source_port_range()" value="<?=gettext("Advanced"); ?>"></input> - <?=gettext("Show source port range");?></a>
				</div>
			</td>
		</tr>
		<tr style="display:none" id="sprtable" name="sprtable">
			<td width="22%" valign="top" class="vncellreq"><?=gettext("Source port range");?></td>
			<td width="78%" class="vtable">
				<table border="0" cellspacing="0" cellpadding="0">
					<tr>
						<td><?=gettext("from:");?>&nbsp;&nbsp;</td>
						<td>
							<select <?=$edit_disabled;?> name="srcbeginport" class="formselect" onchange="src_rep_change();ext_change()">
								<option value="">(<?=gettext("other"); ?>)</option>
								<option value="any" <?php $bfound = 0; if ($pconfig['srcbeginport'] == "any") { echo "selected"; $bfound = 1; } ?>><?=gettext("any");?></option>
<?php 							foreach ($wkports as $wkport => $wkportdesc): ?>
									<option value="<?=$wkport;?>" <?php if ($wkport == $pconfig['srcbeginport']) { echo "selected"; $bfound = 1; } ?>><?=htmlspecialchars($wkportdesc);?></option>
<?php 							endforeach; ?>
							</select>
							<input <?=$edit_disabled;?> autocomplete='off' class="formfldalias" name="srcbeginport_cust" id="srcbeginport_cust" type="text" size="5" value="<?php if (!$bfound && $pconfig['srcbeginport']) echo htmlspecialchars($pconfig['srcbeginport']); ?>">
						</td>
					</tr>
					<tr>
						<td><?=gettext("to:");?></td>
						<td>
							<select <?=$edit_disabled;?> name="srcendport" class="formselect" onchange="ext_change()">
								<option value="">(<?=gettext("other"); ?>)</option>
								<option value="any" <?php $bfound = 0; if ($pconfig['srcendport'] == "any") { echo "selected"; $bfound = 1; } ?>><?=gettext("any");?></option>
<?php							foreach ($wkports as $wkport => $wkportdesc): ?>
									<option value="<?=$wkport;?>" <?php if ($wkport == $pconfig['srcendport']) { echo "selected"; $bfound = 1; } ?>><?=htmlspecialchars($wkportdesc);?></option>
<?php							endforeach; ?>
							</select>
							<input <?=$edit_disabled;?> autocomplete='off' class="formfldalias" name="srcendport_cust" id="srcendport_cust" type="text" size="5" value="<?php if (!$bfound && $pconfig['srcendport']) echo htmlspecialchars($pconfig['srcendport']); ?>">
						</td>
					</tr>
				</table>
				<br />
				<span class="vexpl"><?=gettext("Specify the source port or port range for this rule."); ?> <b><?=gettext("This is usually"); ?> <em><?=gettext("random"); ?></em> <?=gettext("and almost never equal to the destination port range (and should usually be"); ?> &quot;<?=gettext("any"); ?>&quot;).</b><br /><?=gettext("Hint: you can leave the"); ?> <em><?=gettext("'to'"); ?></em> <?=gettext("field empty if you only want to filter a single port.");?></span><br/>
			</td>
		</tr>
		<tr>
			<td width="22%" valign="top" class="vncellreq"><?=gettext("Destination");?></td>
			<td width="78%" class="vtable">
				<input <?=$edit_disabled;?> name="dstnot" type="checkbox" id="dstnot" value="yes" <?php if ($pconfig['dstnot']) echo "checked"; ?>>
				<strong><?=gettext("not");?></strong>
					<br />
				<?=gettext("Use this option to invert the sense of the match.");?>
					<br />
					<br />
				<table border="0" cellspacing="0" cellpadding="0">
					<tr>
						<td><?=gettext("Type:");?>&nbsp;&nbsp;</td>
						<td>
							<select <?=$edit_disabled;?> name="dsttype" class="formselect" onChange="typesel_change()">
<?php
								$sel = is_specialnet($pconfig['dst']); ?>
								<option value="any" <?php if ($pconfig['dst'] == "any") { echo "selected"; } ?>><?=gettext("any");?></option>
								<option value="single" <?php if (($pconfig['dstmask'] == 32) && !$sel) { echo "selected"; $sel = 1; } ?>><?=gettext("Single host or alias");?></option>
								<option value="network" <?php if (!$sel) echo "selected"; ?>><?=gettext("Network");?></option>
								<?php if(have_ruleint_access("pptp")): ?>
								<option value="pptp" <?php if ($pconfig['dst'] == "pptp") { echo "selected"; } ?>><?=gettext("PPTP clients");?></option>
								<?php endif; ?>
								<?php if(have_ruleint_access("pppoe")): ?>
								<option value="pppoe" <?php if ($pconfig['dst'] == "pppoe") { echo "selected"; } ?>><?=gettext("PPPoE clients");?></option>
								<?php endif; ?>								
								<?php if(have_ruleint_access("l2tp")): ?>
                                                                <option value="l2tp" <?php if ($pconfig['dst'] == "l2tp") { echo "selected"; } ?>><?=gettext("L2TP clients");?></option>
                                                                <?php endif; ?>

<?php 							foreach ($ifdisp as $if => $ifdesc): ?>
								<?php if(have_ruleint_access($if)): ?>
									<option value="<?=$if;?>" <?php if ($pconfig['dst'] == $if) { echo "selected"; } ?>><?=htmlspecialchars($ifdesc);?> <?=gettext("subnet");?></option>
									<option value="<?=$if;?>ip"<?php if ($pconfig['dst'] == $if . "ip") { echo "selected"; } ?>>
										<?=$ifdesc;?> <?=gettext("address");?>
									</option>
								<?php endif; ?>
<?php 							endforeach; ?>
							</select>
						</td>
					</tr>
					<tr>
						<td><?=gettext("Address:");?>&nbsp;&nbsp;</td>
						<td>
							<input <?=$edit_disabled;?> autocomplete='off' name="dst" type="text" class="formfldalias" id="dst" size="20" value="<?php if (!is_specialnet($pconfig['dst'])) echo htmlspecialchars($pconfig['dst']);?>">
							/
							<select <?=$edit_disabled;?> name="dstmask" class="formselect" id="dstmask">
<?php
							for ($i = 31; $i > 0; $i--): ?>
								<option value="<?=$i;?>" <?php if ($i == $pconfig['dstmask']) echo "selected"; ?>><?=$i;?></option>
<?php						endfor; ?>
							</select>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr id="dprtr" name="dprtr">
			<td width="22%" valign="top" class="vncellreq"><?=gettext("Destination port range ");?></td>
			<td width="78%" class="vtable">
				<table border="0" cellspacing="0" cellpadding="0">
					<tr>
						<td><?=gettext("from:");?>&nbsp;&nbsp;</td>
						<td>
							<select <?=$edit_disabled;?> name="dstbeginport" class="formselect" onchange="dst_rep_change();ext_change()">
								<option value="">(<?=gettext("other"); ?>)</option>
								<option value="any" <?php $bfound = 0; if ($pconfig['dstbeginport'] == "any") { echo "selected"; $bfound = 1; } ?>><?=gettext("any");?></option>
<?php 							foreach ($wkports as $wkport => $wkportdesc): ?>
									<option value="<?=$wkport;?>" <?php if ($wkport == $pconfig['dstbeginport']) { echo "selected"; $bfound = 1; }?>><?=htmlspecialchars($wkportdesc);?></option>
<?php 							endforeach; ?>
							</select>
							<input <?=$edit_disabled;?> autocomplete='off' class="formfldalias" name="dstbeginport_cust" id="dstbeginport_cust" type="text" size="5" value="<?php if (!$bfound && $pconfig['dstbeginport']) echo htmlspecialchars($pconfig['dstbeginport']); ?>">
						</td>
					</tr>
					<tr>
						<td><?=gettext("to:");?></td>
						<td>
							<select <?=$edit_disabled;?> name="dstendport" class="formselect" onchange="ext_change()">
								<option value="">(<?=gettext("other"); ?>)</option>
								<option value="any" <?php $bfound = 0; if ($pconfig['dstendport'] == "any") { echo "selected"; $bfound = 1; } ?>><?=gettext("any");?></option>
<?php							foreach ($wkports as $wkport => $wkportdesc): ?>
									<option value="<?=$wkport;?>" <?php if ($wkport == $pconfig['dstendport']) { echo "selected"; $bfound = 1; } ?>><?=htmlspecialchars($wkportdesc);?></option>
<?php 							endforeach; ?>
							</select>
								<input <?=$edit_disabled;?> autocomplete='off' class="formfldalias" name="dstendport_cust" id="dstendport_cust" type="text" size="5" value="<?php if (!$bfound && $pconfig['dstendport']) echo htmlspecialchars($pconfig['dstendport']); ?>">
						</td>
					</tr>
				</table>
				<br />
				<span class="vexpl">
					<?=gettext("Specify the port or port range for the destination of the packet for this rule.");?>
					<br />
					<?=gettext("Hint: you can leave the"); ?> <em><?=gettext("'to'"); ?></em> <?=gettext("field empty if you only want to filter a single port");?>
				</span>
			</td>
		</tr>
		<tr>
			<td width="22%" valign="top" class="vncellreq"><?=gettext("Log");?></td>
			<td width="78%" class="vtable">
				<input name="log" type="checkbox" id="log" value="yes" <?php if ($pconfig['log']) echo "checked"; ?>>
				<strong><?=gettext("Log packets that are handled by this rule");?></strong>
				<br />
				<span class="vexpl"><?=gettext("Hint: the firewall has limited local log space. Don't turn on logging for everything. If you want to do a lot of logging, consider using a remote syslog server"); ?> (<?=gettext("see the"); ?> <a href="diag_logs_settings.php"><?=gettext("Diagnostics: System logs: Settings"); ?></a> <?=gettext("page"); ?>).</span>
			</td>
		</tr>
		<tr>
			<td width="22%" valign="top" class="vncell"><?=gettext("Description");?></td>
			<td width="78%" class="vtable">
				<input name="descr" type="text" class="formfld unknown" id="descr" size="52" maxlength="52" value="<?=htmlspecialchars($pconfig['descr']);?>">
				<br />
				<span class="vexpl"><?=gettext("You may enter a description here for your reference.");?></span>
			</td>
		</tr>
<?php		if (!isset($id) || !($a_filter[$id] && firewall_check_for_advanced_options($a_filter[$id]) <> "")): ?>
		<tr>
			<td width="22%" valign="top">&nbsp;</td>
			<td width="78%">
				&nbsp;<br>&nbsp;
				<input name="Submit" type="submit" class="formbtn" value="<?=gettext("Save"); ?>">  <input type="button" class="formbtn" value="<?=gettext("Cancel"); ?>" onclick="history.back()">
<?php			if (isset($id) && $a_filter[$id]): ?>
					<input name="id" type="hidden" value="<?=htmlspecialchars($id);?>">
<?php 			endif; ?>
				<input name="after" type="hidden" value="<?=htmlspecialchars($after);?>">
			</td>
		</tr>
<?php		endif; ?>
		<tr>
			<td>&nbsp;</td>
		</tr>
		<tr>
			<td colspan="2" valign="top" class="listtopic"><?=gettext("Advanced features");?></td>
		</tr>	
		<tr>
			<td width="22%" valign="top" class="vncell"><?=gettext("Source OS");?></td>
			<td width="78%" class="vtable">
				<div id="showadvsourceosbox" <?php if ($pconfig['os']) echo "style='display:none'"; ?>>
					<input type="button" onClick="show_advanced_sourceos()" value="<?=gettext("Advanced"); ?>"></input> - <?=gettext("Show advanced option");?></a>
				</div>
				<div id="showsourceosadv" <?php if (empty($pconfig['os'])) echo "style='display:none'"; ?>>
					<?=gettext("OS Type:");?>&nbsp;
					<select name="os" id="os" class="formselect">
<?php
						$ostypes = array(
							 "" => gettext("any"),
							"AIX" => "AIX",
							"Linux" => "Linux",
							"FreeBSD" => "FreeBSD",
							"NetBSD" => "NetBSD",
							"OpenBSD" => "OpenBSD",
							"Solaris" => "Solaris",
							"MacOS" => "MacOS",
							"Windows" => "Windows",
							"Novell" => "Novell",
							"NMAP" => "NMAP"
			           );
						foreach ($ostypes as $ostype => $descr): ?>
							<option value="<?=$ostype;?>" <?php if ($ostype == $pconfig['os']) echo "selected"; ?>><?=htmlspecialchars($descr);?></option>
<?php
					endforeach; 
?>
					</select>
					<br />
					<?=gettext("Note: this only works for TCP rules");?>
				</div>
			</td>
		</tr>
		<tr>
			<td width="22%" valign="top" class="vncell"><?=gettext("Diffserv Code Point");?></td>
			<td width="78%" class="vtable">
				<div id="dsadv" name="dsadv" <?php if ($pconfig['dscp']) echo "style='display:none'"; ?>>
					<input type="button" onClick="show_dsdiv();" value="<?=gettext("Advanced"); ?>"> - <?=gettext("Show advanced option");?>
				</div>
				<div id="dsdivmain" name="dsdivmain" <?php if (empty($pconfig['dscp'])) echo "style='display:none'"; ?>>
					<select name="dscp" id="dscp">
						<option value=""></option>
						<?php foreach($firewall_rules_dscp_types as $frdt): ?>
							<option value="<?=$frdt?>"<?php if($pconfig['dscp'] == $frdt) echo " SELECTED"; ?>><?=$frdt?></option>
						<?php endforeach; ?>
					</select>
				</div>
			</td>
		</tr>
		<tr>
			<td width="22%" valign="top" class="vncell"><?=gettext("Advanced Options");?></td>
			<td width="78%" class="vtable">
			<div id="aoadv" name="aoadv">
				<input type="button" onClick="show_aodiv();" value="<?=gettext("Advanced"); ?>"> - <?=gettext("Show advanced option");?>
			</div>
			<div id="aodivmain" name="aodivmain" style="display:none">
				<input type="checkbox" id="allowopts" value="yes" name="allowopts"<?php if($pconfig['allowopts'] == true) echo " checked"; ?>>
				<br/><span class="vexpl"><?=gettext("This allows packets with IP options to pass. Otherwise they are blocked by default. This is usually only seen with multicast traffic.");?>
				</span><p>
				<input type="checkbox" id="disablereplyto" value="yes" name="disablereplyto"<?php if($pconfig['disablereplyto'] == true) echo " checked"; ?>>
				<br/><span class="vexpl"><?=gettext("This will disable auto generated reply-to for this rule.");?>
				</span><p>
				<input name="tag" id="tag" value="<?=htmlspecialchars($pconfig['tag']);?>">
				<br /><span class="vexpl"><?=gettext("You can mark a packet matching this rule and use this mark to match on other NAT/filter rules. It is called"); ?> <b><?=gettext("Policy filtering"); ?></b>
				</span><p>
				<input name="tagged" id="tagged" value="<?=htmlspecialchars($pconfig['tagged']);?>">
				<br /><span class="vexpl"><?=gettext("You can match packet on a mark placed before on another rule.")?>
				</span> <p>
				<input name="max" id="max" value="<?php echo htmlspecialchars($pconfig['max']) ?>"><br><?=gettext(" Maximum state entries this rule can create");?></p><p>
				<input name="max-src-nodes" id="max-src-nodes" value="<?php echo htmlspecialchars($pconfig['max-src-nodes']) ?>"><br><?=gettext(" Maximum number of unique source hosts");?></p><p>
				<input name="max-src-conn" id="max-src-conn" value="<?php echo htmlspecialchars($pconfig['max-src-conn']) ?>"><br><?=gettext(" Maximum number of established connections per host");?></p><p>
				<input name="max-src-states" id="max-src-states" value="<?php echo htmlspecialchars($pconfig['max-src-states']) ?>"><br><?=gettext(" Maximum state entries per host");?></p><p>
				<input name="max-src-conn-rate" id="max-src-conn-rate" value="<?php echo htmlspecialchars($pconfig['max-src-conn-rate']) ?>"> /
				<select name="max-src-conn-rates" id="max-src-conn-rates">
					<option value=""<?php if(intval($pconfig['max-src-conn-rates']) < 1) echo " selected"; ?>></option>
<?php				for($x=1; $x<255; $x++) {
						if($x == $pconfig['max-src-conn-rates']) $selected = " selected"; else $selected = "";
						echo "<option value=\"{$x}\"{$selected}>{$x}</option>\n";
					} ?>
				</select><br />
				<?=gettext("Maximum new connections / per second(s)");?>
				</p><p>

				<input name="statetimeout" value="<?php echo htmlspecialchars($pconfig['statetimeout']) ?>"><br>
				<?=gettext("State Timeout in seconds");?>
				</p>

				<p><strong><?=gettext("Note: Leave fields blank to disable that feature.");?></strong></p>
			  </div>
			</td>
		</tr>
		<tr id="tcpflags" name="tcpflags"> 
			<td width="22%" valign="top" class="vncell"><?=gettext("TCP flags");?></td>
			<td width="78%" class="vtable">
			<div id="showtcpflagsbox" <?php if ($pconfig['tcpflags_any'] || $pconfig['tcpflags1'] || $pconfig['tcpflags2']) echo "style='display:none'"; ?>>
                        	<input type="button" onClick="show_advanced_tcpflags()" value="<?=gettext("Advanced"); ?>"></input> - <?=gettext("Show advanced option");?></a>
                        </div>
                        <div id="showtcpflagsadv" <?php if (empty($pconfig['tcpflags_any']) && empty($pconfig['tcpflags1']) && empty($pconfig['tcpflags2'])) echo "style='display:none'"; ?>>
			<div id="tcpheader" name="tcpheader">
			<center>
			<table border="0" cellspacing="0" cellpadding="0">
			<?php 
				$setflags = explode(",", $pconfig['tcpflags1']);
				$outofflags = explode(",", $pconfig['tcpflags2']);
				$header = "<td width='40' nowrap></td>";
				$tcpflags1 = "<td width='40' nowrap>set</td>";
				$tcpflags2 = "<td width='40' nowrap>out of</td>";
				foreach ($tcpflags as $tcpflag) {
					$header .= "<td  width='40' nowrap><strong>" . strtoupper($tcpflag) . "</strong></td>\n";
					$tcpflags1 .= "<td  width='40' nowrap> <input type='checkbox' name='tcpflags1_{$tcpflag}' value='on' ";
					if (array_search($tcpflag, $setflags) !== false)
						$tcpflags1 .= "checked";
					$tcpflags1 .= "></td>\n";
					$tcpflags2 .= "<td  width='40' nowrap> <input type='checkbox' name='tcpflags2_{$tcpflag}' value='on' ";
					if (array_search($tcpflag, $outofflags) !== false)
						$tcpflags2 .= "checked";
					$tcpflags2 .= "></td>\n";
				}
				echo "<tr id='tcpheader' name='tcpheader'>{$header}</tr>\n";
				echo "<tr id='tcpflags1' name='tcpflags1'>{$tcpflags1}</tr>\n";
				echo "<tr id='tcpflags2' name='tcpflags2'>{$tcpflags2}</tr>\n";
			?>
			</table>
			<center>
			</div>
			<br/><center>
			<input onClick='tcpflags_anyclick(this);' type='checkbox' name='tcpflags_any' value='on' <?php if ($pconfig['tcpflags_any']) echo "checked"; ?>><strong><?=gettext("Any flags.");?></strong><br/></center>
			<br/>
			<span class="vexpl"><?=gettext("Use this to choose TCP flags that must ". 
			"be set or cleared for this rule to match.");?></span>
			</div>
			</td>
		</tr>
		<tr>
			<td width="22%" valign="top" class="vncell"><?=gettext("State Type");?></td>
			<td width="78%" class="vtable">
				<div id="showadvstatebox" <?php if (!empty($pconfig['statetype']) && $pconfig['statetype'] != "keep state") echo "style='display:none'"; ?>>
					<input type="button" onClick="show_advanced_state()" value="<?=gettext("Advanced"); ?>"></input> - <?=gettext("Show advanced option");?></a>
				</div>
				<div id="showstateadv" <?php if (empty($pconfig['statetype']) || $pconfig['statetype'] == "keep state") echo "style='display:none'"; ?>>
					<select name="statetype">
						<option value="keep state" <?php if(!isset($pconfig['statetype']) or $pconfig['statetype'] == "keep state") echo "selected"; ?>><?=gettext("keep state");?></option>
						<option value="sloppy state" <?php if($pconfig['statetype'] == "sloppy state") echo "selected"; ?>><?=gettext("sloppy state");?></option>
						<option value="synproxy state"<?php if($pconfig['statetype'] == "synproxy state")  echo "selected"; ?>><?=gettext("synproxy state");?></option>
						<option value="none"<?php if($pconfig['statetype'] == "none") echo "selected"; ?>><?=gettext("none");?></option>
					</select><br><?=gettext("Hint: Select which type of state tracking mechanism you would like to use.  If in doubt, use keep state.");?>
					<p>
					<table width="90%">
						<tr><td width="25%"><ul><li><?=gettext("keep state");?></li></ul></td><td><?=gettext("Works with all IP protocols.");?></td></tr>
						<tr><td width="25%"><ul><li><?=gettext("sloppy state");?></li></ul></td><td><?=gettext("Works with all IP protocols.");?></td></tr>
						<tr><td width="25%"><ul><li><?=gettext("synproxy state");?></li></ul></td><td><?=gettext("Proxies incoming TCP connections to help protect servers from spoofed TCP SYN floods. This option includes the functionality of keep state and modulate state combined.");?></td></tr>
						<tr><td width="25%"><ul><li><?=gettext("none");?></li></ul></td><td><?=gettext("Do not use state mechanisms to keep track.  This is only useful if you're doing advanced queueing in certain situations.  Please check the documentation.");?></td></tr>
					</table>
					</p>
			  </div>
			</td>
		</tr>
		<tr>
			<td width="22%" valign="top" class="vncell"><?=gettext("No XMLRPC Sync");?></td>
			<td width="78%" class="vtable">
				<div id="showadvnoxmlrpcsyncbox" <?php if ($pconfig['nosync']) echo "style='display:none'"; ?>>
					<input type="button" onClick="show_advanced_noxmlrpc()" value="<?=gettext("Advanced"); ?>"></input> - <?=gettext("Show advanced option");?></a>
				</div>
				<div id="shownoxmlrpcadv" <?php if (empty($pconfig['nosync'])) echo "style='display:none'"; ?>>
					<input type="checkbox" name="nosync"<?php if($pconfig['nosync']) echo " CHECKED"; ?>><br>
					<?=gettext("Hint: This prevents the rule from automatically syncing to other CARP members.");?>
				</div>
			</td>
		</tr>
		<?php
			//build list of schedules
			$schedules = array();
			$schedules[] = "none";//leave none to leave rule enabled all the time
			if(is_array($config['schedules']['schedule'])) {
				foreach ($config['schedules']['schedule'] as $schedule) {
					if ($schedule['name'] <> "")
						$schedules[] = $schedule['name'];
				}
			}
		?>
		<tr>
			<td width="22%" valign="top" class="vncell"><?=gettext("Schedule");?></td>
			<td width="78%" class="vtable">
				<div id="showadvschedulebox" <?php if (!empty($pconfig['sched'])) echo "style='display:none'"; ?>>
					<input type="button" onClick="show_advanced_schedule()" value="<?=gettext("Advanced"); ?>"></input> - <?=gettext("Show advanced option");?></a>
				</div>
				<div id="showscheduleadv" <?php if (empty($pconfig['sched'])) echo "style='display:none'"; ?>>
					<select name='sched'>
<?php
					foreach($schedules as $schedule) {
						if($schedule == $pconfig['sched']) {
							$selected = " SELECTED";
						} else {
							$selected = "";
						}
						if ($schedule == "none") {
							echo "<option value=\"\" {$selected}>{$schedule}</option>\n";
						} else {
							echo "<option value=\"{$schedule}\" {$selected}>{$schedule}</option>\n";
						}
					}
?>
					</select>
					<p><?=gettext("Leave as 'none' to leave the rule enabled all the time.");?></p>
				</div>
			</td>
		</tr>
		<tr>
			<td width="22%" valign="top" class="vncell"><?=gettext("Gateway");?></td>
			<td width="78%" class="vtable">
				<div id="showadvgatewaybox" <?php if (!empty($pconfig['gateway'])) echo "style='display:none'"; ?>>
					<input type="button" onClick="show_advanced_gateway()" value="<?=gettext("Advanced"); ?>"></input> - <?=gettext("Show advanced option");?></a>
				</div>
				<div id="showgatewayadv" <?php if (empty($pconfig['gateway'])) echo "style='display:none'"; ?>>
					<select name='gateway'>
					<option value="" ><?=gettext("default");?></option>
<?php
					/* build a list of gateways */
					$gateways = return_gateways_array();
					// add statically configured gateways to list
					foreach($gateways as $gwname => $gw) {
						if($gw == "") 
							continue;
						if($gwname == $pconfig['gateway']) {
							$selected = " SELECTED";
						} else {
							$selected = "";
						}
						echo "<option value=\"{$gwname}\" {$selected}>{$gw['name']} - {$gw['gateway']}</option>\n";
					}
					/* add gateway groups to the list */
					if (is_array($config['gateways']['gateway_group'])) {
						foreach($config['gateways']['gateway_group'] as $gw_group) {
							if($gw_group['name'] == "")
								continue;
							if($pconfig['gateway'] == $gw_group['name']) {
								echo "<option value=\"{$gw_group['name']}\" SELECTED>{$gw_group['name']}</option>\n";
							} else {
								echo "<option value=\"{$gw_group['name']}\">{$gw_group['name']}</option>\n";
							}
						}
					}
?>
					</select>
					<p><?=gettext("Leave as 'default' to use the system routing table.  Or choose a gateway to utilize policy based routing.");?></p>
				</div>
			</td>
		</tr>
		<tr>
			<td width="22%" valign="top" class="vncell"><?=gettext("In/Out");?></td>
			<td width="78%" class="vtable">
				<div id="showadvinoutbox" <?php if (!empty($pconfig['dnpipe'])) echo "style='display:none'"; ?>>
					<input type="button" onClick="show_advanced_inout()" value="<?=gettext("Advanced"); ?>"></input> - <?=gettext("Show advanced option");?></a>
				</div>
				<div id="showinoutadv" <?php if (empty($pconfig['dnpipe'])) echo "style='display:none'"; ?>>
					<select name="dnpipe">
<?php
		if (!is_array($dnqlist))
			$dnqlist = array();
		echo "<option value=\"none\"";
		if (!$dnqselected) echo " SELECTED";
		echo " >none</option>";
		foreach ($dnqlist as $dnq => $dnqkey) {
			if($dnq == "")
				continue;
			echo "<option value=\"$dnqkey\"";
			if ($dnqkey == $pconfig['dnpipe']) {
				$dnqselected = 1;
				echo " SELECTED";
			}
			echo ">{$dnq}</option>"; 
		}
?>
			</select> / 			
			<select name="pdnpipe">
<?php
		$dnqselected = 0;
		echo "<option value=\"none\"";
		if (!$dnqselected) echo " SELECTED";
		echo " >none</option>";
		foreach ($dnqlist as $dnq => $dnqkey) {
			if($dnq == "")
				continue;
			echo "<option value=\"$dnqkey\"";
			if ($dnqkey == $pconfig['pdnpipe']) {
				$dnqselected = 1;
				echo " SELECTED";
			}
			echo ">{$dnq}</option>"; 
		}
?>
				</select>
				<br />
				<span class="vexpl"><?=gettext("Choose the Out queue/Virtual interface only if you have also selected In.")."<br/>".gettext("The Out selection is applied to traffic leaving the interface where the rule is created, In is applied to traffic coming into the chosen interface.")."<br/>".gettext("If you are creating a floating rule, if the direction is In then the same rules apply, if the direction is out the selections are reverted Out is for incoming and In is for outgoing.");?></span>
				</div>
			</td>
		</tr>

		<tr>
			<td width="22%" valign="top" class="vncell"><?=gettext("Ackqueue/Queue");?></td>
			<td width="78%" class="vtable">
			<div id="showadvackqueuebox" <?php if (!empty($pconfig['defaultqueue'])) echo "style='display:none'"; ?>>
				<input type="button" onClick="show_advanced_ackqueue()" value="<?=gettext("Advanced"); ?>"></input> - <?=gettext("Show advanced option");?></a>
			</div>
			<div id="showackqueueadv" <?php if (empty($pconfig['defaultqueue'])) echo "style='display:none'"; ?>>
				<select name="ackqueue">
<?php
			if (!is_array($qlist))
				$qlist = array();
			echo "<option value=\"none\"";
			if (!$qselected) echo " SELECTED";
			echo " >none</option>";
			foreach ($qlist as $q => $qkey) {
				if($q == "")
					continue;
				echo "<option value=\"$q\"";
				if ($q == $pconfig['ackqueue']) {
					$qselected = 1;
					echo " SELECTED";
				}
				if (isset($ifdisp[$q]))
					echo ">{$ifdisp[$q]}</option>";
				else
					echo ">{$q}</option>"; 
			}
?>
				</select> / 			
				<select name="defaultqueue">
<?php
			$qselected = 0;
			echo "<option value=\"none\"";
			if (!$qselected) echo " SELECTED";
			echo " >none</option>";
			foreach ($qlist as $q => $qkey) {
				if($q == "")
					continue;
				echo "<option value=\"$q\"";
				if ($q == $pconfig['defaultqueue']) {
					$qselected = 1;
					echo " SELECTED";
				}
				if (isset($ifdisp[$q]))
					echo ">{$ifdisp[$q]}</option>";
				else
					echo ">{$q}</option>"; 
			}
?>
				</select>
					<br />
					<span class="vexpl"><?=gettext("Choose the Acknowledge Queue only if you have selected Queue.");?></span>
				</td>
			</tr>
			<tr>
				<td width="22%" valign="top" class="vncell"><?=gettext("Layer7");?></td>
				<td width="78%" class="vtable">
					<div id="showadvlayer7box" <?php if (!empty($pconfig['l7container'])) echo "style='display:none'"; ?>>
						<input type="button" onClick="show_advanced_layer7()" value="<?=gettext("Advanced"); ?>"></input> - <?=gettext("Show advanced option");?></a>
					</div>
					<div id="showlayer7adv" <?php if (empty($pconfig['l7container'])) echo "style='display:none'"; ?>>
				<select name="l7container">
<?php
					if (!is_array($l7clist))
						$l7clist = array();
					echo "<option value=\"none\"";
					echo " >none</option>";
					foreach ($l7clist as $l7ckey) {
						echo "<option value=\"{$l7ckey}\"";
						if ($l7ckey == $pconfig['l7container']) {
							echo " SELECTED";
						}
						echo ">{$l7ckey}</option>"; 
					}
?>
				</select>			
				<br/>
				<span class="vexpl">
					<?=gettext("Choose a Layer7 container to apply application protocol inspection rules. " .
					"These are valid for TCP and UDP protocols only.");?>
				</span>
			  </div>
			</td>
		</tr>
<?php
		// Allow extending of the firewall edit page and include custom input validation 
		pfSense_handle_custom_code("/usr/local/pkg/firewall_rules/htmlphplate");
?>
		<tr>
			<td width="22%" valign="top">&nbsp;</td>
			<td width="78%">
				&nbsp;<br>&nbsp;
				<input name="Submit" type="submit" class="formbtn" value="<?=gettext("Save"); ?>">  <input type="button" class="formbtn" value="<?=gettext("Cancel"); ?>" onclick="history.back()">
<?php			if (isset($id) && $a_filter[$id]): ?>
					<input name="id" type="hidden" value="<?=htmlspecialchars($id);?>">
<?php 			endif; ?>
				<input name="after" type="hidden" value="<?=htmlspecialchars($after);?>">
			</td>
		</tr>
	</table>
</form>
<script language="JavaScript">
<!--
	ext_change();
	typesel_change();
	proto_change();
	<?php if ( (!empty($pconfig['srcbeginport']) && $pconfig['srcbeginport'] != "any") || (!empty($pconfig['srcendport']) && $pconfig['srcendport'] != "any") ): ?>
	show_source_port_range();
	<?php endif; ?>

<?php
	$isfirst = 0;
	$aliases = "";
	$addrisfirst = 0;
	$aliasesaddr = "";
	if($config['aliases']['alias'] <> "" and is_array($config['aliases']['alias']))
		foreach($config['aliases']['alias'] as $alias_name) {
			switch ($alias_name['type']) {
			case "port":
				if($isfirst == 1) $portaliases .= ",";
				$portaliases .= "'" . $alias_name['name'] . "'";
				$isfirst = 1;
				break;
			case "host":
			case "network":
			case "openvpn":
			case "urltable":
				if($addrisfirst == 1) $aliasesaddr .= ",";
				$aliasesaddr .= "'" . $alias_name['name'] . "'";
				$addrisfirst = 1;
				break;
			default:
				break;
			}
		}
?>

	var addressarray=new Array(<?php echo $aliasesaddr; ?>);
	var customarray=new Array(<?php echo $portaliases; ?>);

	var oTextbox1 = new AutoSuggestControl(document.getElementById("src"), new StateSuggestions(addressarray));
        var oTextbox2 = new AutoSuggestControl(document.getElementById("srcbeginport_cust"), new StateSuggestions(customarray));
        var oTextbox3 = new AutoSuggestControl(document.getElementById("srcendport_cust"), new StateSuggestions(customarray));
        var oTextbox4 = new AutoSuggestControl(document.getElementById("dst"), new StateSuggestions(addressarray));
        var oTextbox5 = new AutoSuggestControl(document.getElementById("dstbeginport_cust"), new StateSuggestions(customarray));
        var oTextbox6 = new AutoSuggestControl(document.getElementById("dstendport_cust"), new StateSuggestions(customarray));
//-->
</script>
<?php include("fend.inc"); ?>
</body>
</html>
