Contributing to MozDef
======================

MozDef is an open source project and we love to receive contributions from the community. There are many ways to contribute, from writing documentation, submitting bug reports and feature requests or writing code which can be incorporated into MozDef.
We would also love to hear how you are using MozDef and to receive contributions to make it easier to deploy and integrate.

Bug reports
-----------

If you think you have found a bug in MozDef, first make sure that you are testing against the [master branch](https://github.com/jeffbryner/MozDef) - your issue may already have been fixed. If not, search our [issues list](https://github.com/jeffbryner/MozDef/issues) on GitHub in case a similar issue has already been opened.

It is very helpful if you can prepare a reproduction of the bug. In other words, provide a small test case which we can run to confirm your bug. It makes it easier to find the problem and to fix it.

Provide as much information as you can. The easier it is for us to recreate your problem, the faster it is likely to be fixed.

Feature requests
----------------

If you are looking for a feature that doesn't exist currently in MozDef, you are probably not alone.
Open an issue on our [issues list](https://github.com/jeffbryner/MozDef/issues) on GitHub which describes the feature you would like to see, why you need it, and how it should work.
If you attach diagrams or mockups, it would be super nice ;-).

Contributing code and documentation changes
-------------------------------------------

If you have a bugfix or new feature that you would like to contribute to MozDef, please find or open an issue about it first. Talk about what you would like to do. It may be that somebody is already working on it, or that there are particular issues that you should know about before implementing the change.

We enjoy working with contributors to get their code accepted. There are many approaches to fixing a problem and it is important to find the best approach before writing too much code.

The process is described below.

### Fork and clone the repository

You will need to fork the main [MozDef repository](https://github.com/jeffbryner/MozDef) and clone it to your local machine. See
[github help page](https://help.github.com/articles/fork-a-repo) for help.

Push your local changes to your forked copy of the repository and [submit a pull request](https://help.github.com/articles/using-pull-requests). In the pull request, describe what your changes do and mention the number of the issue where discussion has taken place, eg "Closes #123".

Then sit back and wait. There will probably be discussion about the pull request and, if any changes are needed, we would love to work with you to get your pull request merged into MozDef.
