'use strict';

var url = require('url');


var User = require('./UserService');


module.exports.createUser = function createUser(req, res, next) {
    var body = req.swagger.params['body'].value;


    var result = User.createUser(body);

    if (typeof result !== 'undefined') {
        res.setHeader('Content-Type', 'application/json');
        res.end(JSON.stringify(result || {}, null, 2));
    }
    else
        res.end();
};

module.exports.createUsersWithArrayInput = function createUsersWithArrayInput(req, res, next) {
    var body = req.swagger.params['body'].value;


    var result = User.createUsersWithArrayInput(body);

    if (typeof result !== 'undefined') {
        res.setHeader('Content-Type', 'application/json');
        res.end(JSON.stringify(result || {}, null, 2));
    }
    else
        res.end();
};

module.exports.createUsersWithListInput = function createUsersWithListInput(req, res, next) {
    var body = req.swagger.params['body'].value;


    var result = User.createUsersWithListInput(body);

    if (typeof result !== 'undefined') {
        res.setHeader('Content-Type', 'application/json');
        res.end(JSON.stringify(result || {}, null, 2));
    }
    else
        res.end();
};

module.exports.loginUser = function loginUser(req, res, next) {
    var username = req.swagger.params['username'].value;
    var password = req.swagger.params['password'].value;


    var result = User.loginUser(username, password);

    if (typeof result !== 'undefined') {
        res.setHeader('Content-Type', 'application/json');
        res.end(JSON.stringify(result || {}, null, 2));
    }
    else
        res.end();
};

module.exports.logoutUser = function logoutUser(req, res, next) {


    var result = User.logoutUser();

    if (typeof result !== 'undefined') {
        res.setHeader('Content-Type', 'application/json');
        res.end(JSON.stringify(result || {}, null, 2));
    }
    else
        res.end();
};

module.exports.getUserByName = function getUserByName(req, res, next) {
    var username = req.swagger.params['username'].value;


    var result = User.getUserByName(username);

    if (typeof result !== 'undefined') {
        res.setHeader('Content-Type', 'application/json');
        res.end(JSON.stringify(result || {}, null, 2));
    }
    else
        res.end();
};

module.exports.updateUser = function updateUser(req, res, next) {
    var username = req.swagger.params['username'].value;
    var body = req.swagger.params['body'].value;


    var result = User.updateUser(username, body);

    if (typeof result !== 'undefined') {
        res.setHeader('Content-Type', 'application/json');
        res.end(JSON.stringify(result || {}, null, 2));
    }
    else
        res.end();
};

module.exports.deleteUser = function deleteUser(req, res, next) {
    var username = req.swagger.params['username'].value;


    var result = User.deleteUser(username);

    if (typeof result !== 'undefined') {
        res.setHeader('Content-Type', 'application/json');
        res.end(JSON.stringify(result || {}, null, 2));
    }
    else
        res.end();
};
