# Python

Trivy supports three types of Python package managers: `pip`, `Pipenv` and `Poetry`.
The following scanners are supported for package managers.

| Package manager | SBOM  | Vulnerability | License |
| --------------- | :---: | :-----------: | :-----: |
| pip             |   ✓   |       ✓       |    -    |
| Pipenv          |   ✓   |       ✓       |    -    |
| Poetry          |   ✓   |       ✓       |    -    |

In addition, Trivy supports three formats of Python packages: `egg`, `wheel` and `conda`.
The following scanners are supported for Python packages.

| Packaging | SBOM  | Vulnerability | License |
| --------- | :---: | :-----------: | :-----: |
| Egg       |   ✓   |       ✓       |    ✓    |
| Wheel     |   ✓   |       ✓       |    ✓    |
| Conda     |   ✓   |       -       |    -    |


The following table provides an outline of the features Trivy offers.

| Package manager | File             | Transitive dependencies | Dev dependencies | [Dependency graph][dependency-graph] | Position |
|-----------------|------------------|:-----------------------:|:----------------:|:------------------------------------:|:--------:|
| pip             | requirements.txt |            -            |     Include      |                  -                   |    -     |
| Pipenv          | Pipfile.lock     |            ✓            |     Include      |                  -                   |    ✓     |
| Poetry          | poetry.lock      |            ✓            |     Exclude      |                  ✓                   |          |


| Packaging | Dependency graph |
| --------- | :--------------: |
| Egg       |        ✓         |
| Wheel     |        ✓         |

These may be enabled or disabled depending on the target.
See [here](./index.md) for the detail.

## Package managers
Trivy parses your files generated by package managers in filesystem/repository scanning.

### pip
`requirements.txt` files usually contain only the direct dependencies and not contain the transitive dependencies.
Therefore, Trivy scans only for the direct dependencies with `requirements.txt`.

To detect transitive dependencies as well, you need to generate `requirements.txt` with `pip freeze`.

```zsh
$ cat requirements.txt # it will only find `requests@2.28.2`.
requests==2.28.2 
$ pip install -r requirements.txt
...

$ pip freeze > requirements.txt   
$ cat requirements.txt # it will also find the transitive dependencies of `requests@2.28.2`.
certifi==2022.12.7
charset-normalizer==3.1.0
idna==3.4
PyJWT==2.1.0
requests==2.28.2
urllib3==1.26.15
```

`pip freeze` also helps to resolve [extras](https://packaging.python.org/en/latest/tutorials/installing-packages/#installing-extras)(optional) dependencies (like `package[extras]=0.0.0`).

`requirements.txt` files don't contain information about dependencies used for development.
Trivy could detect vulnerabilities on the development packages, which not affect your production environment.

License detection is not supported for `pip`.

### Pipenv
Trivy parses `Pipfile.lock`.
`Pipfile.lock` files don't contain information about dependencies used for development.
Trivy could detect vulnerabilities on the development packages, which not affect your production environment.

License detection is not supported for `Pipenv`.

### Poetry
Trivy uses `poetry.lock` to identify dependencies and find vulnerabilities.
To build the correct dependency graph, `pyproject.toml` also needs to be present next to `poetry.lock`.

License detection is not supported for `Poetry`.

## Packaging
Trivy parses the manifest files of installed packages in container image scanning and so on.
See [here](https://packaging.python.org/en/latest/discussions/wheel-vs-egg/) for the detail.

### Egg
Trivy looks for `*.egg-info`, `*.egg-info/PKG-INFO`, `*.egg` and `EGG-INFO/PKG-INFO` to identify Python packages.

### Wheel
Trivy looks for `.dist-info/META-DATA` to identify Python packages.

[dependency-graph]: ../../configuration/reporting.md#show-origins-of-vulnerable-dependencies
