# OS Packages
Trivy is capable of automatically detecting installed OS packages when scanning container images, VM images and running hosts.
This page provides an overview of OS packages in the context of Trivy scans.

## Supported OS

The unfixed/unfixable vulnerabilities mean that the patch has not yet been provided on their distribution.
To hide unfixed/unfixable vulnerabilities, you can use the `--ignore-unfixed` flag.

Trivy doesn't support self-compiled packages/binaries, but official packages provided by vendors such as Red Hat and Debian.

| OS                               | Supported Versions                        | Target Packages               | Detection of unfixed vulnerabilities |
|----------------------------------|-------------------------------------------|-------------------------------|:------------------------------------:|
| Alpine Linux                     | 2.2 - 2.7, 3.0 - 3.17, edge               | Installed by apk              |                  NO                  |
| Wolfi Linux                      | (n/a)                                     | Installed by apk              |                  NO                  |
| Chainguard                       | (n/a)                                     | Installed by apk              |                  NO                  |
| Red Hat Universal Base Image[^1] | 7, 8, 9                                   | Installed by yum/rpm          |                 YES                  |
| Red Hat Enterprise Linux         | 6, 7, 8                                   | Installed by yum/rpm          |                 YES                  |
| CentOS                           | 6, 7, 8                                   | Installed by yum/rpm          |                 YES                  |
| AlmaLinux                        | 8, 9                                      | Installed by yum/rpm          |                  NO                  |
| Rocky Linux                      | 8, 9                                      | Installed by yum/rpm          |                  NO                  |
| Oracle Linux                     | 5, 6, 7, 8                                | Installed by yum/rpm          |                  NO                  |
| CBL-Mariner                      | 1.0, 2.0                                  | Installed by yum/rpm          |                 YES                  |
| Amazon Linux                     | 1, 2, 2023                                | Installed by yum/rpm          |                  NO                  |
| openSUSE Leap                    | 42, 15                                    | Installed by zypper/rpm       |                  NO                  |
| SUSE Enterprise Linux            | 11, 12, 15                                | Installed by zypper/rpm       |                  NO                  |
| Photon OS                        | 1.0, 2.0, 3.0, 4.0                        | Installed by tdnf/yum/rpm     |                  NO                  |
| Debian GNU/Linux                 | wheezy, jessie, stretch, buster, bullseye | Installed by apt/apt-get/dpkg |                 YES                  |
| Ubuntu                           | All versions supported by Canonical       | Installed by apt/apt-get/dpkg |                 YES                  |
| Distroless[^2]                   | Any                                       | Installed by apt/apt-get/dpkg |                 YES                  |

## Data Sources

| OS            | Source                                 |
|---------------|----------------------------------------|
| Arch Linux    | [Vulnerable Issues][arch]              |
| Alpine Linux  | [secdb][alpine]                        |
| Wolfi Linux   | [secdb][wolfi]                         |
| Chainguard    | [secdb][chainguard]                    |
| Amazon Linux  | [Amazon Linux Security Center][amazon] |
| Debian        | [Security Bug Tracker][debian-tracker] |
|               | [OVAL][debian-oval]                    |
| Ubuntu        | [Ubuntu CVE Tracker][ubuntu]           |
| RHEL/CentOS   | [OVAL][rhel-oval]                      |
|               | [Security Data][rhel-api]              |
| AlmaLinux     | [AlmaLinux Product Errata][alma]       |
| Rocky Linux   | [Rocky Linux UpdateInfo][rocky]        |
| Oracle Linux  | [OVAL][oracle]                         |
| CBL-Mariner   | [OVAL][mariner]                        |
| OpenSUSE/SLES | [CVRF][suse]                           |
| Photon OS     | [Photon Security Advisory][photon]     |

### Data source selection
Trivy **only** consumes security advisories from the sources listed in the above table.

As for packages installed from OS package managers (`dpkg`, `yum`, `apk`, etc.), Trivy uses the advisory database from the appropriate **OS vendor**.

For example: for a python package installed from `yum` (Amazon linux), Trivy will only get advisories from [ALAS][amazon].
But for a python package installed from another source (e.g. `pip`), Trivy will get advisories from the `GitLab` and `GitHub` databases.

This advisory selection is essential to avoid getting false positives because OS vendors usually backport upstream fixes, and the fixed version can be different from the upstream fixed version.
The severity is from the selected data source.
If the data source does not provide severity, it falls back to [NVD][nvd], and if NVD does not have severity, it will be UNKNOWN.

## Distributions
### CBL-Mariner
Trivy scans [CBL-Mariner][cbl-mariner].

#### Support
The following table provides an outline of the features Trivy offers.

| Version | Container image | Virtual machine | Distroless |  Multi-arch  | Unfixed support |
|---------|:---------------:|:---------------:|:----------:|:------------:|:---------------:|
| 1.0     |        ✔        |        ✔        |     ✔      | amd64, arm64 |        ✔        |
| 2.0     |        ✔        |        ✔        |     ✔      | amd64, arm64 |        ✔        |

### Examples

=== "image"
    ```
    ➜ trivy image mcr.microsoft.com/cbl-mariner/base/core:2.0
    2022-07-27T14:48:20.355+0600	INFO	Detected OS: cbl-mariner
    2022-07-27T14:48:20.355+0600	INFO	Detecting CBL-Mariner vulnerabilities...
    2022-07-27T14:48:20.356+0600	INFO	Number of language-specific files: 0
    
    mcr.microsoft.com/cbl-mariner/base/core:2.0 (cbl-mariner 2.0.20220527)
        
    Total: 33 (UNKNOWN: 0, LOW: 0, MEDIUM: 15, HIGH: 13, CRITICAL: 5)
    ```

=== "rootfs"
    ```
    ➜ docker run  -it --rm --entrypoint bin/bash mcr.microsoft.com/cbl-mariner/base/core:2.0
    root [ / ]# tdnf -y install ca-certificates
    root [ / ]# # Install the latest Trivy
    root [ / ]# trivy rootfs /
    2022-07-27T09:30:06.815Z	INFO	Need to update DB
    2022-07-27T09:30:06.815Z	INFO	DB Repository: ghcr.io/aquasecurity/trivy-db
    2022-07-27T09:30:06.815Z	INFO	Downloading DB...
    33.25 MiB / 33.25 MiB [------------------------------] 100.00% 4.20 MiB p/s 8.1s
    2022-07-27T09:30:21.756Z	INFO	Vulnerability scanning is enabled
    2022-07-27T09:30:21.756Z	INFO	Secret scanning is enabled
    2022-07-27T09:30:21.756Z	INFO	If your scanning is slow, please try '--scanners vuln' to disable secret scanning
    2022-07-27T09:30:21.756Z	INFO	Please see also https://aquasecurity.github.io/trivy/v0.30.4/docs/secret/scanning/#recommendation for faster secret detection
    2022-07-27T09:30:22.205Z	INFO	Detected OS: cbl-mariner
    2022-07-27T09:30:22.205Z	INFO	Detecting CBL-Mariner vulnerabilities...
    2022-07-27T09:30:22.205Z	INFO	Number of language-specific files: 0
    
    40ba9a55397c (cbl-mariner 2.0.20220527)
    =======================================
    Total: 33 (UNKNOWN: 0, LOW: 0, MEDIUM: 15, HIGH: 13, CRITICAL: 5)
    ```

[^1]: https://developers.redhat.com/products/rhel/ubi
[^2]: https://github.com/GoogleContainerTools/distroless

[arch]: https://security.archlinux.org/
[alpine]: https://secdb.alpinelinux.org/
[wolfi]: https://packages.wolfi.dev/os/security.json
[chainguard]: https://packages.cgr.dev/chainguard/security.json
[amazon]: https://alas.aws.amazon.com/
[debian-tracker]: https://security-tracker.debian.org/tracker/
[debian-oval]: https://www.debian.org/security/oval/
[ubuntu]: https://ubuntu.com/security/cve
[rhel-oval]: https://www.redhat.com/security/data/oval/v2/
[rhel-api]: https://www.redhat.com/security/data/metrics/
[alma]: https://errata.almalinux.org/
[rocky]: https://download.rockylinux.org/pub/rocky/
[oracle]: https://linux.oracle.com/security/oval/
[suse]: http://ftp.suse.com/pub/projects/security/cvrf/
[photon]: https://packages.vmware.com/photon/photon_cve_metadata/
[mariner]: https://github.com/microsoft/CBL-MarinerVulnerabilityData/

[cbl-mariner]: https://github.com/microsoft/CBL-Mariner

[nvd]: https://nvd.nist.gov/
