# OS

| OS            | Source                                 |
|---------------|----------------------------------------|
| Arch Linux    | [Vulnerable Issues][arch]              |
| Alpine Linux  | [secdb][alpine]                        |
| Wolfi Linux   | [secdb][wolfi]                         |
| Chainguard    | [secdb][chainguard]                    |
| Amazon Linux  | [Amazon Linux Security Center][amazon] |
| Debian        | [Security Bug Tracker][debian-tracker] |
|               | [OVAL][debian-oval]                    |
| Ubuntu        | [Ubuntu CVE Tracker][ubuntu]           |
| RHEL/CentOS   | [OVAL][rhel-oval]                      |
|               | [Security Data][rhel-api]              |
| AlmaLinux     | [AlmaLinux Product Errata][alma]       |
| Rocky Linux   | [Rocky Linux UpdateInfo][rocky]        |
| Oracle Linux  | [OVAL][oracle]                         |
| CBL-Mariner   | [OVAL][mariner]                        |
| OpenSUSE/SLES | [CVRF][suse]                           |
| Photon OS     | [Photon Security Advisory][photon]     |

# Programming Language

| Language | Source                                              | Commercial Use | Delay[^1] |
|----------|-----------------------------------------------------|:--------------:|:---------:|
| PHP      | [PHP Security Advisories Database][php]             |       ✅        |     -     |
|          | [GitHub Advisory Database (Composer)][php-ghsa]     |       ✅        |     -     |
| Python   | [GitHub Advisory Database (pip)][python-ghsa]       |       ✅        |     -     |
|          | [Open Source Vulnerabilities (PyPI)][python-osv]    |       ✅        |     -     |
| Ruby     | [Ruby Advisory Database][ruby]                      |       ✅        |     -     |
|          | [GitHub Advisory Database (RubyGems)][ruby-ghsa]    |       ✅        |     -     |
| Node.js  | [Ecosystem Security Working Group][nodejs]          |       ✅        |     -     |
|          | [GitHub Advisory Database (npm)][nodejs-ghsa]       |       ✅        |     -     |
| Java     | [GitLab Advisories Community][gitlab]               |       ✅        |  1 month  |
|          | [GitHub Advisory Database (Maven)][java-ghsa]       |       ✅        |     -     |
| Go       | [GitLab Advisories Community][gitlab]               |       ✅        |  1 month  |
|          | [The Go Vulnerability Database][go]                 |       ✅        |     -     |
| Rust     | [Open Source Vulnerabilities (crates.io)][rust-osv] |       ✅        |     -     |
| .NET     | [GitHub Advisory Database (NuGet)][dotnet-ghsa]     |       ✅        |     -     |
| C/C++    | [GitLab Advisories Community][gitlab]               |       ✅        |  1 month  |
| Dart     | [GitHub Advisory Database (Pub)][pub-ghsa]          |       ✅        |     -     |
| Elixir   | [GitHub Advisory Database (Erlang)][erlang-ghsa]    |       ✅        |           |

[^1]: Intentional delay between vulnerability disclosure and registration in the DB

# Others

| Name                            | Source     |  
| --------------------------------|------------|
| National Vulnerability Database | [NVD][nvd] | 

# Data source selection
Trivy **only** consumes security advisories from the sources listed in the following tables.

As for packages installed from OS package managers (`dpkg`, `yum`, `apk`, etc.), Trivy uses the advisory database from the appropriate **OS vendor**.

For example: for a python package installed from `yum` (Amazon linux), Trivy will only get advisories from [ALAS][amazon2]. But for a python package installed from another source (e.g. `pip`), Trivy will get advisories from the `GitLab` and `GitHub` databases.

This advisory selection is essential to avoid getting false positives because OS vendors usually backport upstream fixes, and the fixed version can be different from the upstream fixed version.
The severity is from the selected data source. If the data source does not provide severity, it falls back to NVD, and if NVD does not have severity, it will be UNKNOWN.

[arch]: https://security.archlinux.org/
[alpine]: https://secdb.alpinelinux.org/
[wolfi]: https://packages.wolfi.dev/os/security.json
[chainguard]: https://packages.cgr.dev/chainguard/security.json
[amazon]: https://alas.aws.amazon.com/
[debian-tracker]: https://security-tracker.debian.org/tracker/
[debian-oval]: https://www.debian.org/security/oval/
[ubuntu]: https://ubuntu.com/security/cve
[rhel-oval]: https://www.redhat.com/security/data/oval/v2/
[rhel-api]: https://www.redhat.com/security/data/metrics/
[alma]: https://errata.almalinux.org/
[rocky]: https://download.rockylinux.org/pub/rocky/
[oracle]: https://linux.oracle.com/security/oval/
[suse]: http://ftp.suse.com/pub/projects/security/cvrf/
[photon]: https://packages.vmware.com/photon/photon_cve_metadata/
[mariner]: https://github.com/microsoft/CBL-MarinerVulnerabilityData/

[php-ghsa]: https://github.com/advisories?query=ecosystem%3Acomposer
[python-ghsa]: https://github.com/advisories?query=ecosystem%3Apip
[ruby-ghsa]: https://github.com/advisories?query=ecosystem%3Arubygems
[nodejs-ghsa]: https://github.com/advisories?query=ecosystem%3Anpm
[java-ghsa]: https://github.com/advisories?query=ecosystem%3Amaven
[dotnet-ghsa]: https://github.com/advisories?query=ecosystem%3Anuget
[pub-ghsa]: https://github.com/advisories?query=ecosystem%3Apub
[erlang-ghsa]: https://github.com/advisories?query=ecosystem%3Aerlang

[php]: https://github.com/FriendsOfPHP/security-advisories
[ruby]: https://github.com/rubysec/ruby-advisory-db
[nodejs]: https://github.com/nodejs/security-wg
[gitlab]: https://gitlab.com/gitlab-org/advisories-community
[go]: https://github.com/golang/vulndb

[python-osv]: https://osv.dev/list?q=&ecosystem=PyPI
[rust-osv]: https://osv.dev/list?q=&ecosystem=crates.io

[nvd]: https://nvd.nist.gov/
