---
title: "Uppy 0.18: Dogumentation and The GoldenRetriever"
image: "http://uppy.io/images/blog/0.18/golden-retriever.jpg"
date: 2017-09-15
author: arturi
published: true
---

Hi! Another month — a new Uppy release 🎉

*Note: current latest release is actually `0.19`, but this post got delayed, so we are publishing it first. `0.19` post is coming next.*

## New documentation

Documentation for Uppy has been re-written, and now features chapters on Uppy’s settings and API, using various plugins, and running Uppy Server. Check it out: https://uppy.io/docs/. More chapters to come!

## The GoldenRetriever

The GoldenRetriever has been released as a public beta. For details, please refer to the previous post, [The GoldenRetriever: Making uploads survive browser crashes](https://uppy.io/blog/2017/07/golden-retriever/), but the gist is: when enabled, this plugin will save uppy-state to localStorage on every change, and then if your browser crashes, or you accidentaly navigate away from a tab,later when you return, your uploads will resume like nothing happened. Spoiler: it uses Service Workers and IndexedDB.

<img class="border" src="/images/blog/0.18/golden-retriever.jpg">

<!-- more -->

## Multipart uploader is now XHRUpload

`Multipart` has been replaced by a more flexible `XHRUpload`, so that other plugins, like `AwsS3`, can depend on it.

## AwsS3

The `AwsS3` plugin can be used to upload files directly to an S3 bucket.

As of now, the AwsS3 plugin “decorates” the `XHRUpload` plugin. To upload files directly to S3, both the `XHRUpload` and `AwsS3` plugins must be used:

```js
// No options have to be provided to the XHRUpload plugin,
// the S3 plugin will configure it.
uppy.use(XHRUpload)
uppy.use(AwsS3, {
  // Options for S3
})
```

Please find [more info and examples](https://uppy.io/docs/aws-s3/) in the docs.

## Transloadit `getAssemblyOptions`

We’ve added a `getAssemblyOptions` function option to the `Transloadit` plugin. This option can return an object or a Promise for an object to configure the Transloadit assembly. The returned object can contain params, a signature, and fields.

`getAssemblyOptions` is called on each file, so each file can return a different set of options. Files that returned the same options are bundled together and run through a single assembly. Files that return different options will be run through different assemblies.

This means that it is now possible to make assembly parameters depend on user input from eg. the `MetaData` plugin, and have different parameters for different files. It’s now also possible to generate very short-lived signatures on the server when an upload starts, by calling fetch inside the `getAssemblyOptions` hook.

## Webcam: 1, 2, 3 smile!

Webcam plugin now has a new exciting feature — ⏱ `countdown`. If you set it to 3 seconds, for example, then after pressing the capture button, Uppy will count to 3 before actually taking your selfie, so you’ll have the time to fix your hair:

```js
uppy.use(Webcam, { countdown: 3 })
```

## Tons of Uppy Server improvements

- Uppy Server uses Informer to display errors;
- Pictures from Instagram carousels show up inline;
- Uppy server now returns an `i-am` containing its instance url;
- Disable socket channel from restarting an already completed file download;
- Uppy client whitelisting has been made optional, you may use wildcard instead;
- Added feature to set master oauth redirect uri for multiple uppy-server instances;
- Added options to support for redis session storage on the standalone server;
- Uppy-server can be started as a binary `uppy-server`;
- Downloaded files are stored based on uuids;
- Upload state is stored on redis (useful for Goldern Retriever plugin).

## Release Notes

Here is the full list of changes for version `0.18`:

- goldenretriver: use Service Woker first, then IndexedDB, add file limits for IndexedDB, figure out what restores from where, add throttling for localStorage state sync (@goto-bus-stop @arturi)
- dashboard: flag to hide the upload button, for cases when you want to manually stat the upload (@arturi)
- dashboard: place close btn inside the Dashboard, don’t close on click outside, place source icon near the file size (@arturi)
- core: informer becomes a core API, `uppy.info('Smile! 📸', 'warning', 5000)` so its more concise with `uppy.log('my msg')` and supports different UI implementations (@arturi, #271)
- docs: first stage — on using plugins, all options, list of plugins, i18n, uppy-server (@arturi, @goto-bus-stop, @ifedapoolarewaju)
- provider: file size sorting (@ifedapoolarewaju)
- provider: show loading screen when checking auth too (@arturi)
- uploaders: add direct-to-s3 upload plugin (@goto-bus-stop)
- core: ability to re-upload all files, even `uploadComplete` ones, reset progress (@arturi)
- goldenretriver: recover selected or in progress files after a browser crash or closed tab: alpha-version, add LocalStorage, Service Worker and IndexedDB (@arturi @goto-bus-stop @nqst #268)
- xhrupload: add XHRUpload a more flexible successor to Multipart, so that S3 plugin can depend on it (@goto-bus-stop #242)
- core: add getFile method (@goto-bus-stop, #263)
- provider: use informer to display errors (@ifedapoolarewaju)
- provider: flatten instagram carousels #234 (@ifedapoolarewaju)
- server: add uppy-server url as `i-am` header (@ifedapoolarewaju)
- server: disable socket channel from restarting an already completed file download (@ifedapoolarewaju)
- server: make uppy client whitelisting optional. You may use wildcard instead (@ifedapoolarewaju)
- server: master oauth redirect uri for multiple uppy-server instances
- server: options support for redis session storage on standalone server (@ifedapoolarewaju)
- server: start uppy-server as binary `uppy-server` (@ifedapoolarewaju)
- server: store downloaded files based on uuids (@ifedapoolarewaju)
- server: store upload state on redis (@ifedapoolarewaju)
- server: use uppy informer for server errors (@ifedapoolarewaju, #272)
- server: whitelist multiple uppy clients (@ifedapoolarewaju)
- transloadit: emit an event when an assembly is created (@goto-bus-stop / #244)
- transloadit: function option for file-dependent `params` (@goto-bus-stop / #250)
- tus: Save upload URL early on (@goto-bus-stop #261)
- tus: return immediately if no files are selected (@goto-bus-stop #245)
- uppy-server: add uppy-server metrics to Librato (@ifedapoolarewaju @kiloreux)
- webcam: add 1, 2, 3, smile! to webcam, onBeforeSnapshothook (@arturi, #187, #248)
- website: live example on the homepage, “try me” button, improve /examples (@arturi)

The Uppy Team
