---
title: "Uppy 0.9: Making Progress, then pause & resume. Remote file uploads, Informer."
date: 2016-08-26
author: hedgerh
published: true
---

We have just released Uppy 0.9.0. This release features some changes that we think you will be very excited about.  Let's see what's new!

<!-- more -->

## Ability to pause uploads, progress indicators & ETA
The most visible feature that has been added is the ability to pause and resume file uploads.

<img alt="dashboard UI with paused uploads" src="/images/blog/0.9/upload-pause.jpg" class="border">

<img alt="dashboard UI with files uploading and a pause all button" src="/images/blog/0.9/upload-resume.jpg" class="border">

The upload dashboard now contains more information about uploads, such as the time remaining until an upload is finished. We have also added circular progress indicators to give better visual feedback on an upload's progress.

## Remote file uploads
Remote file uploading is now working again.

## Informer interface
We have added a new `Informer` plugin (tested with `Dashboard`, should also work anywhere else) that listens to `informer` events, like so:
``` javascript
bus.emit('informer', message, type, duration)
```
 and displays a message bubble for a certain amount of time. It will be useful to notify you when the internet connection is (a licky boom-boom) down (or back up):

<img alt="info: no connection" src="/images/blog/0.9/info-no-connection.jpg" class="border">

Or when Uppy has successfully uploaded your files:

<img alt="info: upload successful" src="/images/blog/0.9/info-upload-success.jpg" class="border">


## Webcam: Say Cheese!
The Webcam plugin can now take snapshots and add them to the file dashboard in Uppy's modal.  We have also added Flash support for Safari/IE users.  The UI has also been cleaned up in the dashboard.  We have temporarily disabled video recording in order to focus on rolling out the snapshot feature.

## Under the hood: UI refactors
Under the hood, we have made some changes to how the UI is structured.  We are taking a more componentized approach.  For example, the rendering of Google Drive's UI has been separated into multiple smaller components that can be found in the [`plugins/GoogleDrive` folder](https://github.com/transloadit/uppy/tree/master/src/plugins/GoogleDrive).

## Release Notes

Here is the full list of changes for version 0.9.0.:

- dashboard: informer interface: message when all uploads are "done" ([@arturi](https://github.com/arturi))
- dashboard: improve file paste — not really possible — no file names, weird API, Chrome-only http://stackoverflow.com/a/22940020 ([@arturi](https://github.com/arturi))
- meta: add google demo account [@kvz](https://github.com/kvz))
- meta: Set up a Google testing account that people can use to try the demo ([@hedgerh](https://github.com/hedgerh))
- meta: write 0.9 release blog post ([@hedgerh](https://github.com/hedgerh))
- webcam: a barely working webcam snapshot & upload ([@hedgerh](https://github.com/hedgerh))
- metadata: Uppy + tus empty metadata value issue in Safari https://github.com/tus/tus-js-client/issues/41 --> tus issue — nailed down, passed to @account (@arturi, @account)
- core: experiment with switching to `virtual-dom` in a separate branch; experiment with rollup again ([@arturi](https://github.com/arturi))
- core: figure out race conditions (animations not completing because file div gets re-added to the dom each time) with `yo-yo`/`morphdom` https://github.com/shama/bel/issues/26#issuecomment-238004130 ([@arturi](https://github.com/arturi))
- core: switch to https://github.com/sethvincent/namespace-emitter — smaller, allows for `on('*')` ([@arturi](https://github.com/arturi))
- dashboard: add aria-labels and titles everywhere to improve accessibility #114 ([@arturi](https://github.com/arturi))
- dashboard: file name + extension should fit on two lines, truncate in the middle (maybe https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/measureText) ([@arturi](https://github.com/arturi))
- dashboard: implement a circular progress indicator on top of the fileItem with play/pause ([@arturi](https://github.com/arturi))
- dashboard: refactor to smaller components, as discussed in #110 ([@arturi](https://github.com/arturi))
- google drive: refactor to smaller components, as discussed in #110 ([@hedgerh](https://github.com/hedgerh))
- google drive: add demo account ([@hedgerh](https://github.com/hedgerh))
- metadata: add labels to fields in fileCard ([@arturi](https://github.com/arturi))
- metadata: the aftermath — better UI ([@arturi](https://github.com/arturi))
- test: Get IE6 on Win XP to run Uppy and see it fall back to regular form upload #108 ([@arturi](https://github.com/arturi))
- test: refactor tests, add DragDrop back ([@arturi](https://github.com/arturi))
- tus: update uppy to tus-js-client@1.2.1, test on requirebin ([@arturi](https://github.com/arturi))
- tus: add ability to pause/resume all uploads at once ([@arturi](https://github.com/arturi))
- tus: add ability to pause/resume upload ([@arturi](https://github.com/arturi))

We hope you will enjoy this latest release. Uppy is still improving every day and we hope to bring you more news about our progress soon!

The Uppy Team
