---
title: "Uppy 0.26: Lerna"
date: 2018-07-12
author: renee
image: "https://uppy.io/images/blog/0.26/uppy-multiple-packages.png"
published: true
---

Uppy 0.26 replaces the monolithic Uppy package with a separate npm package for every plugin.

<img width="448" src="/images/blog/0.26/uppy-multiple-packages.png">

<!--more-->

## Lerna

⚠️ **breaking**

All Uppy plugins have moved into their own npm packages. This means you need to install the plugins you use separately in the future, and you have to update all your Uppy `require()` calls or `import` paths.

The packages are published under the `@uppy` scope on npm:

```bash
npm install @uppy/core @uppy/dashboard @uppy/tus
```

This has some benefits, like:

 - No need to know the file path of a plugin—use `@uppy/dashboard` instead of `uppy/lib/plugins/Dashboard`. This also allows us to move our file structure around internally without breaking everyone.
 - Only have the code you actually use in `node_modules`—large plugin dependencies are not installed if you don't use the plugin.
 - Separate versioning allows making breaking changes in plugins, without requiring users of other unrelated plugins to upgrade.

You can still use the `uppy` package for now to simplify upgrading, although it may be deprecated in the future. It installs all the `@uppy/` packages and re-exports them:

```js
const { Core, Dashboard, Tus } = require('uppy')
```

It's very important to set up tree shaking when using Uppy in this way; otherwise you may include dozens of KBs of unused plugins. Using the `@uppy/` packages instead is strongly recommended, as those do not include unused code in the first place.

```js
const Uppy = require('@uppy/core')
const Dashboard = require('@uppy/dashboard')
const Tus = require('@uppy/tus')
```

The CSS required for plugins is included in each package at `dist/style.css`. Each plugin contains _all_ the CSS it needs, eg. the Dashboard includes Status Bar CSS. If you use both plugins, only include the Dashboard CSS file. Even better is to use a CSS minifier so any duplicate styles are removed for you :) Caveats like this are documented on the plugin pages, and hopefully we can smooth it out over time!

## Typings

[@taoqf](https://github.com/taoqf) contributed TypeScript typings to 0.25—0.26 moves those into each package and adds a few missing ones.

We're not TypeScript experts ourselves, so feedback, bug reports & PRs are very much appreciated :sparkles:

## Documentation Updates

The documentation sidebar now lists plugins in several sections. This should make it easier to navigate. Of course, each plugin page now lists the `npm install` instruction needed to install it, too!

## Renaming the `host` Option in Remote Providers

⚠️ **breaking**

The `host` name in remote provider plugins was not great—for one, it could be a URL to an Uppy Server running in a subdirectory, not a hostname. As of 0.26, `serverUrl` should be used instead.

## Other Cool Changes

- providers: Add `serverPattern` option for third party authentication validation on dynamic Uppy Server hostnames (@ifedapoolarewaju)
- thumbnailgenerator: Polyfill Math.log2 since IE11 doesn't support this method (#892 / @DJWassink)
- dashboard: added browser back button listening (#575 / @zcallan)
- providers: Better provider errors (#895 / @arturi)
- xhr-upload: Add withCredentials option (#874 / @tuoxiansp)

See [full changelog (0.26 and 0.25.x patches) for more](https://github.com/transloadit/uppy/blob/master/CHANGELOG.md#0260)

See you in the next release!

The Uppy Team
