---
title: "Uppy 0.29: separate Core and Plugin styles, React Native in tus-js-client"
date: 2018-12-11
author: arturi
image: "https://uppy.io/images/blog/0.29/uppy-core-plugins-separate-styles.jpg"
published: true
---

<img src="/images/blog/0.29/uppy-core-plugins-separate-styles.jpg">

`0.29` brings bug fixes and improvements, while we are busy working on Uppy React Native support (which first had to [land in the js client for our resumable file upload protocol: tus.io](https://github.com/tus/tus-js-client#react-native-support)) and a Preset (still debating the name) which will make it easier to leverage Transloadit's encoding platform, and offer a smooth migration path for users not yet on Uppy. The highlights of this release are: separating Core and Plugin styles, more accurate progress reporting by factoring in sizes across files, adding a `responseType` option for XHR Upload, and fixing visual Webcam bugs.

<!--more-->

## Separate Core and Plugin styles

**⚠️ breaking**

When installing `uppy` and Plugins from npm, you had to include their styles. Prior to this release, you only had to include the Plugin’s CSS, say, for `@uppy/webcam`:

```js
import Uppy from '@uppy/core'
import Webcam from '@uppy/webcam'
import '@uppy/webcam/dist/style.css'
```

Each plugin's file contained the Core styles. If you added multiple plugins, the core styles ended up being duplicated. This bloated file sizes and could even break styles entirely because of CSS's precedence rules.

Now, you have to include “general” styles from `@uppy/core` as well:

```js
import Uppy from '@uppy/core'
import Webcam from '@uppy/webcam'
import '@uppy/core/dist/style.css' // <-- add this separately and one time only
import '@uppy/webcam/dist/style.css'
```

Thus, the Core styles are only included once. `@uppy/core` styles must be included before Plugin styles.

Please see the [documentation](https://uppy.io/docs/plugins/) for the Plugin you are using to find out whether it requires a CSS file to work. Generally speaking, UI plugins, such as the Dashboard, Webcam and Status Bar, need a CSS file, while utility plugins, such as Tus or XHR Upload, don’t.

⚠️ Important things to remember:

1. Dashboard is a universal UI that comes with the Status Bar and Informer Plugins built in, and as such, Dashboard styles already come with the Informer and Status Bar styles.
2. Dashboard also ships with “Remote Provider” styles — you don’t need to include anything besides `@uppy/dashboard/dist/style.css` for Google Drive, Instagram and Dropbox to work. However, the Url and Webcam plugins still have to be included manually. Here’s an example:

```js
import Uppy from '@uppy/core'
import Dashboard from '@uppy/webcam'
import GoogleDrive from '@uppy/google-drive'
import Webcam from '@uppy/webcam'
import Url from '@uppy/url'

// Core and Dashboard styles, then Webcam and Url, but not for GoogleDrive —
// those come with Dashboard
import '@uppy/core/dist/style.css'
import '@uppy/dashboard/dist/style.css'
import '@uppy/webcam/dist/style.css'
import '@uppy/url/dist/style.css'
```

## Using File Sizes For Progress Calculation

When possible, file sizes are now used for calculating the total progress. Before, we’ve used uploaded percentage for each file. Meaning that if you were uploading four files — and three small were already uploaded, while one very large file was still in progress — Uppy might still display progress as being 90%. Long story short, Uppy now has a more accurate progress bar 🚀

Some internal details, if you are interested:

1. If there are files without sizes, the average size of all other files is assumed for the unsized files.
2. If there are no files with sizes, the percentage is just based on the percentages of the unsized files.

<img src="/images/blog/0.29/progress-size-calculation.jpg">

## `responseType` For XHR Upload

When using XHR Upload, you can now configure the XMLHttpRequest `.responseType` value. This allows the S3 Plugin to tell Firefox not to log XML errors when getting empty responses, so it finally fixes the spurious warnings that were caused by this, see [#518](https://github.com/transloadit/uppy/issues/518).

Because AwsS3 now sets `responseType`: `'text'`, we can no longer use the `responseXML` property. We already did text based parsing for successful responses, and will now do the same for error responses.

## Misc Changes

- @uppy/core: Don't pass removed file IDs to next upload step, fixes (#1148 / @goto-bus-stop)
- @uppy/core: Fixed getFileType() when passed a file with an uppercase extension (#1169 / @jderrough)
- @uppy/companion: Use `createCipheriv` instead of deprecated `createCipher` (#1149 / @goto-bus-stop)
- @uppy/companion: Store Provider instances on `this.provider` instead of `this[this.id]` (@goto-bus-stop / #1174)
- @uppy/companion: Pin grant to known stable version (@ifedapoolarewaju / #1165)
- @uppy/companion: Fix — socket does not handle server.path option (#1142 / @tranvansang)
- @uppy/webcam: Fix a bug with Webcam video overflowing its container (68730f8a1bf731898d46883e00fed937d3ab54ab / @arturi)
- docs: Add `triggerUploadOnSubmit` to Form docs, add docs about options of hiding upload/pause/resume/cancel buttons; talk about bundler-less polyfill use (@goto-bus-stop, @arturi)
- @uppy/react: Allow Dashboard props width and height to accept a string for 100% (#1129 / craigcbrunner)

See the [full changelog (0.29)](https://github.com/transloadit/uppy/blob/master/CHANGELOG.md#0290) for more details.
