---
title: "Uppy 0.19: Tests, Informer details and better APIs"
image: "https://uppy.io/images/blog/0.19/informer-details.jpg"
date: 2017-09-21
author: arturi
published: true
---

Hello! The `0.19` release is about internal fixes, optimizations and refactoring, as well as some work on PRs that we’ll hopefully tell you about soon!

## Jest tests

Thanks to our contributer, [@richardwillars](https://github.com/richardwillars), and following the example set by Uppy Server, we’ve [switched to Jest](https://github.com/transloadit/uppy/pull/310) for Uppy’s unit tests, and added a bunch of new tests as well. And even more are being [added](https://github.com/transloadit/uppy/pull/346) as we speak!

We're also happy to report that [more tests](https://github.com/transloadit/uppy-server/compare/3341a9592d0723fd9b58ec77d8c762f20b434704...d3c6f5b409d08f588d1704b77181e5c0342ca322) have been added for Uppy Server.

## Dashboard APIs

We’ve exposed `show/hide/isOpen` APIs for the Dashboard UI plugin. Now you can open and close the modal dialog programmatically:

```js
var modal = uppy.getPlugin('Dashboard')
modal.show()

...

button.addEventListener('click', () => {
  if (modal.isOpen()) {
    modal.hide()
  } else {
    modal.show()
  }
})
```

Check out [the docs](https://uppy.io/docs/dashboard/#Methods).

<!--more-->

## Transloadit

- Possibility to upload to S3, then import into an assembly;
- New `alwaysRunAssembly` option has beed added to run assemblies when no files are uploaded.

## Informer details

Informer supports “explanations”, a questionmark (?) button that shows more info on hover / click.

<img class="border" src="/images/blog/0.19/informer-details.jpg">

## Misc good stuff

- Uppy instance ID, useful for GoldenRetriver, check out [example using multiple Uppy instances](https://github.com/transloadit/uppy/tree/master/examples/multiple-instances);
- Custom error messages from upload endpoints are now supported (#305);
- Fixed `calculateTotalProgress` and `restrictions`; improved `generateFileID` and `isOnline`;
- Removed some unused css styles from the bundle;
- Allow multiple `trigger` elements for the Dashboard, via using the same `class` attribute;
- Image previews are now resized gradually for better performance and quality;
- Metadata edits in the Dashboard are now saved when pressing enter key;

## Full Changelog

Here is the full list of changes for version `0.19` (and patch `0.18.1`):

- core: gradually resize image previews (#275 / @goto-bus-stop)
- informer: support “explanations”, a (?) button that shows more info on hover / click (#292 / @arturi)
- fix webcam video recording (@goto-bus-stop)
- bundle: add missing plugins (s3, statusbar, restorefiles) to unpkg bundle (#301 / @goto-bus-stop)
- xhrupload: Use error messages from the endpoint (#305 / @goto-bus-stop)
- dashboard: prevent submitting outer form when pressing enter key while editing metadata (#306 / @goto-bus-stop)
- dashboard: save metadata edits when pressing enter key (#308 / @arturi)
- transloadit: upload to S3, then import into :tl: assembly using `/add_file?s3url=${url}` (#280 / @goto-bus-stop)
- transloadit: add `alwaysRunAssembly` option to run assemblies when no files are uploaded (#290 / @goto-bus-stop)
- core: use `iteratePlugins` inside `updateAll` (#312 / @richardwillars)
- core: improve error when plugin does not have ID (#309 / @richardwillars)
- tus: Clear stored `uploadUrl` on `uppy.resetProgress()` call (#314 / @goto-bus-stop)
- website: simplify examples and code samples, prevent sidebar subheading links anywhere but in docs (@arturi)
- website: group plugin docs together in the sidebar (@arturi)
- goldenretriever: allow passing options to `IndexedDbStore` (#339 / sunil-shrestha)
- core: add Uppy instance ID option, namespace serviceWorker action types, add example using multiple Uppy instances with GoldenRetriever (#333 / @goto-bus-stop)
- core: fix `calculateTotalProgress` - NaN (#342 / @arturi)
- core: fix and refactor `restrictions` (#345 / @arturi)
- core: Better `generateFileID` (#330 / @arturi)
- core: improve `isOnline()` (#319 / @richardwillars)
- core: remove unused bootstrap styles (#329 / @arturi)
- core: experiment with yo-yo --> preact and picodom (#297 / @arturi)
- dashboard: fix FileItem source icon position and copy (@arturi)
- dashboard: expose and document the `show/hide/isOpen` API (@arturi)
- dashboard: allow multiple `trigger` of the same class `.open-uppy` (#328 / @arturi)
- plugins: add `aria-hidden` to all SVG icons for accessibility (#4e808ca3d26f06499c58bb77abbf1c3c2b510b4d / @arturi)
- core: Handle sync returns and throws in possibly-async function options (#315 / @goto-bus-stop)
- core: switch to Jest tests, add more tests for Core and Utils (#310 / @richardwillars)
- website: Minify bundle for `disc` (#332 / @goto-bus-stop)
- transloadit: remove `this.state` getter (#331 / @goto-bus-stop)
- server: option to define valid upload urls (@ifedapoolarewaju)
- server: more automated tests (@ifedapoolarewaju)

The Uppy Team
