---
title: "Uppy 0.14: Responsive Dashboard, Standalone & Pluggable Server, Dropbox"
date: 2017-02-13
author: arturi
published: true
---

Hi! Hope y’all have had great holidays! 🎄 Which reminds us, we still have a gift for you — and we even wrapped it in a package (npm). Look inside and you’ll find that Uppy 0.14!

“But wait”, you might ask, “where is the 0.13 release that we have been waiting for?”

Well, let’s just say we are superstitious like that. You won’t see us coding under any ladders either! And we were also in the middle of the holiday season, so we decided to call 0.13 “The Release That Wasn’t” and skip it.

Let’s take a look at what Uppy 0.14 has in store for you.

<!-- more -->

## Major Uppy Server Updates

**Express.js**
We’ve switched to Express from Koa. It’s more widely adopted and supported, has larger community and better maintained packages, so we went for it.

**Pluggable or standalone**
Uppy Server can now be plugged into your existing Express/Koa server app, but you can also still run it as a standalone server. [See here](https://github.com/transloadit/uppy-server#run-as-standalone-server) for further instructions.

**Smooth authentication**
It used to be the case that when you clicked that stylish “authenticate” [with Google Drive] button, you were taken away from the page, and things tended to get lost. That has now all been made silky smooth: upon clicking the button, a fresh tab will open in your browser, which will take you to the authentication page – be it on Google Drive, Dropbox, or somewhere else. When you are done, this tab is automagically closed, and you are back where you were, authenticated, with all your remote files at hand.

<img class="border" src="/images/blog/0.14/smooth-auth.png">

**Dropbox plugin**
Dropbox support made it into Uppy this release! 🎉 [Ife](https://github.com/ifedapoolarewaju) rocks like that. (A shoutout here as well to [Harry](https://github.com/hedgerh) for the initial work on Uppy Server and the Google Drive plugin!) Why don't you [give it a try](https://uppy.io/examples/dashboard/)!

<img class="border" src="/images/blog/0.14/uppy-dropbox.png">

What’s more, the client-side code of Google Drive and Dropbox plugins is slowly being refactored into a generic provider view that can be shared among all services.

## Dashboard

**Responsive UI and more icons**
The Dashboard now adapts itself to screen sizes big and small. That includes `inline` mode, where you can set `maxWidth` and `maxHeight` in options, like so:

```js
uppy.use(Dashboard, {
  maxWidth: 300,
  maxHeight: 350,
  inline: true,
  target: '#myUploadContainer'
})
```

We are not using media queries here, but have instead added a `UppyDashboard--wide` CSS class, which allows for more flexibility — your file uploading widget can be tiny even if the screen is large.

When there is little space available, the file grid view that you have become used to, will turn into a new compact list view.

<figure class="wide"><img src="/images/blog/0.14/dashboard-grid-list.jpg"></figure>

We are also adding more file type icons and trying to be smarter about detecting them. We have new icons for video, audio, text, and PDF for you to enjoy.

**Total / uploaded sizes**
Total and uploaded sizes have been added to the StatusBar, allowing you and your users to keep track of all those bits and bytes.

<img src="/images/blog/0.14/statusbar-uploaded-total-size.png">

You can play with all of these new features on [the Dashboard example page](https://uppy.io/examples/dashboard/).

<!-- more -->

## Per plugin locale settings

We have moved locale settings from global/core to plugins. By default, each UI plugin ships with an English locale, and you can override any string with your own, like so:

```js
uppy.use(DragDrop, {target: '.drop', locale: {
  strings: {
    chooseFile: 'Valitse tiedoston',
    orDragDrop: 'tai siirtää tänne',
  }
}})
```

<img src="/images/blog/0.14/dnd-fi.png">

And just like that, your Drag&Drop plugin now speaks Finnish! *Hyvää huomenta!* This feature is a work in progress, we are trying to find the sweet spot between [bundling a whole bunch of strings in packs](https://github.com/transloadit/uppy/blob/8c6252933813af69c1b71ec4621a7fc14dfb3ab0/src/locales/pt_BR.js), which might be redundant (i.e. if you only use the Drag&Drop, you don’t need strings from the Dashboard), and making you choose or set language strings for each UI plugin. We’d love to [hear what you think](https://github.com/transloadit/uppy/issues/42).

## Misc

- [yo-yoify](https://www.npmjs.com/package/yo-yoify) has been added to our build setup in order to solve a [Function.caller / strict mode issue](https://github.com/shama/bel#note) and to make the app faster/smaller by transforming template strings into pure and fast document calls.
- By the way, Uppy’s UI DOM is powered by [yo-yo](https://www.npmjs.com/package/yo-yo). We like yo-yo for its simplicity, speed and small size, but sometimes there are issues, one of them being the lack of wide adoption. We are looking at [Preact](https://preactjs.com/), but are also quite excited about [Nanocomponent](https://github.com/yoshuawuyts/nanocomponent).
- Progress events that were not being properly sent from Uppy Server as now fixed. As it turns out, this occurred because server uploads were happening too fast, before the client was actually able to connect to the server. :scream: Guess that’s a good problem to have solved!
- We have recently added Uppy to [Product Hunt](https://www.producthunt.com/posts/uppy) and we were very pleased with the warm welcome, we even made it to the front page a few days later. Let’s hope it will help get more people excited about the project.

## Release Notes

Here is the full list of changes for version 0.14:

- dashboard: use `isWide` prop/class instead of media queries, so that compact/mobile version can be used in bigger screens too (@arturi)
- dashboard: basic “list” view in addition to current “grid” view (@arturi)
- dashboard: more icons for file types (@arturi)
- dashboard: add totalSize and totalUploadedSize to StatusBar (@arturi)
- dashboard: figure out where to place Informer, accounting for StatusBar — over the StatusBar for now (@arturi)
- dashboard: add `<progress>` element for progress bar, like here https://overcast.fm/+BtuxMygVg/. Added hidden for now, for semantics/accessibility (@arturi)
- dragdrop: show number of selected files, remove upload btn (@arturi)
- build: exclude locales from build (@arturi)
- core: i18n for each plugin in options — local instead of global (@arturi)
- core: add default pluralization (can be overridden in plugin options) to Translator (@arturi)
- core: use yo-yoify to solve [Function.caller / strict mode issue](https://github.com/shama/bel#note) and make our app faster/smaller by transforming template strings into pure and fast document calls (@arturi)
- server: a pluggable uppy-server (express / koa for now) (@ifedapoolarewaju)
- server: standalone uppy-server (@ifedapoolarewaju)
- server: Integrate dropbox plugin (@ifedapoolarewaju)
- server: smooth authentication: after auth you are back in your app where you left, no page reloads (@ifedapoolarewaju)
- tus: fix upload progress from uppy-server (@arturi, @ifedapoolarewaju)
- core: basic React component — DnD (@arturi)
- core: fix support for both ES6 module import and CommonJS requires with `add-module-exports` babel plugin (@arturi)

## Feedback

We appreciate your feedback, feel free to [comment on GitHub](https://github.com/transloadit/uppy/issues/), send a PR, and hit us on [twitter](https://twitter.com/uppy_io).

The Uppy Team
