---
title: "Uppy 0.28: A look behind the scenes"
date: 2018-11-05
author: renee
image: "https://uppy.io/images/blog/0.28/dashboard-uploading.jpg"
published: true
---

<img class="border" src="/images/blog/0.28/dashboard-uploading.jpg">

In `0.28`, we are introducing a new “Single Upload” mode, improving on the Status Bar plugin with a spinner and different pause/resume/cancel buttons. We'll also share some progress on bringing back unified locale packs and a Transloadit Preset 🍁

<!--more-->

## Single Uploads

Uppy has been flexible about uploading lots of things from the start. You can add files at any time, even after uploads have already started. This is neat, but not always the desired behaviour: sometimes, you just want to upload a few files together with a form. In that case, it's useful to allow users to only upload a set of files _once_. 0.28.0 adds some options to help with that!

An upload in Uppy terminology can be more than one file. Users can add a bunch of files and when they press "Upload", all those files are bunched up into an upload. They can then add more files and press the "Upload" button again: the _new_ files are bunched into a second upload.

The new [`allowMultipleUploads`](https://uppy.io/docs/uppy/#allowMultipleUploads-true) option in Uppy Core can be set to `false` to only allow a single one of those uploads. Once an upload is started, the Dashboard and Status Bar no longer show "add files" and "upload" buttons. You can listen for a 'complete' event and then safely continue your app's form flow.

The Dashboard also has a new option: [`closeAfterFinish`](https://uppy.io/docs/dashboard/#closeAfterFinish-false). When `true`, the modal Dashboard will automatically hide once an upload has completed. You should only use this option in conjunction with `allowMultipleUploads`, otherwise it might close the Dashboard when the user isn't done yet! It can only be used with the modal Dashboard, when [`inline`](https://uppy.io/docs/dashboard/#inline-false) is set to `false`. "Closing" an inline Dashboard makes no sense :smile: You will see a warning in the console in both cases, so you don't have to remember all that.

Speaking of the Dashboard, it now also shows more statuses in the title bar: “Upload complete”, “Upload paused”, “Processing 5 files” and “Uploading 5 files”.

## Status Bar improvements

- ⚠️ **breaking** We’ve added separate options for hiding pause/resume and cancel buttons. So now there are several options for buttons: `hideUploadButton`, `hideRetryButton`, `hidePauseResumeButton` and `hideCancelButton`. These options can be passed from the Dashboard, if you are not using Status Bar separately (most common case). See the docs for more info: https://uppy.io/docs/status-bar/.
- The Status Bar now features a spinner animation when upload is in progress.
- Encoding (with the Transloadit plugin, for example) and uploading progress now get different colors, so it’s easier to tell what’s happening, visually.

<img class="border" style="border-top: 0;" src="/images/blog/0.28/status-bar-uploading.png">

<img class="border" style="border-top: 0;"  src="/images/blog/0.28/status-bar-paused.png">

<img class="border" style="border-top: 0;" src="/images/blog/0.28/status-bar-encoding.png">

<img class="border" style="border-top: 0;" src="/images/blog/0.28/status-bar-complete.png">

## Locale packs

In the beginning, we used to have unified locale packs for text strings in Uppy — English, Russian, German, Polish, etc. Then we made a switch to per-plugin locales, and the ability to load one file with locale strings in any language (locale pack) was lost for a while. This release is the first step in bringing this functionality back.

With this change, you can load a locale pack like so: `const uppy = Uppy({locale: german})`, then still override specific strings in a certain plugin, if needed:

```js
const uppy = Uppy({locale: german})
uppy.use(Dashboard, {
  trigger: '#pick-files',
  locale: {
    strings: {
      dropPasteImport: 'Something else here, %{browse} or this'
    }
  }
})
```

The benefit to this is that there will be a central point of configuration for languages, so there could be language packs with strings for, e.g., Czech at @uppy/lang-cz (or @uppy/langs/cz) that would be very easy to contribute to (or use).

After Uppy 0.28.0, this functionality is technically possible, but we still need to update and publish locale packs for multiple languages.

## Hosted Companion with Transloadit

When using remote providers such as Google Drive and Dropbox, so that your users can pick files from these sources, you can host [Companion](https://uppy.io/docs/companion/) yourself, or use the one provided by Transloadit. And to simplify the latter, you can now use `Transloadit.COMPANION` and `Transloadit.COMPANION_PATTERN` constants in remote provider options:

```js
const Dropbox = require('@uppy/dropbox')
const Transloadit = require('@uppy/transloadit')

uppy.use(Dropbox, {
  serverUrl: Transloadit.COMPANION
  serverPattern: Transloadit.COMPANION_PATTERN
})
```

Please see [Transloadit plugin documentation](https://uppy.io/docs/transloadit/) for more details.

## Transloadit Preset

Lately, we've been working on a wrapper package around Uppy and the [Transloadit plugin](https://uppy.io/docs/transloadit/) that will make common Transloadit-based workflows much simpler to implement. It's not ready just yet, but it should land in the next month!

This "preset" will provide three or so simple methods:

 - `transloadit.form()`, to enhance a form with existing file `<input>`s with Transloadit encoding capabilities, powered by Uppy's resilient uploading plugins
 - `transloadit.modal()`, to show a one-off modal Dashboard that uploads to Transloadit's encoding backend
 - `transloadit.upload()`, to instruct Uppy to upload files, using your own UI instead

Stay tuned!

## Other Cool Changes

- @uppy/core: ⚠️ **breaking** remove `upload-cancel` event, `file-removed` should be enough, see [#1069](https://github.com/transloadit/uppy/pull/1069) for details
- @uppy/companion: ⚠️ **breaking** Migrated provider adapter to Companion: saves 5KB on the frontend, all heavy lifting moved to the server side
- @uppy/companion: Removed an erroneous TypeScript dependency that added 40MB to the install size
- @uppy/thumbnail-generator: You can now constrain thumbnail height, thanks to @richartkeil, see [#1096](https://github.com/transloadit/uppy/pull/1096) for documentation (we are planning to add real Thumbnail Generator documentation soon, too!)
- @uppy/webcam: Fix getting data from Webcam recording if mime type includes codec metadata ([#1094](https://github.com/transloadit/uppy/pull/1094) / @goto-bus-stop)
- meta: Added integration tests (in real browsers, thanks to Sauce Labs) for @uppy/url, @uppy/transloadit and @uppy/thumbnail-generator 🚀

See [full changelog (0.28 and 0.27.x patches) for more](https://github.com/transloadit/uppy/blob/master/CHANGELOG.md#0280)

See you in the next release!

The Uppy Team
