---
title: "Uppy 0.30: Introducing Robodog"
date: 2019-03-06
author: renee
image: ""
published: false
---

In `0.30` we are introducing a new friend for Uppy — the Robodog.

<img src="/images/blog/0.30/robodog-assemble.jpg">
<small>Robodog: easy to assemble</small>

<!--more-->

## Robodog

You already know [Transloadit](https://transloadit.com), the company behind Uppy and [Tus](https://tus.io). TL;DR Transloadit is the Swiss Army Knife for your files: importing, resizing, croping and watermarking images, making GIFs, transcoding videos, extracting thumbnails, generating audio waveforms, and so much more is a breeze with Transloadit.

[Robodog](https://uppy.io/docs/robodog/) is a new Uppy-based library that has been trained to work with Transloadit API. It includes 3 components:

1. [File picker](https://uppy.io/docs/robodog/picker/) (using the Dashboard plugin you know and love for the modal UI) with support for imports from third-party services. Used for profile avatars or images to embed in a blog post.
2. [Form](https://uppy.io/docs/robodog/form/): integration with your existing HTML forms. Files will be uploaded to Transloadit, and the form will submit JSON information about the files and encoding results.
3. [Upload](https://uppy.io/docs/robodog/upload/): programmatic uploads — just call `transloadit.upload(files, opts)` and get an array of results back.

> Because Robodog is based on Uppy, you can add any existing Uppy plugin to add more functionality.

<img src="https://media.giphy.com/media/Eq7T3GwDAlggE/giphy.gif">

Here’s a demo:

<div class="wide">
  <p class="codepen" data-height="407" data-theme-id="light" data-default-tab="js,result" data-user="uppy" data-slug-hash="gEgPav" style="height: 400px; box-sizing: border-box; display: flex; align-items: center; justify-content: center; border: 2px solid black; margin: 1em 0; padding: 1em;" data-pen-title="Robodog: resizing and optimizng your avatar">
    <span>See the Pen <a href="https://codepen.io/uppy/pen/gEgPav/">
    Robodog: resizing and optimizng your avatar</a> by Uppy File Uploader (<a href="https://codepen.io/uppy">@uppy</a>)
    on <a href="https://codepen.io">CodePen</a>.</span>
  </p>
  <script async src="https://static.codepen.io/assets/embed/ei.js"></script>
</div>


You can install Robodog from NPM:

```shell
npm install --save @uppy/robodog
```

Or import it using an HTML script tag:

```html
<link rel="stylesheet" href="https://transloadit.edgly.net/releases/uppy/v0.30.2/robodog.min.css">
<script src="https://transloadit.edgly.net/releases/uppy/v0.30.2/robodog.min.js"></script>
```

<img src="https://media.giphy.com/media/MqGA1Za9ar6lG/giphy.gif">

## Dashboard Improvements

As usual, we are iterating and impoving the Dashboard plugin. The accessibility has been improved, along with icons, bredcrumbs in remote providers, the issue with `browserBackButton` and multiple modals, and more.

Oh, and we’ve also improved how the progress is reported when no progress reporting is available:

<img src="/images/blog/0.30/unknown-progress.gif">

## Upload Success

⚠️ Breaking

We’ve changed [`upload-success`](https://uppy.io/docs/uppy/#upload-success) and [`upload-error`](https://uppy.io/docs/uppy/#upload-error) signatures.

```js
uppy.on('upload-success', (file, responseObject) => {
  // responseObject (depending on the uploader plugin used, it might
  // contain less info, the example is for @uppy/xhr-upload):
  // {
  //   status, // HTTP status code (0, 200, 300)
  //   body, // response body
  //   uploadURL // the file url, if it was returned
  // }
})
```

```js
uppy.on('upload-error', (file, responseObject) => {
  // {
  //   status, // HTTP status code (0, 200, 300)
  //   body // response body
  // }
})
```

[See the docs](https://uppy.io/docs/uppy/) and [PR #1138](https://github.com/transloadit/uppy/pull/1138) for more details.

## Changelog

- @uppy/robodog: 📣⚠️ Add Robodog — Transloadit browser SDK (#1135 / @goto-bus-stop)
- @uppy/dashboard: fixed Issue with `browserBackButton` history and multiple modals (#1258 / @goto-bus-stop, @arturi)
- @uppy/core: Set response in Core rather than in upload plugins (#1138 / @arturi)
- @uppy/core: Don’t emit a complete event if an upload has been canceled (#1271 / @arturi)
- @uppy/companion: Support redis option (auth_pass, etc...) (#1215 / @tranvansang)
- @uppy/companion: sanitize text before adding to html (f77a102 / @ifedapoolarewaju)
- @uppy/dashboard: Update pause-resume-cancel icons (#1241 / @arturi, @nqst)
- @uppy/dashboard: Fix issues with multiple modals (#1258 / @goto-bus-stop, @arturi)
- @uppy/dashboard: Dashboard ui fixes: fix icon animation jiggling, inherit font, allow overriding outline, fix breadcrumbs, bug with x button being stuck, fix an issue with long note margin on mobile (#1279 / @arturi)
- @uppy/provider-views: update instagram nextPagePath after every fetch  (25e31e5 / @ifedapoolarewaju)
- @uppy/react: Allow changing instance in `uppy` prop (#1247 / @goto-bus-stop)
- @uppy/react: Typescript: Make DashboardModal.target prop optional (#1254 / @mattes3)
- @uppy/aws-s3: Use user provided filename / type for uploaded object, fixes #1238 (#1257 / @goto-bus-stop)
- @uppy/tus: Update to tus-js-client@1.6.0 with React Native support (#1250 / @arturi)
- build: Improve dev npm script: Use Parcel for bundled example, re-build lib automatically, don’t open browser and no ghosts mode, start companion when developing (but there’s optional npm run dev:no-companion) (#1280 / @arturi)
