# Pourquoi Bloc ?

> Bloc permet de séparer facilement la présentation de la logique métier, rendant votre code _rapide_, _facile à tester_ et _réutilisable_.

Lors de la construction d'applications de qualité de production, la gestion de l'état devient critique.

En tant que développeurs, nous voulons :

- savoir dans quel état est notre application à tout moment.
- testez facilement chaque cas pour nous assurer que notre application répond correctement.
- enregistrer chaque interaction d'utilisateur dans notre application afin que nous puissions prendre des décisions fondées sur des données.
- travailler aussi efficacement que possible et réutiliser les composants de notre application et dans d'autres applications.
- avoir de nombreux développeurs qui travaillent de manière transparente au sein d'une base de code unique, suivant les mêmes modèles et conventions.
- développer des applications rapides et réactives.

Bloc a été conçu pour répondre à tous ces besoins et à bien d'autres encore.

Il existe de nombreuses solutions de gestion de l'État et décider laquelle utiliser peut s'avérer une tâche ardue.

Bloc a été conçu avec ces trois valeurs fondamentales à l'esprit :

- Simple
  - Facile à comprendre et peut être utilisé par des développeurs de différents niveaux de compétences.
- Puissant
  - Aide à créer des applications étonnantes et complexes en les composant à partir de composants plus petits.
- Testable
  - Tester facilement chaque aspect d'une application pour que nous puissions l'itérer en toute confiance.

Bloc tente de rendre les changements d'état prévisibles en réglementant quand un changement d'état peut se produire et en appliquant une seule façon de changer d'état dans une application entière.