# Why Bloc?

> Bloc torna fácil separar _apresentação_ da _lógica de negócio_, deixando o seu código _rápido_, _fácil de testar_ e _reutilizável_.

Quando estamos construindo aplicações com qualidade de produção, gerenciar o estado é algo crítico.

Como desenvolvedores nós queremos:

- Saber qual o estado da aplicação a qualquer momento.
- Facilmente testar casos de teste para garantir que o app responda de forma apropriada.
- Gravar todas as interações do usuário na aplicação para que possamos tomar decisões com base em dados.
- Trabalhar da forma mais eficiente possível e reutilizar componentes dentro da aplicação e com outras aplicações.
- Ter vários desenvolvedores trabalhando continuamente com uma única base de código seguindo os mesmos padrões e convenções.
- Desenvolver apps rápidos e reativos.

Bloc foi pensado para atender todas essas necessidades e muitas outras.

Existem várias soluções de gerência de estado e decidir qual utilizar pode ser uma tarefa assustadora.

Bloc foi pensado com três valores principais em mente:

- Simples
  - Fácil de entender e pode ser utilizado por desenvolvedores de diferentes níveis de habilidade.
- Poderosa
  - Ajuda a construir aplicações incríveis e complexas decompondo-as em componentes menores.
- Testável
  - Teste facilmente todos os aspectos da aplicação para que possamos interagir com confiança.

Bloc tenta fazer mudanças de estado serem previsíveis ao regular quando uma mudança de estado pode acontecer e impondo uma única maneira de alterar estado na aplicação inteira.
