// Code generated by protoc-gen-gogo.
// source: api.proto
// DO NOT EDIT!

/*
	Package proto is a generated protocol buffer package.

	It is generated from these files:
		api.proto
		config.proto
		data.proto
		errors.proto
		gossip.proto
		heartbeat.proto
		internal.proto

	It has these top-level messages:
		ClientCmdID
		RequestHeader
		ResponseHeader
		ContainsRequest
		ContainsResponse
		GetRequest
		GetResponse
		PutRequest
		PutResponse
		ConditionalPutRequest
		ConditionalPutResponse
		IncrementRequest
		IncrementResponse
		DeleteRequest
		DeleteResponse
		DeleteRangeRequest
		DeleteRangeResponse
		ScanRequest
		ScanResponse
		EndTransactionRequest
		EndTransactionResponse
		ReapQueueRequest
		ReapQueueResponse
		EnqueueUpdateRequest
		EnqueueUpdateResponse
		EnqueueMessageRequest
		EnqueueMessageResponse
		RequestUnion
		ResponseUnion
		BatchRequest
		BatchResponse
		AdminSplitRequest
		AdminSplitResponse
		AdminMergeRequest
		AdminMergeResponse
*/
package proto

import proto1 "github.com/gogo/protobuf/proto"
import math "math"

// discarding unused import gogoproto "github.com/gogo/protobuf/gogoproto/gogo.pb"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto1.Marshal
var _ = math.Inf

// ClientCmdID provides a unique ID for client commands. Clients which
// provide ClientCmdID gain operation idempotence. In other words,
// clients can submit the same command multiple times and always
// receive the same response. This is common on retries over flaky
// networks. However, the system imposes a limit on how long
// idempotence is provided. Retries over an hour old are not
// guaranteed idempotence and may be executed more than once with
// potentially different results.
//
// ClientCmdID contains the client's timestamp and a client-generated
// random number. The client Timestamp is specified in unix
// nanoseconds and is used for some uniqueness but also to provide a
// rough ordering of requests, useful for data locality on the
// server. The Random is specified for additional uniqueness.
// NOTE: An accurate time signal IS NOT required for correctness.
type ClientCmdID struct {
	// Nanoseconds since Unix epoch.
	WallTime         int64  `protobuf:"varint,1,opt,name=wall_time" json:"wall_time"`
	Random           int64  `protobuf:"varint,2,opt,name=random" json:"random"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ClientCmdID) Reset()         { *m = ClientCmdID{} }
func (m *ClientCmdID) String() string { return proto1.CompactTextString(m) }
func (*ClientCmdID) ProtoMessage()    {}

func (m *ClientCmdID) GetWallTime() int64 {
	if m != nil {
		return m.WallTime
	}
	return 0
}

func (m *ClientCmdID) GetRandom() int64 {
	if m != nil {
		return m.Random
	}
	return 0
}

// RequestHeader is supplied with every storage node request.
type RequestHeader struct {
	// Timestamp specifies time at which read or writes should be
	// performed. If the timestamp is set to zero value, its value
	// is initialized to the wall time of the receiving node.
	Timestamp Timestamp `protobuf:"bytes,1,opt,name=timestamp" json:"timestamp"`
	// CmdID is optionally specified for request idempotence
	// (i.e. replay protection).
	CmdID ClientCmdID `protobuf:"bytes,2,opt,name=cmd_id" json:"cmd_id"`
	// The key for request. If the request operates on a range, this
	// represents the starting key for the range.
	Key Key `protobuf:"bytes,3,opt,name=key,customtype=Key" json:"key"`
	// End key is empty if request spans only a single key.
	EndKey Key `protobuf:"bytes,4,opt,name=end_key,customtype=Key" json:"end_key"`
	// User is the originating user. Used to lookup priority when
	// scheduling queued operations at target node.
	User string `protobuf:"bytes,5,opt,name=user" json:"user"`
	// Replica specifies the destination for the request. This is a specific
	// instance of the available replicas belonging to RangeID.
	Replica Replica `protobuf:"bytes,6,opt,name=replica" json:"replica"`
	// RaftID specifies the ID of the Raft consensus group which the key
	// range belongs to. This is used by the receiving node to route the
	// request to the correct range.
	RaftID int64 `protobuf:"varint,7,opt,name=raft_id" json:"raft_id"`
	// UserPriority specifies priority multiple for non-transactional
	// commands. This value should be a positive integer [1, 2^31-1).
	// It's properly viewed as a multiple for how likely this
	// transaction will be to prevail if a write conflict occurs.
	// Commands with UserPriority=100 will be 100x less likely to be
	// aborted as conflicting transactions or non-transactional commands
	// with UserPriority=1. This value is ignored if Txn is
	// specified. If neither this value nor Txn is specified, the value
	// defaults to 1.
	UserPriority *int32 `protobuf:"varint,8,opt,name=user_priority,def=1" json:"user_priority,omitempty"`
	// Txn is set non-nil if a transaction is underway. To start a txn,
	// the first request should set this field to non-nil with name and
	// isolation level set as desired. The response will contain the
	// fully-initialized transaction with txn ID, priority, initial
	// timestamp, and maximum timestamp.
	Txn              *Transaction `protobuf:"bytes,9,opt,name=txn" json:"txn,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *RequestHeader) Reset()         { *m = RequestHeader{} }
func (m *RequestHeader) String() string { return proto1.CompactTextString(m) }
func (*RequestHeader) ProtoMessage()    {}

const Default_RequestHeader_UserPriority int32 = 1

func (m *RequestHeader) GetTimestamp() Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return Timestamp{}
}

func (m *RequestHeader) GetCmdID() ClientCmdID {
	if m != nil {
		return m.CmdID
	}
	return ClientCmdID{}
}

func (m *RequestHeader) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

func (m *RequestHeader) GetReplica() Replica {
	if m != nil {
		return m.Replica
	}
	return Replica{}
}

func (m *RequestHeader) GetRaftID() int64 {
	if m != nil {
		return m.RaftID
	}
	return 0
}

func (m *RequestHeader) GetUserPriority() int32 {
	if m != nil && m.UserPriority != nil {
		return *m.UserPriority
	}
	return Default_RequestHeader_UserPriority
}

func (m *RequestHeader) GetTxn() *Transaction {
	if m != nil {
		return m.Txn
	}
	return nil
}

// ResponseHeader is returned with every storage node response.
type ResponseHeader struct {
	// Error is non-nil if an error occurred.
	Error *Error `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// Timestamp specifies time at which read or write actually was
	// performed. In the case of both reads and writes, if the timestamp
	// supplied to the request was 0, the wall time of the node
	// servicing the request will be set here. Additionally, in the case
	// of writes, this value may be increased from the timestamp passed
	// with the RequestHeader if the key being written was either read
	// or written more recently.
	Timestamp Timestamp `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp"`
	// Transaction is non-nil if the request specified a non-nil
	// transaction. The transaction timestamp and/or priority may have
	// been updated, depending on the outcome of the request.
	Txn              *Transaction `protobuf:"bytes,3,opt,name=txn" json:"txn,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *ResponseHeader) Reset()         { *m = ResponseHeader{} }
func (m *ResponseHeader) String() string { return proto1.CompactTextString(m) }
func (*ResponseHeader) ProtoMessage()    {}

func (m *ResponseHeader) GetError() *Error {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *ResponseHeader) GetTimestamp() Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return Timestamp{}
}

func (m *ResponseHeader) GetTxn() *Transaction {
	if m != nil {
		return m.Txn
	}
	return nil
}

// A ContainsRequest is arguments to the Contains() method.
type ContainsRequest struct {
	RequestHeader    `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ContainsRequest) Reset()         { *m = ContainsRequest{} }
func (m *ContainsRequest) String() string { return proto1.CompactTextString(m) }
func (*ContainsRequest) ProtoMessage()    {}

// A ContainsResponse is the return value of the Contains() method.
type ContainsResponse struct {
	ResponseHeader   `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Exists           bool   `protobuf:"varint,2,opt,name=exists" json:"exists"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ContainsResponse) Reset()         { *m = ContainsResponse{} }
func (m *ContainsResponse) String() string { return proto1.CompactTextString(m) }
func (*ContainsResponse) ProtoMessage()    {}

func (m *ContainsResponse) GetExists() bool {
	if m != nil {
		return m.Exists
	}
	return false
}

// A GetRequest is arguments to the Get() method.
type GetRequest struct {
	RequestHeader    `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *GetRequest) Reset()         { *m = GetRequest{} }
func (m *GetRequest) String() string { return proto1.CompactTextString(m) }
func (*GetRequest) ProtoMessage()    {}

// A GetResponse is the return value from the Get() method.
// If the key doesn't exist, returns nil for Value.Bytes.
type GetResponse struct {
	ResponseHeader   `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Value            *Value `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *GetResponse) Reset()         { *m = GetResponse{} }
func (m *GetResponse) String() string { return proto1.CompactTextString(m) }
func (*GetResponse) ProtoMessage()    {}

func (m *GetResponse) GetValue() *Value {
	if m != nil {
		return m.Value
	}
	return nil
}

// A PutRequest is arguments to the Put() method. Note that to write
// an empty value, the value parameter is still specified, but both
// Bytes and Integer are set to nil.
type PutRequest struct {
	RequestHeader    `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Value            Value  `protobuf:"bytes,2,opt,name=value" json:"value"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *PutRequest) Reset()         { *m = PutRequest{} }
func (m *PutRequest) String() string { return proto1.CompactTextString(m) }
func (*PutRequest) ProtoMessage()    {}

func (m *PutRequest) GetValue() Value {
	if m != nil {
		return m.Value
	}
	return Value{}
}

// A PutResponse is the return value from the Put() method.
type PutResponse struct {
	ResponseHeader   `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *PutResponse) Reset()         { *m = PutResponse{} }
func (m *PutResponse) String() string { return proto1.CompactTextString(m) }
func (*PutResponse) ProtoMessage()    {}

// A ConditionalPutRequest is arguments to the ConditionalPut() method.
//
// - Returns true and sets value if ExpValue equals existing value.
// - If key doesn't exist and ExpValue is nil, sets value.
// - If key exists, but value is empty and ExpValue is not nil but empty, sets value.
// - Otherwise, returns error and the actual value of the key in the response.
type ConditionalPutRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// The value to put.
	Value Value `protobuf:"bytes,2,opt,name=value" json:"value"`
	// ExpValue.Bytes empty to test for non-existence. Specify as nil
	// to indicate there should be no existing entry. This is different
	// from the expectation that the value exists but is empty.
	ExpValue         *Value `protobuf:"bytes,3,opt,name=exp_value" json:"exp_value,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ConditionalPutRequest) Reset()         { *m = ConditionalPutRequest{} }
func (m *ConditionalPutRequest) String() string { return proto1.CompactTextString(m) }
func (*ConditionalPutRequest) ProtoMessage()    {}

func (m *ConditionalPutRequest) GetValue() Value {
	if m != nil {
		return m.Value
	}
	return Value{}
}

func (m *ConditionalPutRequest) GetExpValue() *Value {
	if m != nil {
		return m.ExpValue
	}
	return nil
}

// A ConditionalPutResponse is the return value from the
// ConditionalPut() method.
type ConditionalPutResponse struct {
	ResponseHeader   `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ConditionalPutResponse) Reset()         { *m = ConditionalPutResponse{} }
func (m *ConditionalPutResponse) String() string { return proto1.CompactTextString(m) }
func (*ConditionalPutResponse) ProtoMessage()    {}

// An IncrementRequest is arguments to the Increment() method. It
// increments the value for key, and returns the new value. If no
// value exists for a key, incrementing by 0 is not a noop, but will
// create a zero value. IncrementRequest cannot be called on a key set
// by Put() or ConditionalPut(). Similarly, Get(), Put() and
// ConditionalPut() cannot be invoked on an incremented key.
type IncrementRequest struct {
	RequestHeader    `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Increment        int64  `protobuf:"varint,2,opt,name=increment" json:"increment"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *IncrementRequest) Reset()         { *m = IncrementRequest{} }
func (m *IncrementRequest) String() string { return proto1.CompactTextString(m) }
func (*IncrementRequest) ProtoMessage()    {}

func (m *IncrementRequest) GetIncrement() int64 {
	if m != nil {
		return m.Increment
	}
	return 0
}

// An IncrementResponse is the return value from the Increment
// method. The new value after increment is specified in NewValue. If
// the value could not be decoded as specified, Error will be set.
type IncrementResponse struct {
	ResponseHeader   `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	NewValue         int64  `protobuf:"varint,2,opt,name=new_value" json:"new_value"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *IncrementResponse) Reset()         { *m = IncrementResponse{} }
func (m *IncrementResponse) String() string { return proto1.CompactTextString(m) }
func (*IncrementResponse) ProtoMessage()    {}

func (m *IncrementResponse) GetNewValue() int64 {
	if m != nil {
		return m.NewValue
	}
	return 0
}

// A DeleteRequest is arguments to the Delete() method.
type DeleteRequest struct {
	RequestHeader    `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *DeleteRequest) Reset()         { *m = DeleteRequest{} }
func (m *DeleteRequest) String() string { return proto1.CompactTextString(m) }
func (*DeleteRequest) ProtoMessage()    {}

// A DeleteResponse is the return value from the Delete() method.
type DeleteResponse struct {
	ResponseHeader   `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *DeleteResponse) Reset()         { *m = DeleteResponse{} }
func (m *DeleteResponse) String() string { return proto1.CompactTextString(m) }
func (*DeleteResponse) ProtoMessage()    {}

// A DeleteRangeRequest is arguments to the DeleteRange method. It
// specifies the range of keys to delete.
type DeleteRangeRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// If 0, *all* entries between Key (inclusive) and EndKey
	// (exclusive) are deleted. Must be >= 0
	MaxEntriesToDelete int64  `protobuf:"varint,2,opt,name=max_entries_to_delete" json:"max_entries_to_delete"`
	XXX_unrecognized   []byte `json:"-"`
}

func (m *DeleteRangeRequest) Reset()         { *m = DeleteRangeRequest{} }
func (m *DeleteRangeRequest) String() string { return proto1.CompactTextString(m) }
func (*DeleteRangeRequest) ProtoMessage()    {}

func (m *DeleteRangeRequest) GetMaxEntriesToDelete() int64 {
	if m != nil {
		return m.MaxEntriesToDelete
	}
	return 0
}

// A DeleteRangeResponse is the return value from the DeleteRange()
// method.
type DeleteRangeResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// Number of entries removed.
	NumDeleted       int64  `protobuf:"varint,2,opt,name=num_deleted" json:"num_deleted"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *DeleteRangeResponse) Reset()         { *m = DeleteRangeResponse{} }
func (m *DeleteRangeResponse) String() string { return proto1.CompactTextString(m) }
func (*DeleteRangeResponse) ProtoMessage()    {}

func (m *DeleteRangeResponse) GetNumDeleted() int64 {
	if m != nil {
		return m.NumDeleted
	}
	return 0
}

// A ScanRequest is arguments to the Scan() method. It specifies the
// start and end keys for the scan and the maximum number of results.
type ScanRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// Must be > 0.
	MaxResults       int64  `protobuf:"varint,2,opt,name=max_results" json:"max_results"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ScanRequest) Reset()         { *m = ScanRequest{} }
func (m *ScanRequest) String() string { return proto1.CompactTextString(m) }
func (*ScanRequest) ProtoMessage()    {}

func (m *ScanRequest) GetMaxResults() int64 {
	if m != nil {
		return m.MaxResults
	}
	return 0
}

// A ScanResponse is the return value from the Scan() method.
type ScanResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// Empty if no rows were scanned.
	Rows             []KeyValue `protobuf:"bytes,2,rep,name=rows" json:"rows"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *ScanResponse) Reset()         { *m = ScanResponse{} }
func (m *ScanResponse) String() string { return proto1.CompactTextString(m) }
func (*ScanResponse) ProtoMessage()    {}

func (m *ScanResponse) GetRows() []KeyValue {
	if m != nil {
		return m.Rows
	}
	return nil
}

// An EndTransactionRequest is arguments to the EndTransaction() method.
// It specifies whether to commit or roll back an extant transaction.
type EndTransactionRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// False to abort and rollback.
	Commit bool `protobuf:"varint,2,opt,name=commit" json:"commit"`
	// Optional commit triggers. Note that commit triggers are for
	// internal use only and will be ignored if requested through the
	// public-facing KV API.
	SplitTrigger     *SplitTrigger `protobuf:"bytes,3,opt,name=split_trigger" json:"split_trigger,omitempty"`
	MergeTrigger     *MergeTrigger `protobuf:"bytes,4,opt,name=merge_trigger" json:"merge_trigger,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *EndTransactionRequest) Reset()         { *m = EndTransactionRequest{} }
func (m *EndTransactionRequest) String() string { return proto1.CompactTextString(m) }
func (*EndTransactionRequest) ProtoMessage()    {}

func (m *EndTransactionRequest) GetCommit() bool {
	if m != nil {
		return m.Commit
	}
	return false
}

func (m *EndTransactionRequest) GetSplitTrigger() *SplitTrigger {
	if m != nil {
		return m.SplitTrigger
	}
	return nil
}

func (m *EndTransactionRequest) GetMergeTrigger() *MergeTrigger {
	if m != nil {
		return m.MergeTrigger
	}
	return nil
}

// An EndTransactionResponse is the return value from the
// EndTransaction() method. The final transaction record is returned
// as part of the response header. In particular, transaction status
// and timestamp will be updated to reflect final committed
// values. Clients may propagate the transaction timestamp as the
// final txn commit timestamp in order to preserve causal ordering
// between subsequent transactions. CommitWait specifies the commit
// wait, which is the remaining time the client MUST wait before
// signalling completion of the transaction to another distributed
// node to maintain consistency.
type EndTransactionResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// Remaining time (ns).
	CommitWait       int64  `protobuf:"varint,2,opt,name=commit_wait" json:"commit_wait"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *EndTransactionResponse) Reset()         { *m = EndTransactionResponse{} }
func (m *EndTransactionResponse) String() string { return proto1.CompactTextString(m) }
func (*EndTransactionResponse) ProtoMessage()    {}

func (m *EndTransactionResponse) GetCommitWait() int64 {
	if m != nil {
		return m.CommitWait
	}
	return 0
}

// A ReapQueueRequest is arguments to the ReapQueue() method. It
// specifies the recipient inbox key to which messages are waiting
// to be reapted and also the maximum number of results to return.
type ReapQueueRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// Maximum results to return; must be > 0.
	MaxResults       int64  `protobuf:"varint,2,opt,name=max_results" json:"max_results"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ReapQueueRequest) Reset()         { *m = ReapQueueRequest{} }
func (m *ReapQueueRequest) String() string { return proto1.CompactTextString(m) }
func (*ReapQueueRequest) ProtoMessage()    {}

func (m *ReapQueueRequest) GetMaxResults() int64 {
	if m != nil {
		return m.MaxResults
	}
	return 0
}

// A ReapQueueResponse is the return value from the ReapQueue() method.
type ReapQueueResponse struct {
	ResponseHeader   `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Messages         []Value `protobuf:"bytes,2,rep,name=messages" json:"messages"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ReapQueueResponse) Reset()         { *m = ReapQueueResponse{} }
func (m *ReapQueueResponse) String() string { return proto1.CompactTextString(m) }
func (*ReapQueueResponse) ProtoMessage()    {}

func (m *ReapQueueResponse) GetMessages() []Value {
	if m != nil {
		return m.Messages
	}
	return nil
}

// An EnqueueUpdateRequest is arguments to the EnqueueUpdate() method.
// It specifies the update to enqueue for asynchronous execution.
// Update is an instance of one of the following messages: PutRequest,
// IncrementRequest, DeleteRequest, DeleteRangeRequest, or
// AccountingRequest.
type EnqueueUpdateRequest struct {
	RequestHeader    `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *EnqueueUpdateRequest) Reset()         { *m = EnqueueUpdateRequest{} }
func (m *EnqueueUpdateRequest) String() string { return proto1.CompactTextString(m) }
func (*EnqueueUpdateRequest) ProtoMessage()    {}

// An EnqueueUpdateResponse is the return value from the
// EnqueueUpdate() method.
type EnqueueUpdateResponse struct {
	ResponseHeader   `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *EnqueueUpdateResponse) Reset()         { *m = EnqueueUpdateResponse{} }
func (m *EnqueueUpdateResponse) String() string { return proto1.CompactTextString(m) }
func (*EnqueueUpdateResponse) ProtoMessage()    {}

// An EnqueueMessageRequest is arguments to the EnqueueMessage() method.
// It specifies the recipient inbox key and the message (an arbitrary
// byte slice value).
type EnqueueMessageRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// Message value to delivery to inbox.
	Msg              Value  `protobuf:"bytes,2,opt,name=msg" json:"msg"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *EnqueueMessageRequest) Reset()         { *m = EnqueueMessageRequest{} }
func (m *EnqueueMessageRequest) String() string { return proto1.CompactTextString(m) }
func (*EnqueueMessageRequest) ProtoMessage()    {}

func (m *EnqueueMessageRequest) GetMsg() Value {
	if m != nil {
		return m.Msg
	}
	return Value{}
}

// An EnqueueMessageResponse is the return value from the
// EnqueueMessage() method.
type EnqueueMessageResponse struct {
	ResponseHeader   `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *EnqueueMessageResponse) Reset()         { *m = EnqueueMessageResponse{} }
func (m *EnqueueMessageResponse) String() string { return proto1.CompactTextString(m) }
func (*EnqueueMessageResponse) ProtoMessage()    {}

// A RequestUnion contains exactly one of the optional requests.
type RequestUnion struct {
	Contains         *ContainsRequest       `protobuf:"bytes,1,opt,name=contains" json:"contains,omitempty"`
	Get              *GetRequest            `protobuf:"bytes,2,opt,name=get" json:"get,omitempty"`
	Put              *PutRequest            `protobuf:"bytes,3,opt,name=put" json:"put,omitempty"`
	ConditionalPut   *ConditionalPutRequest `protobuf:"bytes,4,opt,name=conditional_put" json:"conditional_put,omitempty"`
	Increment        *IncrementRequest      `protobuf:"bytes,5,opt,name=increment" json:"increment,omitempty"`
	Delete           *DeleteRequest         `protobuf:"bytes,6,opt,name=delete" json:"delete,omitempty"`
	DeleteRange      *DeleteRangeRequest    `protobuf:"bytes,7,opt,name=delete_range" json:"delete_range,omitempty"`
	Scan             *ScanRequest           `protobuf:"bytes,8,opt,name=scan" json:"scan,omitempty"`
	EndTransaction   *EndTransactionRequest `protobuf:"bytes,9,opt,name=end_transaction" json:"end_transaction,omitempty"`
	ReapQueue        *ReapQueueRequest      `protobuf:"bytes,10,opt,name=reap_queue" json:"reap_queue,omitempty"`
	EnqueueUpdate    *EnqueueUpdateRequest  `protobuf:"bytes,11,opt,name=enqueue_update" json:"enqueue_update,omitempty"`
	EnqueueMessage   *EnqueueMessageRequest `protobuf:"bytes,12,opt,name=enqueue_message" json:"enqueue_message,omitempty"`
	XXX_unrecognized []byte                 `json:"-"`
}

func (m *RequestUnion) Reset()         { *m = RequestUnion{} }
func (m *RequestUnion) String() string { return proto1.CompactTextString(m) }
func (*RequestUnion) ProtoMessage()    {}

func (m *RequestUnion) GetContains() *ContainsRequest {
	if m != nil {
		return m.Contains
	}
	return nil
}

func (m *RequestUnion) GetGet() *GetRequest {
	if m != nil {
		return m.Get
	}
	return nil
}

func (m *RequestUnion) GetPut() *PutRequest {
	if m != nil {
		return m.Put
	}
	return nil
}

func (m *RequestUnion) GetConditionalPut() *ConditionalPutRequest {
	if m != nil {
		return m.ConditionalPut
	}
	return nil
}

func (m *RequestUnion) GetIncrement() *IncrementRequest {
	if m != nil {
		return m.Increment
	}
	return nil
}

func (m *RequestUnion) GetDelete() *DeleteRequest {
	if m != nil {
		return m.Delete
	}
	return nil
}

func (m *RequestUnion) GetDeleteRange() *DeleteRangeRequest {
	if m != nil {
		return m.DeleteRange
	}
	return nil
}

func (m *RequestUnion) GetScan() *ScanRequest {
	if m != nil {
		return m.Scan
	}
	return nil
}

func (m *RequestUnion) GetEndTransaction() *EndTransactionRequest {
	if m != nil {
		return m.EndTransaction
	}
	return nil
}

func (m *RequestUnion) GetReapQueue() *ReapQueueRequest {
	if m != nil {
		return m.ReapQueue
	}
	return nil
}

func (m *RequestUnion) GetEnqueueUpdate() *EnqueueUpdateRequest {
	if m != nil {
		return m.EnqueueUpdate
	}
	return nil
}

func (m *RequestUnion) GetEnqueueMessage() *EnqueueMessageRequest {
	if m != nil {
		return m.EnqueueMessage
	}
	return nil
}

// A ResponseUnion contains exactly one of the optional responses.
type ResponseUnion struct {
	Contains         *ContainsResponse       `protobuf:"bytes,1,opt,name=contains" json:"contains,omitempty"`
	Get              *GetResponse            `protobuf:"bytes,2,opt,name=get" json:"get,omitempty"`
	Put              *PutResponse            `protobuf:"bytes,3,opt,name=put" json:"put,omitempty"`
	ConditionalPut   *ConditionalPutResponse `protobuf:"bytes,4,opt,name=conditional_put" json:"conditional_put,omitempty"`
	Increment        *IncrementResponse      `protobuf:"bytes,5,opt,name=increment" json:"increment,omitempty"`
	Delete           *DeleteResponse         `protobuf:"bytes,6,opt,name=delete" json:"delete,omitempty"`
	DeleteRange      *DeleteRangeResponse    `protobuf:"bytes,7,opt,name=delete_range" json:"delete_range,omitempty"`
	Scan             *ScanResponse           `protobuf:"bytes,8,opt,name=scan" json:"scan,omitempty"`
	EndTransaction   *EndTransactionResponse `protobuf:"bytes,9,opt,name=end_transaction" json:"end_transaction,omitempty"`
	ReapQueue        *ReapQueueResponse      `protobuf:"bytes,10,opt,name=reap_queue" json:"reap_queue,omitempty"`
	EnqueueUpdate    *EnqueueUpdateResponse  `protobuf:"bytes,11,opt,name=enqueue_update" json:"enqueue_update,omitempty"`
	EnqueueMessage   *EnqueueMessageResponse `protobuf:"bytes,12,opt,name=enqueue_message" json:"enqueue_message,omitempty"`
	XXX_unrecognized []byte                  `json:"-"`
}

func (m *ResponseUnion) Reset()         { *m = ResponseUnion{} }
func (m *ResponseUnion) String() string { return proto1.CompactTextString(m) }
func (*ResponseUnion) ProtoMessage()    {}

func (m *ResponseUnion) GetContains() *ContainsResponse {
	if m != nil {
		return m.Contains
	}
	return nil
}

func (m *ResponseUnion) GetGet() *GetResponse {
	if m != nil {
		return m.Get
	}
	return nil
}

func (m *ResponseUnion) GetPut() *PutResponse {
	if m != nil {
		return m.Put
	}
	return nil
}

func (m *ResponseUnion) GetConditionalPut() *ConditionalPutResponse {
	if m != nil {
		return m.ConditionalPut
	}
	return nil
}

func (m *ResponseUnion) GetIncrement() *IncrementResponse {
	if m != nil {
		return m.Increment
	}
	return nil
}

func (m *ResponseUnion) GetDelete() *DeleteResponse {
	if m != nil {
		return m.Delete
	}
	return nil
}

func (m *ResponseUnion) GetDeleteRange() *DeleteRangeResponse {
	if m != nil {
		return m.DeleteRange
	}
	return nil
}

func (m *ResponseUnion) GetScan() *ScanResponse {
	if m != nil {
		return m.Scan
	}
	return nil
}

func (m *ResponseUnion) GetEndTransaction() *EndTransactionResponse {
	if m != nil {
		return m.EndTransaction
	}
	return nil
}

func (m *ResponseUnion) GetReapQueue() *ReapQueueResponse {
	if m != nil {
		return m.ReapQueue
	}
	return nil
}

func (m *ResponseUnion) GetEnqueueUpdate() *EnqueueUpdateResponse {
	if m != nil {
		return m.EnqueueUpdate
	}
	return nil
}

func (m *ResponseUnion) GetEnqueueMessage() *EnqueueMessageResponse {
	if m != nil {
		return m.EnqueueMessage
	}
	return nil
}

// A BatchRequest contains one or more requests to be executed in
// parallel, or if applicable (based on write-only commands and
// range-locality), as a single update.
type BatchRequest struct {
	RequestHeader    `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Requests         []RequestUnion `protobuf:"bytes,2,rep,name=requests" json:"requests"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *BatchRequest) Reset()         { *m = BatchRequest{} }
func (m *BatchRequest) String() string { return proto1.CompactTextString(m) }
func (*BatchRequest) ProtoMessage()    {}

func (m *BatchRequest) GetRequests() []RequestUnion {
	if m != nil {
		return m.Requests
	}
	return nil
}

// A BatchResponse contains one or more responses, one per request
// corresponding to the requests in the matching BatchRequest. The
// error in the response header is set to the first error from the
// slice of responses, if applicable.
type BatchResponse struct {
	ResponseHeader   `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Responses        []ResponseUnion `protobuf:"bytes,2,rep,name=responses" json:"responses"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *BatchResponse) Reset()         { *m = BatchResponse{} }
func (m *BatchResponse) String() string { return proto1.CompactTextString(m) }
func (*BatchResponse) ProtoMessage()    {}

func (m *BatchResponse) GetResponses() []ResponseUnion {
	if m != nil {
		return m.Responses
	}
	return nil
}

// An AdminSplitRequest is arguments to the AdminSplit() method. The
// existing range which contains RequestHeader.Key is split by
// split_key. If split_key is not specified, then this method will
// determine a split key that is roughly halfway through the
// range. The existing range is resized to cover only its start key to
// the split key. The new range created by the split starts at the
// split key and extends to the original range's end key. If split_key
// is known, header.key should also be set to split_key.
//
// New range IDs for each of the split range's replica and a new Raft
// ID are generated by the operation. Split requests are done in the
// context of a distributed transaction which updates range addressing
// records, range metadata and finally, provides a commit trigger to
// update bookkeeping and instantiate the new range on commit.
//
// The new range contains range replicas located on the same stores;
// no range data is moved during this operation. The split can be
// thought of as a mostly logical operation, though some other
// metadata (e.g. response cache and range stats must be copied or
// recomputed).
type AdminSplitRequest struct {
	RequestHeader    `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	SplitKey         Key    `protobuf:"bytes,2,opt,name=split_key,customtype=Key" json:"split_key"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *AdminSplitRequest) Reset()         { *m = AdminSplitRequest{} }
func (m *AdminSplitRequest) String() string { return proto1.CompactTextString(m) }
func (*AdminSplitRequest) ProtoMessage()    {}

// An AdminSplitResponse is the return value from the AdminSplit()
// method.
type AdminSplitResponse struct {
	ResponseHeader   `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *AdminSplitResponse) Reset()         { *m = AdminSplitResponse{} }
func (m *AdminSplitResponse) String() string { return proto1.CompactTextString(m) }
func (*AdminSplitResponse) ProtoMessage()    {}

// An AdminMergeRequest is arguments to the AdminMerge() method. A
// merge is always performed by calling AdminMerge on the range
// that is subsuming the passed in subsumed_range. The ranges must
// be consecutive in the key space, such that the end_key of the
// subsuming range must match the start_key of the range being subsumed.
// After the merge operation, the subsumed_range will no longer exist and
// the subsuming range will now encompass all keys from its original
// start_key to the end_key of the subsumed_range.
type AdminMergeRequest struct {
	RequestHeader    `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	SubsumedRange    RangeDescriptor `protobuf:"bytes,2,opt,name=subsumed_range" json:"subsumed_range"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *AdminMergeRequest) Reset()         { *m = AdminMergeRequest{} }
func (m *AdminMergeRequest) String() string { return proto1.CompactTextString(m) }
func (*AdminMergeRequest) ProtoMessage()    {}

func (m *AdminMergeRequest) GetSubsumedRange() RangeDescriptor {
	if m != nil {
		return m.SubsumedRange
	}
	return RangeDescriptor{}
}

// An AdminMergeResponse is the return value from the AdminMerge()
// method.
type AdminMergeResponse struct {
	ResponseHeader   `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *AdminMergeResponse) Reset()         { *m = AdminMergeResponse{} }
func (m *AdminMergeResponse) String() string { return proto1.CompactTextString(m) }
func (*AdminMergeResponse) ProtoMessage()    {}

func init() {
}
func (this *RequestUnion) GetValue() interface{} {
	if this.Contains != nil {
		return this.Contains
	}
	if this.Get != nil {
		return this.Get
	}
	if this.Put != nil {
		return this.Put
	}
	if this.ConditionalPut != nil {
		return this.ConditionalPut
	}
	if this.Increment != nil {
		return this.Increment
	}
	if this.Delete != nil {
		return this.Delete
	}
	if this.DeleteRange != nil {
		return this.DeleteRange
	}
	if this.Scan != nil {
		return this.Scan
	}
	if this.EndTransaction != nil {
		return this.EndTransaction
	}
	if this.ReapQueue != nil {
		return this.ReapQueue
	}
	if this.EnqueueUpdate != nil {
		return this.EnqueueUpdate
	}
	if this.EnqueueMessage != nil {
		return this.EnqueueMessage
	}
	return nil
}

func (this *RequestUnion) SetValue(value interface{}) bool {
	switch vt := value.(type) {
	case *ContainsRequest:
		this.Contains = vt
	case *GetRequest:
		this.Get = vt
	case *PutRequest:
		this.Put = vt
	case *ConditionalPutRequest:
		this.ConditionalPut = vt
	case *IncrementRequest:
		this.Increment = vt
	case *DeleteRequest:
		this.Delete = vt
	case *DeleteRangeRequest:
		this.DeleteRange = vt
	case *ScanRequest:
		this.Scan = vt
	case *EndTransactionRequest:
		this.EndTransaction = vt
	case *ReapQueueRequest:
		this.ReapQueue = vt
	case *EnqueueUpdateRequest:
		this.EnqueueUpdate = vt
	case *EnqueueMessageRequest:
		this.EnqueueMessage = vt
	default:
		return false
	}
	return true
}
func (this *ResponseUnion) GetValue() interface{} {
	if this.Contains != nil {
		return this.Contains
	}
	if this.Get != nil {
		return this.Get
	}
	if this.Put != nil {
		return this.Put
	}
	if this.ConditionalPut != nil {
		return this.ConditionalPut
	}
	if this.Increment != nil {
		return this.Increment
	}
	if this.Delete != nil {
		return this.Delete
	}
	if this.DeleteRange != nil {
		return this.DeleteRange
	}
	if this.Scan != nil {
		return this.Scan
	}
	if this.EndTransaction != nil {
		return this.EndTransaction
	}
	if this.ReapQueue != nil {
		return this.ReapQueue
	}
	if this.EnqueueUpdate != nil {
		return this.EnqueueUpdate
	}
	if this.EnqueueMessage != nil {
		return this.EnqueueMessage
	}
	return nil
}

func (this *ResponseUnion) SetValue(value interface{}) bool {
	switch vt := value.(type) {
	case *ContainsResponse:
		this.Contains = vt
	case *GetResponse:
		this.Get = vt
	case *PutResponse:
		this.Put = vt
	case *ConditionalPutResponse:
		this.ConditionalPut = vt
	case *IncrementResponse:
		this.Increment = vt
	case *DeleteResponse:
		this.Delete = vt
	case *DeleteRangeResponse:
		this.DeleteRange = vt
	case *ScanResponse:
		this.Scan = vt
	case *EndTransactionResponse:
		this.EndTransaction = vt
	case *ReapQueueResponse:
		this.ReapQueue = vt
	case *EnqueueUpdateResponse:
		this.EnqueueUpdate = vt
	case *EnqueueMessageResponse:
		this.EnqueueMessage = vt
	default:
		return false
	}
	return true
}
